/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.class_151;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public final class MaterialId
extends class_2960
implements MaterialVariantId {
    public MaterialId(String resourceName) {
        super(resourceName);
    }

    public MaterialId(String namespaceIn, String pathIn) {
        super(namespaceIn, pathIn);
    }

    public MaterialId(class_2960 resourceLocation) {
        super(resourceLocation.method_12836(), resourceLocation.method_12832());
    }

    public boolean matches(IMaterial material) {
        return this.equals(material.getIdentifier());
    }

    public boolean matches(class_1799 stack) {
        return !stack.method_7960() && this.equals(IMaterialItem.getMaterialFromStack(stack));
    }

    @Override
    public MaterialId getId() {
        return this;
    }

    @Override
    public String getVariant() {
        return "";
    }

    @Override
    public boolean hasVariant() {
        return false;
    }

    @Override
    public class_2960 getLocation(char separator) {
        return this;
    }

    @Override
    public boolean matchesVariant(MaterialVariantId other) {
        return this.equals(other.getId());
    }

    @Nullable
    public static MaterialId tryParse(String string) {
        try {
            return new MaterialId(string);
        }
        catch (class_151 resourcelocationexception) {
            return null;
        }
    }

    private static MaterialId parse(String text, String key) {
        MaterialId location = MaterialId.tryParse(text);
        if (location == null) {
            throw new JsonSyntaxException("Expected " + key + " to be a material ID, was '" + text + "'");
        }
        return location;
    }

    public static MaterialId fromJson(JsonObject json, String key) {
        String text = class_3518.method_15265((JsonObject)json, (String)key);
        return MaterialId.parse(text, key);
    }

    public static MaterialId convertJson(JsonElement json, String key) {
        String text = class_3518.method_15287((JsonElement)json, (String)key);
        return MaterialId.parse(text, key);
    }
}

