/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.events;

import io.github.fabricators_of_create.porting_lib.core.event.BaseEvent;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public abstract class TinkerToolEvent
extends BaseEvent {
    private final class_1799 stack;
    private final IToolStackView tool;

    public TinkerToolEvent(class_1799 stack) {
        this.stack = stack;
        this.tool = ToolStack.from(stack);
    }

    public TinkerToolEvent(class_1799 stack, IToolStackView tool) {
        this.stack = stack;
        this.tool = tool;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public IToolStackView getTool() {
        return this.tool;
    }

    public static class ToolShearEvent
    extends TinkerToolEvent {
        public static Event<ToolShear> EVENT = EventFactory.createArrayBacked(ToolShear.class, callbacks -> event -> {
            for (ToolShear e : callbacks) {
                e.onToolShear(event);
            }
        });
        private final class_1937 world;
        private final class_1657 player;
        private final class_1297 target;
        private final int fortune;

        public ToolShearEvent(class_1799 stack, IToolStackView tool, class_1937 world, class_1657 player, class_1297 target, int fortune) {
            super(stack, tool);
            this.world = world;
            this.player = player;
            this.target = target;
            this.fortune = fortune;
        }

        public BaseEvent.Result fire() {
            this.sendEvent();
            return this.getResult();
        }

        public void sendEvent() {
            ((ToolShear)EVENT.invoker()).onToolShear(this);
        }

        public class_1937 getWorld() {
            return this.world;
        }

        public class_1657 getPlayer() {
            return this.player;
        }

        public class_1297 getTarget() {
            return this.target;
        }

        public int getFortune() {
            return this.fortune;
        }

        @FunctionalInterface
        public static interface ToolShear {
            public void onToolShear(ToolShearEvent var1);
        }
    }

    public static class ToolHarvestEvent
    extends TinkerToolEvent {
        public static Event<ToolHarvest> EVENT = EventFactory.createArrayBacked(ToolHarvest.class, callbacks -> event -> {
            for (ToolHarvest e : callbacks) {
                e.onHarvest(event);
            }
        });
        private final class_1838 context;
        private final class_3218 world;
        private final class_2680 state;
        private final class_2338 pos;
        private final InteractionSource source;
        @Deprecated
        private final class_1304 slotType;

        @Deprecated
        public ToolHarvestEvent(IToolStackView tool, class_1838 context, class_3218 world, class_2680 state, class_2338 pos, class_1304 slotType) {
            super(ToolHarvestEvent.getItem(context, slotType), tool);
            this.context = context;
            this.world = world;
            this.state = state;
            this.pos = pos;
            this.source = InteractionSource.fromEquipmentSlot(slotType);
            this.slotType = slotType;
        }

        public ToolHarvestEvent(IToolStackView tool, class_1838 context, class_3218 world, class_2680 state, class_2338 pos, InteractionSource source) {
            super(ToolHarvestEvent.getItem(context, source), tool);
            this.context = context;
            this.world = world;
            this.state = state;
            this.pos = pos;
            this.source = source;
            this.slotType = source.getSlot(context.method_20287());
        }

        private static class_1799 getItem(class_1838 context, InteractionSource source) {
            class_1657 player = context.method_8036();
            if (player != null) {
                return player.method_6118(source.getSlot(context.method_20287()));
            }
            return context.method_8041();
        }

        private static class_1799 getItem(class_1838 context, class_1304 slotType) {
            class_1657 player = context.method_8036();
            if (player != null) {
                return player.method_6118(slotType);
            }
            return context.method_8041();
        }

        @Nullable
        public class_1657 getPlayer() {
            return this.context.method_8036();
        }

        public BaseEvent.Result fire() {
            this.sendEvent();
            return this.getResult();
        }

        public void sendEvent() {
            ((ToolHarvest)EVENT.invoker()).onHarvest(this);
        }

        public class_1838 getContext() {
            return this.context;
        }

        public class_3218 getWorld() {
            return this.world;
        }

        public class_2680 getState() {
            return this.state;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public InteractionSource getSource() {
            return this.source;
        }

        @Deprecated
        public class_1304 getSlotType() {
            return this.slotType;
        }

        @FunctionalInterface
        public static interface ToolHarvest {
            public void onHarvest(ToolHarvestEvent var1);
        }
    }
}

