/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7403;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.json.JsonRedirect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.dynamic.ComposableModifier;
import slimeknights.tconstruct.library.modifiers.util.DynamicModifier;

public abstract class AbstractModifierProvider
extends GenericDataProvider {
    private final Map<ModifierId, Result> allModifiers = new HashMap<ModifierId, Result>();
    private final Map<ModifierId, Composable> composableModifiers = new HashMap<ModifierId, Composable>();

    public AbstractModifierProvider(FabricDataOutput output) {
        super(output, class_3264.field_14190, "tinkering/modifiers", ModifierManager.GSON);
    }

    protected abstract void addModifiers();

    protected void addModifier(ModifierId id, @Nullable ConditionJsonProvider condition, @Nullable Modifier result, JsonRedirect ... redirects) {
        if (result == null && redirects.length == 0) {
            throw new IllegalArgumentException("Must have either a modifier or a redirect");
        }
        Result previous = this.allModifiers.putIfAbsent(id, new Result(result, condition, redirects));
        if (previous != null || this.composableModifiers.containsKey((Object)id)) {
            throw new IllegalArgumentException("Duplicate modifier " + id);
        }
    }

    protected void addModifier(ModifierId id, @Nullable Modifier result, JsonRedirect ... redirects) {
        this.addModifier(id, null, result, redirects);
    }

    protected void addModifier(DynamicModifier<?> id, @Nullable ConditionJsonProvider condition, @Nullable Modifier result, JsonRedirect ... redirects) {
        this.addModifier(id.getId(), condition, result, redirects);
    }

    protected void addModifier(DynamicModifier<?> id, @Nullable Modifier result, JsonRedirect ... redirects) {
        this.addModifier(id, null, result, redirects);
    }

    protected ComposableModifier.Builder buildModifier(ModifierId id, @Nullable ConditionJsonProvider condition, JsonRedirect ... redirects) {
        ComposableModifier.Builder builder = ComposableModifier.builder();
        Composable previous = this.composableModifiers.putIfAbsent(id, new Composable(builder, condition, redirects));
        if (previous != null || this.allModifiers.containsKey((Object)id)) {
            throw new IllegalArgumentException("Duplicate modifier " + id);
        }
        return builder;
    }

    protected ComposableModifier.Builder buildModifier(ModifierId id, JsonRedirect ... redirects) {
        return this.buildModifier(id, (ConditionJsonProvider)null, redirects);
    }

    protected ComposableModifier.Builder buildModifier(DynamicModifier<?> modifier, @Nullable ConditionJsonProvider condition, JsonRedirect ... redirects) {
        return this.buildModifier(modifier.getId(), condition, redirects);
    }

    protected ComposableModifier.Builder buildModifier(DynamicModifier<?> modifier, JsonRedirect ... redirects) {
        return this.buildModifier(modifier, (ConditionJsonProvider)null, redirects);
    }

    protected void addRedirect(ModifierId id, JsonRedirect ... redirects) {
        this.addModifier(id, (ConditionJsonProvider)null, (Modifier)null, redirects);
    }

    protected JsonRedirect conditionalRedirect(ModifierId id, @Nullable ConditionJsonProvider condition) {
        return new JsonRedirect(id, condition, null);
    }

    protected JsonRedirect redirect(ModifierId id) {
        return this.conditionalRedirect(id, null);
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.addModifiers();
        ArrayList futures = new ArrayList();
        this.allModifiers.forEach((id, data) -> futures.add(this.saveThing(cache, (class_2960)id, data.serialize())));
        this.composableModifiers.forEach((id, data) -> this.saveThing(cache, (class_2960)id, data.serialize()));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private static JsonObject serializeModifier(@Nullable Modifier modifier, @Nullable ConditionJsonProvider condition, JsonRedirect[] redirects) {
        JsonObject json = modifier != null ? ModifierManager.MODIFIER_LOADERS.serialize((GenericLoaderRegistry.IHaveLoader)modifier).getAsJsonObject() : new JsonObject();
        if (redirects.length != 0) {
            JsonArray array = new JsonArray();
            for (JsonRedirect redirect : redirects) {
                array.add((JsonElement)redirect.toJson());
            }
            json.add("redirects", (JsonElement)array);
        }
        if (condition != null) {
            json.add("fabric:load_conditions", (JsonElement)condition.toJson());
        }
        return json;
    }

    private record Result(@Nullable Modifier modifier, @Nullable ConditionJsonProvider condition, JsonRedirect[] redirects) {
        public JsonObject serialize() {
            return AbstractModifierProvider.serializeModifier(this.modifier, this.condition, this.redirects);
        }
    }

    private record Composable(ComposableModifier.Builder builder, @Nullable ConditionJsonProvider condition, JsonRedirect[] redirects) {
        public JsonObject serialize() {
            return AbstractModifierProvider.serializeModifier(this.builder.build(), this.condition, this.redirects);
        }
    }
}

