/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1059;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.IEarlySafeManagerReloadListener;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;

public class ModifierIconManager
implements IEarlySafeManagerReloadListener,
IdentifiableResourceReloadListener {
    private static final Logger log = LogManager.getLogger(ModifierIconManager.class);
    private static final String ICONS = "tinkering/modifier_icons.json";
    public static final class_2960 DEFAULT_PAGES = TConstruct.getResource("gui/modifiers/default_pages");
    public static final class_2960 DEFAULT_COVER = TConstruct.getResource("gui/modifiers/default_cover");
    public static final ModifierIconManager INSTANCE = new ModifierIconManager();
    public static Map<ModifierId, List<class_2960>> modifierIcons = Collections.emptyMap();

    public static void init() {
        ModifierIconManager.onResourceManagerRegister();
    }

    private static void onResourceManagerRegister() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
    }

    public void onReloadSafe(class_3300 manager) {
        HashMap<ModifierId, List<class_2960>> icons = new HashMap<ModifierId, List<class_2960>>();
        List jsonFiles = JsonHelper.getFileInAllDomainsAndPacks((class_3300)manager, (String)ICONS, null);
        for (int i = jsonFiles.size() - 1; i >= 0; --i) {
            JsonObject json = (JsonObject)jsonFiles.get(i);
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                ModifierId name = ModifierId.tryParse(key);
                if (name == null) {
                    log.error("Skipping invalid modifier key " + key + " as it is not a valid resource location");
                    continue;
                }
                if (icons.containsKey((Object)name)) continue;
                JsonElement element = (JsonElement)entry.getValue();
                if (element.isJsonNull()) {
                    icons.remove((Object)name);
                    continue;
                }
                if (element.isJsonArray()) {
                    JsonArray array = element.getAsJsonArray();
                    try {
                        icons.put(name, JsonHelper.parseList((JsonArray)array, (String)key, JsonHelper::convertToResourceLocation));
                    }
                    catch (JsonSyntaxException e) {
                        log.error("Skipping invalid modifier " + key + " due to error parsing path list: ", (Throwable)e);
                    }
                    continue;
                }
                if (element.isJsonPrimitive()) {
                    class_2960 path = class_2960.method_12829((String)element.getAsString());
                    if (path != null) {
                        icons.put(name, Collections.singletonList(path));
                        continue;
                    }
                    log.error("Skipping invalid modifier " + key + " as the path is invalid");
                    continue;
                }
                log.error("Skipping key " + key + " as the value is not a valid path");
            }
        }
        modifierIcons = icons;
    }

    public static void renderIcon(class_332 graphics, Modifier modifier, int x, int y, int z, int size) {
        RenderUtils.setup(class_1723.field_21668);
        class_1059 atlas = class_310.method_1551().method_1554().method_24153(class_1723.field_21668);
        List icons = modifierIcons.getOrDefault((Object)modifier.getId(), Collections.emptyList());
        if (!icons.isEmpty()) {
            for (class_2960 icon : icons) {
                graphics.method_25298(x, y, z, size, size, atlas.method_4608(icon));
            }
        } else {
            graphics.method_25298(x, y, z, size, size, atlas.method_4608(DEFAULT_PAGES));
            RenderUtils.setColorRGBA(0xFF000000 | modifier.getColor());
            graphics.method_25298(x, y, z, size, size, atlas.method_4608(DEFAULT_COVER));
            RenderUtils.setColorRGBA(-1);
        }
    }

    public class_2960 getFabricId() {
        return TConstruct.getResource("modifier_icon_manager");
    }

    private ModifierIconManager() {
    }
}

