/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_3518;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.util.ModelHelper;

public class IncrementalFluidCuboid
extends FluidCuboid {
    private final int increments;

    public IncrementalFluidCuboid(Vector3f from, Vector3f to, Map<class_2350, FluidCuboid.FluidFace> faces, int increments) {
        super(from, to, faces);
        this.increments = increments;
    }

    public class_785 getPart(long amount, boolean gas) {
        Vector3f from = this.getFrom();
        Vector3f to = this.getTo();
        float minY = from.y();
        float maxY = to.y();
        if (gas) {
            from = new Vector3f((Vector3fc)from);
            from.y = maxY + (float)amount * (minY - maxY) / (float)this.increments;
        } else {
            to = new Vector3f((Vector3fc)to);
            to.y = minY + (float)amount * (maxY - minY) / (float)this.increments;
        }
        EnumMap<class_2350, class_783> faces = new EnumMap<class_2350, class_783>(class_2350.class);
        for (Map.Entry entry : this.getFaces().entrySet()) {
            class_2350 dir = (class_2350)entry.getKey();
            FluidCuboid.FluidFace face = (FluidCuboid.FluidFace)entry.getValue();
            boolean isFlowing = face.isFlowing();
            faces.put(dir, new class_783(null, 0, isFlowing ? "flowing_fluid" : "fluid", IncrementalFluidCuboid.getFaceUvs(from, to, dir, face.rotation(), isFlowing ? 0.5f : 1.0f)));
        }
        return new class_785(from, to, faces, null, false);
    }

    private static class_787 getFaceUvs(Vector3f from, Vector3f to, class_2350 side, int rotation, float scale) {
        float temp;
        float u2;
        float v1;
        float u1;
        float v2 = switch (side) {
            case class_2350.field_11033 -> {
                u1 = from.x();
                v1 = 16.0f - to.z();
                u2 = to.x();
                yield 16.0f - from.z();
            }
            case class_2350.field_11036 -> {
                u1 = from.x();
                v1 = from.z();
                u2 = to.x();
                yield to.z();
            }
            default -> {
                u1 = 16.0f - to.x();
                v1 = 16.0f - to.y();
                u2 = 16.0f - from.x();
                yield 16.0f - from.y();
            }
            case class_2350.field_11035 -> {
                u1 = from.x();
                v1 = 16.0f - to.y();
                u2 = to.x();
                yield 16.0f - from.y();
            }
            case class_2350.field_11039 -> {
                u1 = from.z();
                v1 = 16.0f - to.y();
                u2 = to.z();
                yield 16.0f - from.y();
            }
            case class_2350.field_11034 -> {
                u1 = 16.0f - to.z();
                v1 = 16.0f - to.y();
                u2 = 16.0f - from.z();
                yield 16.0f - from.y();
            }
        };
        if (rotation >= 180) {
            temp = v1;
            v1 = 16.0f - v2;
            v2 = 16.0f - temp;
        }
        if (rotation == 90 || rotation == 180) {
            temp = u1;
            u1 = 16.0f - u2;
            u2 = 16.0f - temp;
        }
        float[] uv = rotation % 180 == 90 ? new float[]{v1 * scale, u1 * scale, v2 * scale, u2 * scale} : new float[]{u1 * scale, v1 * scale, u2 * scale, v2 * scale};
        return new class_787(uv, rotation);
    }

    public static IncrementalFluidCuboid fromJson(JsonObject json) {
        Vector3f from = ModelHelper.arrayToVector((JsonObject)json, (String)"from");
        Vector3f to = ModelHelper.arrayToVector((JsonObject)json, (String)"to");
        Map faces = IncrementalFluidCuboid.getFaces((JsonObject)json);
        int increments = class_3518.method_15260((JsonObject)json, (String)"increments");
        return new IncrementalFluidCuboid(from, to, faces, increments);
    }

    public int getIncrements() {
        return this.increments;
    }
}

