/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.minecraft.class_638;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.content.AbstractMaterialContent;
import slimeknights.tconstruct.library.client.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.tools.item.RepairKitItem;
import slimeknights.tconstruct.tools.stats.SkullStats;

public class ContentMaterialSkull
extends AbstractMaterialContent {
    private static final String SKULL_FROM = TConstruct.makeTranslationKey("book", "material.skull_from");
    public static final class_2960 ID = TConstruct.getResource("skull_material");
    protected transient IDisplayableCastingRecipe skullRecipe = null;
    private transient boolean searchedSkullRecipe = false;
    protected transient List<class_1799> skullStacks = null;

    public ContentMaterialSkull(MaterialVariantId material, boolean detailed) {
        super(material, detailed);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    @Nullable
    protected MaterialStatsId getStatType(int index) {
        return index == 0 ? SkullStats.ID : null;
    }

    @Override
    protected String getTextKey(MaterialId material) {
        return String.format(this.detailed ? "material.%s.%s.skull_encyclopedia" : "material.%s.%s.skull_flavor", material.method_12836(), material.method_12832());
    }

    @Nullable
    private IDisplayableCastingRecipe getSkullRecipe() {
        class_638 world = class_310.method_1551().field_1687;
        if (!this.searchedSkullRecipe && world != null) {
            this.skullRecipe = world.method_8433().method_30027((class_3956)TinkerRecipeTypes.CASTING_BASIN.get()).stream().filter(recipe -> recipe instanceof IDisplayableCastingRecipe).map(recipe -> (IDisplayableCastingRecipe)((Object)recipe)).filter(recipe -> {
                class_1799 output = recipe.getOutput();
                return output.method_7909() == TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET) && MaterialIdNBT.from(output).getMaterial(0).getId().toString().equals(this.materialName);
            }).findFirst().orElse(null);
            this.searchedSkullRecipe = true;
        }
        return this.skullRecipe;
    }

    @Override
    public class_2561 getTitleComponent() {
        IDisplayableCastingRecipe skullRecipe = this.getSkullRecipe();
        if (skullRecipe != null) {
            return skullRecipe.getOutput().method_7964();
        }
        return super.getTitleComponent();
    }

    @Override
    public List<class_1799> getDisplayStacks() {
        List<class_1799> skulls;
        IDisplayableCastingRecipe skullRecipe = this.getSkullRecipe();
        if (skullRecipe != null && !(skulls = skullRecipe.getCastItems()).isEmpty()) {
            return skulls;
        }
        return super.getDisplayStacks();
    }

    @Override
    protected boolean supportsStatType(MaterialStatsId statsId) {
        return statsId.equals((Object)SkullStats.ID);
    }

    @Override
    protected void addPrimaryDisplayItems(List<ItemElement> displayTools, MaterialVariantId materialId) {
        List<class_1799> casts;
        displayTools.add(new TinkerItemElement(((RepairKitItem)TinkerToolParts.repairKit.get()).withMaterialForDisplay(materialId)));
        super.addPrimaryDisplayItems(displayTools, materialId);
        IDisplayableCastingRecipe skullRecipe = this.getSkullRecipe();
        if (skullRecipe != null && !(casts = skullRecipe.getCastItems()).isEmpty()) {
            TinkerItemElement elementItem = new TinkerItemElement(0, 0, 1.0f, casts);
            elementItem.tooltip = ImmutableList.of((Object)class_2561.method_43469((String)SKULL_FROM, (Object[])new Object[]{casts.get(0).method_7964()}));
            displayTools.add(elementItem);
        }
    }
}

