/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.client.renderer;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.config.category.ClientCategory;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractDrawerBlockEntityRenderer<T extends class_2586>
implements class_827<T> {
    private static final Quaternionf ITEM_LIGHT_ROTATION_3D = class_7833.field_40714.rotationDegrees(-15.0f).mul((Quaternionfc)class_7833.field_40716.rotationDegrees(15.0f));
    private static final Quaternionf ITEM_LIGHT_ROTATION_FLAT = class_7833.field_40714.rotationDegrees(-45.0f);
    private final class_918 itemRenderer;
    private final class_327 textRenderer;
    private boolean isGui = false;

    public AbstractDrawerBlockEntityRenderer(class_918 itemRenderer, class_327 textRenderer) {
        this.itemRenderer = itemRenderer;
        this.textRenderer = textRenderer;
    }

    public static AbstractDrawerBlockEntityRenderer<class_2586> createRendererTool() {
        class_310 client = class_310.method_1551();
        AbstractDrawerBlockEntityRenderer<class_2586> renderer = new AbstractDrawerBlockEntityRenderer<class_2586>(client.method_1480(), client.field_1772){

            public void method_3569(class_2586 entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
            }
        };
        renderer.isGui = true;
        return renderer;
    }

    public void renderSlot(ItemVariant item, @Nullable String amount, boolean small, boolean hidden, List<class_1058> icons, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, int seed, class_2338 pos, class_1937 world) {
        class_746 player = class_310.method_1551().field_1724;
        class_243 playerPos = player == null ? class_243.method_24953((class_2382)pos) : player.method_19538();
        ClientCategory config = ((ConfigData)ExtendedDrawers.CONFIG.get()).client();
        if (hidden) {
            this.renderHiddenOverlay(small, light, overlay, matrices, vertexConsumers);
            return;
        }
        if (pos.method_19769((class_2374)playerPos, (double)config.textRenderDistance()) && amount != null) {
            this.renderText(amount, small, light, matrices, vertexConsumers);
        }
        if (pos.method_19769((class_2374)playerPos, (double)config.iconRenderDistance())) {
            this.renderIcons(icons, small, light, overlay, matrices, vertexConsumers);
        }
        if (pos.method_19769((class_2374)playerPos, (double)config.itemRenderDistance())) {
            this.renderItem(item, small, light, matrices, vertexConsumers, world, seed);
        }
    }

    protected void renderHiddenOverlay(boolean small, int light, int overlay, class_4587 matrices, class_4597 vertexConsumers) {
        matrices.method_22903();
        if (small) {
            matrices.method_22905(0.5f, 0.5f, 1.0f);
        }
        matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        matrices.method_22904(-0.5, 0.0, -0.5);
        class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(ExtendedDrawers.id("block/drawer_hidden_overlay"));
        QuadEmitter emitter = Objects.requireNonNull(RendererAccess.INSTANCE.getRenderer()).meshBuilder().getEmitter();
        emitter.square(class_2350.field_11036, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        emitter.spriteBake(sprite, 4);
        vertexConsumers.getBuffer(class_1921.method_23581()).method_22919(matrices.method_23760(), emitter.toBakedQuad(sprite), 1.0f, 1.0f, 1.0f, light, overlay);
        matrices.method_22909();
    }

    public final boolean shouldRender(T drawer, class_2350 facing) {
        class_1937 world = drawer.method_10997();
        if (world == null) {
            return false;
        }
        class_2338 pos = drawer.method_11016();
        class_2680 state = drawer.method_11010();
        return class_2248.method_9607((class_2680)state, (class_1922)world, (class_2338)pos, (class_2350)facing, (class_2338)pos.method_10093(facing));
    }

    public void renderIcons(List<class_1058> icons, boolean small, int light, int overlay, class_4587 matrices, class_4597 vertexConsumers) {
        double increment = 1.0 / ((double)icons.size() + 1.0);
        matrices.method_22903();
        if (small) {
            matrices.method_22905(0.5f, 0.5f, 1.0f);
        }
        matrices.method_22904(-0.5, 0.0, 0.0);
        for (class_1058 icon : icons) {
            matrices.method_22904(increment, 0.0, 0.001);
            this.renderIcon(icon, light, overlay, matrices, vertexConsumers);
        }
        matrices.method_22909();
    }

    private void renderIcon(class_1058 sprite, int light, int overlay, class_4587 matrices, class_4597 vertexConsumers) {
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        matrices.method_22904(-0.125, -0.24, -0.5);
        matrices.method_22905(0.25f, 0.25f, 0.25f);
        QuadEmitter emitter = Objects.requireNonNull(RendererAccess.INSTANCE.getRenderer()).meshBuilder().getEmitter();
        emitter.square(class_2350.field_11036, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        emitter.spriteBake(sprite, 4);
        vertexConsumers.getBuffer(class_1921.method_23581()).method_22919(matrices.method_23760(), emitter.toBakedQuad(sprite), 1.0f, 1.0f, 1.0f, light, overlay);
        matrices.method_22909();
    }

    public void renderItem(ItemVariant item, boolean small, int light, class_4587 matrices, class_4597 vertexConsumers, class_1937 world, int seed) {
        if (item.isBlank()) {
            return;
        }
        float itemScale = ((ConfigData)ExtendedDrawers.CONFIG.get()).client().layout().itemScale(small);
        matrices.method_22903();
        matrices.method_22905(itemScale, itemScale, 1.0f);
        matrices.method_22905(0.75f, 0.75f, 1.0f);
        matrices.method_34425(new Matrix4f().scale(1.0f, 1.0f, 0.01f));
        class_1799 stack = item.toStack();
        class_1087 model = this.itemRenderer.method_4019(stack, world, null, seed);
        if (this.isGui) {
            class_308.method_24210();
        } else if (model.method_24304()) {
            matrices.method_23760().method_23762().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_3D);
        } else {
            matrices.method_23760().method_23762().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_FLAT);
        }
        this.itemRenderer.method_23179(stack, class_811.field_4317, false, matrices, vertexConsumers, light, class_4608.field_21444, model);
        if (this.isGui) {
            class_308.method_24210();
        }
        matrices.method_22909();
    }

    public void renderText(String amount, boolean small, int light, class_4587 matrices, class_4597 vertexConsumers) {
        ClientCategory config = ((ConfigData)ExtendedDrawers.CONFIG.get()).client();
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        if (small) {
            matrices.method_22904(0.0, 0.25, -0.01);
        } else {
            matrices.method_22904(0.0, 0.5, -0.01);
        }
        matrices.method_22905(config.layout().textScale(small), config.layout().textScale(small), 1.0f);
        matrices.method_22904(0.0, (double)(config.layout().textOffset() / -4.0f), -0.01);
        matrices.method_22905(0.02f, 0.02f, 0.02f);
        this.textRenderer.method_27521(amount, (float)(-this.textRenderer.method_1727(amount)) / 2.0f, 0.0f, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, light);
        matrices.method_22909();
    }

    protected void alignMatrices(class_4587 matrices, class_2350 dir, class_2738 face) {
        Vector3f pos = switch (face) {
            case class_2738.field_12475 -> class_2350.field_11036.method_23955();
            case class_2738.field_12473 -> class_2350.field_11033.method_23955();
            default -> dir.method_23955();
        };
        matrices.method_22904((double)(pos.x / 2.0f) + 0.5, (double)(pos.y / 2.0f) + 0.5, (double)(pos.z / 2.0f) + 0.5);
        matrices.method_34425(new Matrix4f().rotation((Quaternionfc)dir.method_23224()));
        switch (face) {
            case field_12475: {
                matrices.method_34425(new Matrix4f().rotation((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f)));
                break;
            }
            case field_12473: {
                matrices.method_34425(new Matrix4f().rotation((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f)));
            }
        }
        matrices.method_34425(new Matrix4f().rotation((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f)));
        matrices.method_22904(0.0, 0.0, 0.01);
    }
}

