/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.enchantmentlevelbreak.mixin;

import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.prizowo.enchantmentlevelbreak.config.ModConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1887.class})
public class EnchantmentMixin {
    @Unique
    private static final int[] ROMAN_VALUES = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    @Unique
    private static final String[] ROMAN_SYMBOLS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};

    @Unique
    private static String toRoman(int number) {
        if (number <= 0) {
            return "0";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < ROMAN_VALUES.length && number > 0; ++i) {
            while (number >= ROMAN_VALUES[i]) {
                result.append(ROMAN_SYMBOLS[i]);
                number -= ROMAN_VALUES[i];
            }
        }
        return result.toString();
    }

    @Inject(method={"getName"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetName(int level, CallbackInfoReturnable<class_2561> cir) {
        class_1887 enchantment = (class_1887)this;
        ModConfig config = ModConfig.getInstance();
        class_5250 name = class_2561.method_43471((String)enchantment.method_8184());
        if (((class_1887)this).method_8195()) {
            name.method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
        } else {
            name.method_10862(class_2583.field_24360.method_10977(class_124.field_1080));
        }
        if (level != 1) {
            name.method_27693(" ");
            if (config.isUseRomanNumerals() && level <= config.getRomanNumeralsThreshold()) {
                name.method_27693(EnchantmentMixin.toRoman(level));
            } else {
                name.method_27693(String.valueOf(level));
            }
        }
        cir.setReturnValue((Object)name);
        cir.cancel();
    }

    @Inject(method={"isAcceptableItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsAcceptableItem(class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (ModConfig.getInstance().isAllowAnyEnchantment()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"canCombine"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCanCombine(class_1887 other, CallbackInfoReturnable<Boolean> cir) {
        if (ModConfig.getInstance().isAllowAnyEnchantment()) {
            cir.setReturnValue((Object)true);
        }
    }
}

