/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.enchantmentlevelbreak.mixin;

import java.util.Map;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.prizowo.enchantmentlevelbreak.config.ModConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1706.class})
public abstract class AnvilMenuMixin
extends class_4861 {
    @Shadow
    private int field_7776;
    @Shadow
    private final class_3915 field_7770 = class_3915.method_17403();

    protected AnvilMenuMixin(class_3917<?> type, int syncId, class_1661 playerInventory, class_3914 context) {
        super(type, syncId, playerInventory, context);
    }

    @Unique
    private boolean canEnchant(class_1799 item, class_1887 enchantment) {
        return item.method_31574(class_1802.field_8598) || ModConfig.getInstance().isAllowAnyEnchantment() || enchantment.method_8192(item);
    }

    @Unique
    private boolean isEnchantmentCompatible(class_1887 newEnchant, Map<class_1887, Integer> existingEnchants) {
        if (ModConfig.getInstance().isAllowAnyEnchantment()) {
            return true;
        }
        return existingEnchants.keySet().stream().allMatch(existing -> newEnchant == existing || newEnchant.method_8188(existing));
    }

    @Inject(method={"updateResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdateResult(CallbackInfo ci) {
        class_1799 right;
        class_1799 left = this.field_22480.method_5438(0);
        if (!this.isValidAnvilOperation(left, right = this.field_22480.method_5438(1))) {
            return;
        }
        Map leftEnchants = class_1890.method_8222((class_1799)left);
        Map rightEnchants = class_1890.method_8222((class_1799)right);
        if (!rightEnchants.isEmpty() || right.method_31574(class_1802.field_8598)) {
            class_1799 result = left.method_7972();
            boolean anyEnchantmentApplied = false;
            for (Map.Entry entry : rightEnchants.entrySet()) {
                class_1887 enchantment = (class_1887)entry.getKey();
                int rightLevel = (Integer)entry.getValue();
                if (!this.canEnchant(result, enchantment) || !this.isEnchantmentCompatible(enchantment, leftEnchants)) continue;
                int leftLevel = leftEnchants.getOrDefault(enchantment, 0);
                int newLevel = this.calculateNewLevel(leftLevel, rightLevel);
                leftEnchants.put(enchantment, newLevel);
                anyEnchantmentApplied = true;
            }
            if (anyEnchantmentApplied) {
                class_1890.method_8214((Map)leftEnchants, (class_1799)result);
                this.field_22479.method_5447(0, result);
                int totalCost = leftEnchants.values().stream().mapToInt(Integer::intValue).sum();
                this.field_7770.method_17404(Math.min(totalCost, 50));
                this.field_7776 = 1;
                ci.cancel();
            }
        }
    }

    @Unique
    private boolean isValidAnvilOperation(class_1799 left, class_1799 right) {
        return !left.method_7960() && !right.method_7960() && (!left.method_31574(class_1802.field_8598) || right.method_31574(class_1802.field_8598));
    }

    @Unique
    private int calculateNewLevel(int leftLevel, int rightLevel) {
        if (leftLevel <= 0) {
            return rightLevel;
        }
        if (ModConfig.getInstance().isAllowLevelStacking()) {
            return leftLevel + rightLevel;
        }
        return leftLevel == rightLevel ? leftLevel + 1 : Math.max(leftLevel, rightLevel);
    }
}

