/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.enchantmentlevelbreak.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("enchantmentlevelbreak.json");
    private static ModConfig INSTANCE;
    private boolean useRomanNumerals = true;
    private boolean allowAnyEnchantment = false;
    private boolean allowLevelStacking = false;
    private int romanNumeralsThreshold = 5000;
    private int maxEnchantmentLevel = Integer.MAX_VALUE;

    public static ModConfig getInstance() {
        if (INSTANCE == null) {
            ModConfig.load();
        }
        return INSTANCE;
    }

    public boolean isUseRomanNumerals() {
        return this.useRomanNumerals;
    }

    public boolean isAllowAnyEnchantment() {
        return this.allowAnyEnchantment;
    }

    public boolean isAllowLevelStacking() {
        return this.allowLevelStacking;
    }

    public int getRomanNumeralsThreshold() {
        return this.romanNumeralsThreshold;
    }

    public int getMaxEnchantmentLevel() {
        return this.maxEnchantmentLevel;
    }

    public void setUseRomanNumerals(boolean useRomanNumerals) {
        this.useRomanNumerals = useRomanNumerals;
        this.save();
    }

    public void setAllowAnyEnchantment(boolean allowAnyEnchantment) {
        this.allowAnyEnchantment = allowAnyEnchantment;
        this.save();
    }

    public void setAllowLevelStacking(boolean allowLevelStacking) {
        this.allowLevelStacking = allowLevelStacking;
        this.save();
    }

    public void setRomanNumeralsThreshold(int threshold) {
        this.romanNumeralsThreshold = threshold;
        this.save();
    }

    public void setMaxEnchantmentLevel(int level) {
        if (level < 255) {
            level = 255;
        } else if (level > Integer.MAX_VALUE) {
            level = Integer.MAX_VALUE;
        }
        this.maxEnchantmentLevel = level;
        this.save();
    }

    public static void load() {
        block9: {
            try {
                if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                        INSTANCE = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
                        break block9;
                    }
                }
                INSTANCE = new ModConfig();
                INSTANCE.save();
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
                INSTANCE = new ModConfig();
            }
        }
    }

    private void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }
}

