/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.util;

import dev.hexnowloading.dungeonnowloading.registry.DNLGameEvents;
import dev.hexnowloading.dungeonnowloading.util.event_managers.BlockDestructionManager;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5712;

public class DNLLevelUtil {
    private static Set<class_2498> pendingBlockBreakSounds = null;

    public static void beginMultiDestroySoundPending() {
        pendingBlockBreakSounds = new HashSet<class_2498>();
    }

    public static boolean destroyBlockMulti(class_1937 level, class_2338 pos, boolean dropBlock, @Nullable class_1297 entity, int flags) {
        BlockDestructionManager.reset();
        level.method_43276(DNLGameEvents.BLOCK_DESTROY_EARLY.get(), pos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)level.method_8320(pos)));
        if (BlockDestructionManager.shouldCancel()) {
            return false;
        }
        class_2680 blockState = level.method_8320(pos);
        if (blockState.method_26215()) {
            return false;
        }
        class_3610 fluidState = level.method_8316(pos);
        if (dropBlock) {
            class_2586 blockEntity = blockState.method_31709() ? level.method_8321(pos) : null;
            class_2248.method_9511((class_2680)blockState, (class_1937)level, (class_2338)pos, (class_2586)blockEntity, (class_1297)entity, (class_1799)class_1799.field_8037);
        }
        if (pendingBlockBreakSounds != null) {
            pendingBlockBreakSounds.add(blockState.method_26231());
            DNLLevelUtil.spawnDestroyParticles(level, pos, blockState);
        } else {
            level.method_20290(2001, pos, class_2248.method_9507((class_2680)blockState));
        }
        boolean success = level.method_30092(pos, fluidState.method_15759(), 3, flags);
        if (success) {
            level.method_43276(class_5712.field_28165, pos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)blockState));
        }
        return success;
    }

    public static void endMultiDestroySoundPending(class_1937 level, @Nullable class_1297 soundSourceEntity) {
        if (pendingBlockBreakSounds != null) {
            for (class_2498 soundType : pendingBlockBreakSounds) {
                DNLLevelUtil.playBreakSound(level, soundSourceEntity, soundType);
            }
            pendingBlockBreakSounds = null;
        }
    }

    public static void spawnDestroyParticles(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        if (blockState.method_26215() || !blockState.method_45475()) {
            return;
        }
        class_265 shape = blockState.method_26218((class_1922)level, blockPos);
        shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double sizeX = Math.min(1.0, maxX - minX);
            double sizeY = Math.min(1.0, maxY - minY);
            double sizeZ = Math.min(1.0, maxZ - minZ);
            int stepsX = Math.max(2, class_3532.method_15384((double)(sizeX / 0.25)));
            int stepsY = Math.max(2, class_3532.method_15384((double)(sizeY / 0.25)));
            int stepsZ = Math.max(2, class_3532.method_15384((double)(sizeZ / 0.25)));
            for (int ix = 0; ix < stepsX; ++ix) {
                for (int iy = 0; iy < stepsY; ++iy) {
                    for (int iz = 0; iz < stepsZ; ++iz) {
                        double px = ((double)ix + 0.5) / (double)stepsX;
                        double py = ((double)iy + 0.5) / (double)stepsY;
                        double pz = ((double)iz + 0.5) / (double)stepsZ;
                        double worldX = minX + px * sizeX;
                        double worldY = minY + py * sizeY;
                        double worldZ = minZ + pz * sizeZ;
                        if (!(level instanceof class_3218)) continue;
                        class_3218 serverLevel = (class_3218)level;
                        serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11217, blockState), (double)blockPos.method_10263() + worldX, (double)blockPos.method_10264() + worldY, (double)blockPos.method_10260() + worldZ, 1, px - 0.5, py - 0.5, pz - 0.5, 0.0);
                    }
                }
            }
        });
    }

    public static void playBreakSound(class_1937 level, @Nullable class_1297 entity, class_2498 soundType) {
        if (entity != null) {
            level.method_45445(entity, entity.method_24515(), soundType.method_10595(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
        }
    }
}

