/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.sound;

import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.sound.DNLClientSoundHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_4235;

public class BackgroundMusicHandler {
    private static final List<FadingChannel> fadingChannels = new ArrayList<FadingChannel>();

    public static boolean isBackgroundMusicBlocked() {
        return DNLClientSoundHandler.isTickingSoundActive(DNLSounds.MUSIC_CLASH_OF_DUALITY_BASE.get().method_14833());
    }

    public static void fadeOutCurrentMusic(int fadeTicks) {
        class_4235.class_4236 handle;
        class_310 mc = class_310.method_1551();
        class_1113 music = mc.method_1538().field_5574;
        if (music != null && (handle = (class_4235.class_4236)mc.method_1483().field_5590.field_18950.get(music)) != null) {
            BackgroundMusicHandler.startFading(handle, fadeTicks);
        }
    }

    private static void startFading(class_4235.class_4236 handle, int fadeTicks) {
        fadingChannels.add(new FadingChannel(handle, fadeTicks));
    }

    public static void tick() {
        Iterator<FadingChannel> iterator = fadingChannels.iterator();
        while (iterator.hasNext()) {
            FadingChannel fading = iterator.next();
            if (fading.tick()) continue;
            iterator.remove();
        }
    }

    private static class FadingChannel {
        private final class_4235.class_4236 handle;
        private final int totalTicks;
        private int currentTick = 0;

        FadingChannel(class_4235.class_4236 handle, int totalTicks) {
            this.handle = handle;
            this.totalTicks = totalTicks;
        }

        boolean tick() {
            if (this.currentTick >= this.totalTicks) {
                this.handle.method_19735(channel -> {
                    channel.method_19647(0.0f);
                    channel.method_19655();
                });
                return false;
            }
            float volume = 1.0f - (float)this.currentTick / (float)this.totalTicks;
            this.handle.method_19735(channel -> channel.method_19647(volume));
            ++this.currentTick;
            return true;
        }
    }
}

