/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.potion;

import dev.hexnowloading.dungeonnowloading.components.VertexNode;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.util.DNLMath;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3419;
import net.minecraft.class_4081;
import net.minecraft.class_5131;

public class VertexTransmissionEffect
extends class_1291 {
    private static final int DAMAGE_TICK_INTERVAL = 10;
    private static final float BASE_DAMAGE = 1.0f;
    private static final float DAMAGE_MULTIPLIER_PER_CONNECTION = 1.0f;
    private static final HashMap<UUID, VertexNode> entityVertexNodeMap = new HashMap();
    private static final HashMap<UUID, Integer> damageTickCountMap = new HashMap();
    private static final HashMap<UUID, Boolean> isReconnectionCaseMap = new HashMap();
    private static final HashMap<UUID, Boolean> isNoConnectionBeamDamageCaseMap = new HashMap();

    public VertexTransmissionEffect() {
        super(class_4081.field_18272, 0xE60000);
    }

    public VertexNode getVertexNode(UUID uuid) {
        return entityVertexNodeMap.get(uuid);
    }

    public void markAsReconnectionCase(UUID uuid) {
        isReconnectionCaseMap.put(uuid, true);
    }

    public void setNoConnectionBeamDamageCase(UUID uuid, boolean isCase) {
        isNoConnectionBeamDamageCaseMap.put(uuid, isCase);
    }

    public void method_5572(class_1309 entity, int amplifier) {
        UUID uuid = entity.method_5667();
        entityVertexNodeMap.computeIfAbsent(uuid, id -> new VertexNode((class_1297)entity));
        damageTickCountMap.putIfAbsent(uuid, 5);
        isReconnectionCaseMap.putIfAbsent(uuid, false);
        isNoConnectionBeamDamageCaseMap.putIfAbsent(uuid, false);
        VertexNode vertexNode = entityVertexNodeMap.get(uuid);
        int damageTickCount = damageTickCountMap.get(uuid);
        boolean isNoConnectionBeamDamageCase = isNoConnectionBeamDamageCaseMap.get(uuid);
        if (damageTickCount == 0) {
            float damageAmount = 1.0f * (1.0f * (float)vertexNode.getConnectionCount());
            if (damageAmount > 0.0f || isNoConnectionBeamDamageCase) {
                if (isNoConnectionBeamDamageCase) {
                    damageAmount = 1.0f;
                    this.setNoConnectionBeamDamageCase(uuid, false);
                }
                entity.method_5643(entity.method_37908().method_48963().method_48831(), damageAmount);
                entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), DNLSounds.VERTEX_ARROW_DAMAGE.get(), class_3419.field_15254, 1.0f, 1.2f / (DNLMath.randomRange(0.0f, 1.0f) * 0.2f + 0.9f));
            }
            damageTickCountMap.put(uuid, 10);
        } else {
            damageTickCountMap.put(uuid, damageTickCount - 1);
        }
        if (!(entity.method_29504() || vertexNode.connectionLimitReached() || vertexNode.attemptedConnection())) {
            vertexNode.connectToNearbyNodes((class_1297)entity, isReconnectionCaseMap.get(uuid));
        }
        vertexNode.tick((class_1297)entity);
    }

    public void method_5562(class_1309 entity, class_5131 attributeMap, int amplifier) {
        UUID uuid = entity.method_5667();
        VertexNode vertexNode = entityVertexNodeMap.get(uuid);
        if (vertexNode != null) {
            vertexNode.disconnect_all();
        }
        entityVertexNodeMap.remove(uuid);
        damageTickCountMap.remove(uuid);
        isReconnectionCaseMap.remove(uuid);
        super.method_5562(entity, attributeMap, amplifier);
    }

    public boolean method_5552(int duration, int amplifier) {
        return duration > 0;
    }
}

