/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.network.packets;

import dev.hexnowloading.dungeonnowloading.network.ClientUtil;
import dev.hexnowloading.dungeonnowloading.network.DNLPacket;
import dev.hexnowloading.dungeonnowloading.sound.DNLClientSoundHandler;
import dev.hexnowloading.dungeonnowloading.sound.TickingSoundTarget;
import javax.annotation.Nullable;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class S2CStopTickingSoundPacket
implements DNLPacket {
    private final int entityId;
    private final class_2960 soundId;
    private final TickingSoundTarget target;
    private final int tagId;
    private final int fadeTicks;
    private final boolean shouldStop;

    public S2CStopTickingSoundPacket(int entityId, class_2960 soundId, int fadeTicks, boolean shouldStop) {
        this(entityId, soundId, TickingSoundTarget.OLDEST, -1, fadeTicks, shouldStop);
    }

    public S2CStopTickingSoundPacket(int entityId, class_2960 soundId, TickingSoundTarget target, int fadeTicks, boolean shouldStop) {
        this(entityId, soundId, target, -1, fadeTicks, shouldStop);
    }

    public S2CStopTickingSoundPacket(int entityId, class_2960 soundId, int tagId, int fadeTicks, boolean shouldStop) {
        this(entityId, soundId, TickingSoundTarget.SPECIFIC, tagId, fadeTicks, shouldStop);
    }

    public S2CStopTickingSoundPacket(int entityId, class_2960 soundId, TickingSoundTarget target, int tagId, int fadeTicks, boolean shouldStop) {
        this.entityId = entityId;
        this.soundId = soundId;
        this.target = target;
        this.tagId = tagId;
        this.fadeTicks = fadeTicks;
        this.shouldStop = shouldStop;
    }

    public S2CStopTickingSoundPacket(class_2540 buf) {
        this.entityId = buf.method_10816();
        this.soundId = buf.method_10810();
        this.target = (TickingSoundTarget)buf.method_10818(TickingSoundTarget.class);
        this.tagId = buf.method_10816();
        this.fadeTicks = buf.method_10816();
        this.shouldStop = buf.readBoolean();
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10804(this.entityId);
        buf.method_10812(this.soundId);
        buf.method_10817((Enum)this.target);
        buf.method_10804(this.tagId);
        buf.method_10804(this.fadeTicks);
        buf.writeBoolean(this.shouldStop);
    }

    public static S2CStopTickingSoundPacket decode(class_2540 buf) {
        return new S2CStopTickingSoundPacket(buf);
    }

    @Override
    public void handle(@Nullable class_3222 sender) {
        if (sender != null) {
            return;
        }
        if (ClientUtil.onClient()) {
            DNLClientSoundHandler.fadeOutTickingSound(this.soundId, this.entityId, this.target, this.tagId, this.fadeTicks, this.shouldStop);
        }
    }
}

