/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.network.packets;

import dev.hexnowloading.dungeonnowloading.network.ClientUtil;
import dev.hexnowloading.dungeonnowloading.network.DNLPacket;
import dev.hexnowloading.dungeonnowloading.sound.DNLClientSoundHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class S2CStartTickingSoundPacket
implements DNLPacket {
    private final int entityId;
    private final class_2960 soundId;
    private final class_3419 soundSource;
    private final int tagId;
    private final float maxVolume;
    private final float pitch;
    private final boolean stopWhenOutOfRange;
    private final float range;
    private final float fadeStartDistance;

    public S2CStartTickingSoundPacket(int entityId, class_2960 soundId, class_3419 soundSource, int tagId, float maxVolume, float pitch, boolean stopWhenOutOfRange, float range, float fadeStartDistance) {
        this.entityId = entityId;
        this.soundId = soundId;
        this.soundSource = soundSource;
        this.tagId = tagId;
        this.maxVolume = maxVolume;
        this.pitch = pitch;
        this.stopWhenOutOfRange = stopWhenOutOfRange;
        this.range = range;
        this.fadeStartDistance = fadeStartDistance;
    }

    public S2CStartTickingSoundPacket(int entityId, class_2960 soundId, class_3419 soundSource) {
        this(entityId, soundId, soundSource, -1, 1.0f, 1.0f, true, 32.0f, 0.0f);
    }

    public S2CStartTickingSoundPacket(int entityId, class_2960 soundId, class_3419 soundSource, float maxVolume, float pitch, boolean stopWhenOutOfRange, float range) {
        this(entityId, soundId, soundSource, -1, maxVolume, pitch, stopWhenOutOfRange, range, 0.0f);
    }

    public S2CStartTickingSoundPacket(int entityId, class_2960 soundId, class_3419 soundSource, float maxVolume, float pitch, boolean stopWhenOutOfRange, float range, float fadeStartDistance) {
        this(entityId, soundId, soundSource, -1, maxVolume, pitch, stopWhenOutOfRange, range, fadeStartDistance);
    }

    public S2CStartTickingSoundPacket(class_2540 buf) {
        this.entityId = buf.method_10816();
        this.soundId = buf.method_10810();
        this.soundSource = (class_3419)buf.method_10818(class_3419.class);
        this.tagId = buf.readInt();
        this.maxVolume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.stopWhenOutOfRange = buf.readBoolean();
        this.range = buf.readFloat();
        this.fadeStartDistance = buf.readFloat();
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10804(this.entityId);
        buf.method_10812(this.soundId);
        buf.method_10817((Enum)this.soundSource);
        buf.writeInt(this.tagId);
        buf.writeFloat(this.maxVolume);
        buf.writeFloat(this.pitch);
        buf.writeBoolean(this.stopWhenOutOfRange);
        buf.writeFloat(this.range);
        buf.writeFloat(this.fadeStartDistance);
    }

    public static S2CStartTickingSoundPacket decode(class_2540 buf) {
        return new S2CStartTickingSoundPacket(buf);
    }

    @Override
    public void handle(@Nullable class_3222 sender) {
        if (sender != null) {
            return;
        }
        if (ClientUtil.onClient()) {
            class_1937 level = ClientUtil.getClientLevel();
            if (level == null) {
                return;
            }
            class_1297 entity = level.method_8469(this.entityId);
            if (entity == null) {
                return;
            }
            DNLClientSoundHandler.playTickingSound(this.soundId, this.soundSource, entity, this.tagId, this.maxVolume, this.pitch, this.stopWhenOutOfRange, this.range, this.fadeStartDistance);
        }
    }
}

