/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.network.packets;

import dev.hexnowloading.dungeonnowloading.network.ClientUtil;
import dev.hexnowloading.dungeonnowloading.network.DNLPacket;
import dev.hexnowloading.dungeonnowloading.sound.DNLClientSoundHandler;
import dev.hexnowloading.dungeonnowloading.sound.TickingSoundTarget;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class S2CFadeInTickingSoundPacket
implements DNLPacket {
    private final int entityId;
    private final class_2960 soundId;
    private final TickingSoundTarget target;
    private final int tagId;
    private final float maxVolume;
    private final int fadeInTicks;

    public S2CFadeInTickingSoundPacket(int entityId, class_2960 soundId) {
        this(entityId, soundId, TickingSoundTarget.OLDEST, -1, 1.0f, 20);
    }

    public S2CFadeInTickingSoundPacket(int entityId, class_2960 soundId, float maxVolume, int fadeInTicks) {
        this(entityId, soundId, TickingSoundTarget.OLDEST, -1, maxVolume, fadeInTicks);
    }

    public S2CFadeInTickingSoundPacket(int entityId, class_2960 soundId, TickingSoundTarget target, float maxVolume, int fadeInTicks) {
        this(entityId, soundId, target, -1, maxVolume, fadeInTicks);
    }

    public S2CFadeInTickingSoundPacket(int entityId, class_2960 soundId, TickingSoundTarget target, int tagId, float maxVolume, int fadeInTicks) {
        this.entityId = entityId;
        this.soundId = soundId;
        this.target = target;
        this.tagId = tagId;
        this.maxVolume = maxVolume;
        this.fadeInTicks = fadeInTicks;
    }

    public S2CFadeInTickingSoundPacket(class_2540 buf) {
        this.entityId = buf.method_10816();
        this.soundId = buf.method_10810();
        this.target = (TickingSoundTarget)buf.method_10818(TickingSoundTarget.class);
        this.tagId = buf.method_10816();
        this.maxVolume = buf.readFloat();
        this.fadeInTicks = buf.method_10816();
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10804(this.entityId);
        buf.method_10812(this.soundId);
        buf.method_10817((Enum)this.target);
        buf.method_10804(this.tagId);
        buf.writeFloat(this.maxVolume);
        buf.method_10804(this.fadeInTicks);
    }

    public static S2CFadeInTickingSoundPacket decode(class_2540 buf) {
        return new S2CFadeInTickingSoundPacket(buf);
    }

    @Override
    public void handle(@Nullable class_3222 sender) {
        if (sender != null) {
            return;
        }
        if (ClientUtil.onClient()) {
            DNLClientSoundHandler.fadeInTickingSound(this.soundId, this.entityId, this.target, this.tagId, this.maxVolume, this.fadeInTicks);
        }
    }
}

