/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.item.client;

import dev.hexnowloading.dungeonnowloading.item.DNLAnimatedItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class ItemAnimationState {
    private static final String ANIMATIONS_TAG = "Animations";

    public static void start(class_1799 stack, String animationName, long gameTime, long duration, boolean loop, boolean resetAnimations) {
        ItemAnimationState.ensureUUID(stack);
        if (resetAnimations) {
            ItemAnimationState.stopAll(stack);
        }
        class_2487 tag = stack.method_7948();
        class_2487 animationsTag = tag.method_10562(ANIMATIONS_TAG);
        class_2487 animTag = new class_2487();
        animTag.method_10544("StartTime", gameTime);
        animTag.method_10544("Duration", duration);
        animTag.method_10556("Looping", loop);
        animationsTag.method_10566(animationName, (class_2520)animTag);
        tag.method_10566(ANIMATIONS_TAG, (class_2520)animationsTag);
    }

    public static void startIfStopped(class_1799 stack, String animationName, long gameTime, long duration, boolean loop, boolean resetAnimations) {
        if (!ItemAnimationState.isAnimating(stack, animationName, gameTime)) {
            ItemAnimationState.start(stack, animationName, gameTime, duration, loop, resetAnimations);
        }
    }

    public static float getProgress(class_1799 stack, String animationName, long gameTime, float partialTicks) {
        if (!stack.method_7985()) {
            return 0.0f;
        }
        class_2487 animationsTag = stack.method_7969().method_10562(ANIMATIONS_TAG);
        if (!animationsTag.method_10545(animationName)) {
            return 0.0f;
        }
        class_2487 animTag = animationsTag.method_10562(animationName);
        long startTime = animTag.method_10537("StartTime");
        long duration = animTag.method_10537("Duration");
        if (duration <= 0L) {
            return 0.0f;
        }
        float progress = ((float)gameTime + partialTicks - (float)startTime) / (float)duration;
        return Math.min(progress, 1.0f);
    }

    public static String getCurrentAnimation(class_1799 stack, long gameTime) {
        if (!stack.method_7985()) {
            return null;
        }
        class_2487 animationsTag = stack.method_7969().method_10562(ANIMATIONS_TAG);
        for (String key : animationsTag.method_10541()) {
            class_2487 animTag = animationsTag.method_10562(key);
            long startTime = animTag.method_10537("StartTime");
            long duration = animTag.method_10537("Duration");
            boolean looping = animTag.method_10577("Looping");
            if (!looping && gameTime - startTime >= duration) continue;
            return key;
        }
        return null;
    }

    public static boolean isAnimating(class_1799 stack, String animationName, long gameTime) {
        if (!stack.method_7985()) {
            return false;
        }
        class_2487 animationsTag = stack.method_7969().method_10562(ANIMATIONS_TAG);
        if (!animationsTag.method_10545(animationName)) {
            return false;
        }
        class_2487 animTag = animationsTag.method_10562(animationName);
        long startTime = animTag.method_10537("StartTime");
        long duration = animTag.method_10537("Duration");
        boolean looping = animTag.method_10577("Looping");
        return looping || gameTime - startTime < duration;
    }

    public static boolean isAnimatingOrHanging(class_1799 stack, String animationName, long gameTime) {
        if (!stack.method_7985()) {
            return false;
        }
        class_2487 animationsTag = stack.method_7969().method_10562(ANIMATIONS_TAG);
        if (!animationsTag.method_10545(animationName)) {
            return false;
        }
        class_2487 animTag = animationsTag.method_10562(animationName);
        long startTime = animTag.method_10537("StartTime");
        long duration = animTag.method_10537("Duration");
        boolean looping = animTag.method_10577("Looping");
        return looping || gameTime - startTime < duration || !looping && gameTime - startTime >= duration;
    }

    public static boolean isAnimationHanging(class_1799 stack, String animationName, long gameTime) {
        if (!stack.method_7985()) {
            return false;
        }
        class_2487 animationsTag = stack.method_7969().method_10562(ANIMATIONS_TAG);
        if (!animationsTag.method_10545(animationName)) {
            return false;
        }
        class_2487 animTag = animationsTag.method_10562(animationName);
        long startTime = animTag.method_10537("StartTime");
        long duration = animTag.method_10537("Duration");
        boolean looping = animTag.method_10577("Looping");
        return !looping && gameTime - startTime >= duration;
    }

    public static void stopAll(class_1799 itemStack) {
        if (!itemStack.method_7985()) {
            return;
        }
        class_2487 tag = itemStack.method_7969();
        if (tag.method_10545(ANIMATIONS_TAG)) {
            tag.method_10551(ANIMATIONS_TAG);
        }
    }

    private static void ensureUUID(class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof DNLAnimatedItem) {
            DNLAnimatedItem dnlAnimatedItem = (DNLAnimatedItem)class_17922;
            dnlAnimatedItem.ensureItemUUID(itemStack);
        }
    }
}

