/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.item;

import dev.hexnowloading.dungeonnowloading.config.GeneralConfig;
import dev.hexnowloading.dungeonnowloading.entity.projectile.FlameProjectileEntity;
import dev.hexnowloading.dungeonnowloading.item.DNLAnimatedItem;
import dev.hexnowloading.dungeonnowloading.item.DNLAnimationState;
import dev.hexnowloading.dungeonnowloading.item.client.ItemAnimationState;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStartTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStopTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5244;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ScorcherItem
extends class_1792
implements DNLAnimatedItem<ScorcherAnimationState> {
    private static final String HEAT_TAG = "ScorcherHeat";
    private static final String HEAT_TIME_STAMP = "ScorcherTimeStamp";
    private static final String BURN_TIME = "BurnTime";
    private static final Map<class_1792, FuelProperties> FUEL_TYPE = new HashMap<class_1792, FuelProperties>();

    public ScorcherItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (hand != class_1268.field_5808) {
            return class_1271.method_22431((Object)stack);
        }
        if (ItemAnimationState.isAnimating(stack, ScorcherAnimationState.SCORCHER_STOP.getName(), level.method_8510())) {
            return class_1271.method_22431((Object)stack);
        }
        if (!this.hasFuel(player)) {
            return class_1271.method_22431((Object)stack);
        }
        if (ItemAnimationState.isAnimating(stack, ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), level.method_8510())) {
            if (!level.field_9236) {
                ItemAnimationState.start(stack, ScorcherAnimationState.SCORCHER_STALLING.getName(), level.method_8510(), 20L, false, false);
                this.playScorcherSounds(stack, player, DNLSounds.SCORCHER_STALL.get(), DNLSounds.SOUL_SCORCHER_STALL.get());
            }
            return class_1271.method_22431((Object)stack);
        }
        player.method_6019(hand);
        if (!level.field_9236) {
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22431((Object)stack);
    }

    private boolean hasFuel(class_1657 player) {
        if (player.method_31549().field_7477) {
            return true;
        }
        class_1799 offHandItem = player.method_6079();
        if (FUEL_TYPE.containsKey(offHandItem.method_7909())) {
            return true;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 itemStack = player.method_31548().method_5438(i);
            if (!FUEL_TYPE.containsKey(itemStack.method_7909())) continue;
            return true;
        }
        return false;
    }

    public class_1839 method_7853(class_1799 $$0) {
        return super.method_7853($$0);
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 itemStack, int remainingUseDuration) {
        if (level.field_9236) {
            return;
        }
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        int chargeTime = this.method_7881(itemStack) - remainingUseDuration;
        long gameTime = player.method_37908().method_8510();
        float overHeatedDuration = 1.3333334f;
        int activeAnimDuration = 25;
        int shootAnimDuration = (int)(120.0f + (float)activeAnimDuration);
        if (ItemAnimationState.isAnimating(itemStack, ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), level.method_8510())) {
            return;
        }
        if (chargeTime == 0) {
            ItemAnimationState.start(itemStack, ScorcherAnimationState.SCORCHER_ACTIVATED.getName(), gameTime, 25L, false, true);
            this.playScorcherSounds(itemStack, player, DNLSounds.SCORCHER_START.get(), DNLSounds.SOUL_SCORCHER_START.get());
        }
        if (chargeTime == activeAnimDuration) {
            ItemAnimationState.start(itemStack, ScorcherAnimationState.SCORCHER_SHOOT.getName(), gameTime, 120L, false, true);
            this.playScorcherSounds(itemStack, player, DNLSounds.SCORCHER_SHOOT.get(), DNLSounds.SOUL_SCORCHER_SHOOT.get());
        }
        if (chargeTime == shootAnimDuration) {
            ItemAnimationState.start(itemStack, ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), gameTime, 160L, false, true);
            this.playScorcherSounds(itemStack, player, DNLSounds.SCORCHER_OVERHEAT.get(), DNLSounds.SOUL_SCORCHER_OVERHEAT.get());
            ScorcherItem.setHeatLevel(itemStack, overHeatedDuration, gameTime);
            player.method_6075();
            return;
        }
        float maxHeatDuration = 120.0f;
        float heatIncreasePerTick = 1.0f / maxHeatDuration;
        if (ItemAnimationState.isAnimating(itemStack, ScorcherAnimationState.SCORCHER_SHOOT.getName(), gameTime)) {
            if (this.getBurnTime(itemStack) <= 0) {
                class_1799 fuelItemStack = this.getFuel(player);
                if (fuelItemStack.method_7960()) {
                    player.method_6075();
                    return;
                }
                this.setFuelNBT(itemStack, fuelItemStack.method_7909());
                FuelProperties properties = FUEL_TYPE.get(fuelItemStack.method_7909());
                if (properties == null) {
                    player.method_6075();
                    return;
                }
                this.setBurnTime(itemStack, properties.getBurnTime());
                if (this.getBurnTime(itemStack) <= 0) {
                    player.method_6075();
                    return;
                }
                this.depleteFuel(fuelItemStack, player);
            }
            if (this.getBurnTime(itemStack) > 0) {
                this.setBurnTime(itemStack, this.getBurnTime(itemStack) - 1);
            }
            if (this.getBurnTime(itemStack) % 20 == 0) {
                itemStack.method_7956(1, entity, e -> e.method_20235(class_1304.field_6173));
                player.method_7259(class_3468.field_15372.method_14956((Object)this));
            }
            this.shootFlame(level, (class_1309)player, itemStack, ScorcherItem.getFuelType(itemStack));
            float heat = ScorcherItem.getHeatLevel(itemStack);
            heat = Math.min(1.0f, heat + heatIncreasePerTick);
            ScorcherItem.setHeatLevel(itemStack, heat, gameTime);
            if (heat >= 1.0f) {
                ItemAnimationState.start(itemStack, ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), gameTime, 160L, false, true);
                this.playScorcherSounds(itemStack, player, DNLSounds.SCORCHER_OVERHEAT.get(), DNLSounds.SOUL_SCORCHER_OVERHEAT.get());
                this.stopScorcherSounds(itemStack, player, DNLSounds.SCORCHER_SHOOT.get(), DNLSounds.SOUL_SCORCHER_SHOOT.get());
                ScorcherItem.setHeatLevel(itemStack, overHeatedDuration, gameTime);
                player.method_6075();
                return;
            }
        }
    }

    private class_1799 getFuel(class_1657 player) {
        class_1799 offHandItem = player.method_6079();
        if (FUEL_TYPE.containsKey(offHandItem.method_7909())) {
            return offHandItem;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 itemStack = player.method_31548().method_5438(i);
            if (!FUEL_TYPE.containsKey(itemStack.method_7909())) continue;
            return itemStack;
        }
        if (player.method_31549().field_7477) {
            return new class_1799((class_1935)class_1802.field_8713);
        }
        return class_1799.field_8037;
    }

    private void depleteFuel(class_1799 fuelStack, class_1657 player) {
        if (!player.method_31549().field_7477) {
            if (fuelStack.method_7947() > 1) {
                fuelStack.method_7934(1);
            } else {
                fuelStack.method_7939(0);
            }
        }
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slot, boolean isSelected) {
        long gameTime = level.method_8510();
        if (!level.field_9236 && stack.method_7909() instanceof ScorcherItem && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            long storedGameTime = ScorcherItem.getTimeStamp(stack);
            if (storedGameTime != gameTime) {
                float heat = ScorcherItem.getHeatLevel(stack);
                long timeElapsed = gameTime - storedGameTime;
                float heatDecayPerTick = 0.008333334f;
                heat = Math.max(0.0f, heat - (float)timeElapsed * heatDecayPerTick);
                ScorcherItem.setHeatLevel(stack, heat, gameTime);
            }
            if (!(isSelected || player.method_6047().method_31574(stack.method_7909()) && (player.method_6115() || ItemAnimationState.isAnimating(player.method_6047(), ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), gameTime)))) {
                this.stopScorcherLingeringSounds(stack, player);
            }
            if (!isSelected && !ItemAnimationState.isAnimating(stack, ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), gameTime)) {
                if (ItemAnimationState.isAnimating(stack, ScorcherAnimationState.SCORCHER_SHOOT.getName(), gameTime)) {
                    ItemAnimationState.start(stack, ScorcherAnimationState.SCORCHER_STOP.getName(), gameTime, 25L, false, true);
                } else if (!ItemAnimationState.isAnimating(stack, ScorcherAnimationState.SCORCHER_STOP.getName(), gameTime)) {
                    ItemAnimationState.stopAll(stack);
                }
            }
        }
    }

    @Override
    public void playDroppedAnimation(class_1657 player, class_1799 itemStack) {
        long gameTime = player.method_37908().method_8510();
        this.stopScorcherLingeringSounds(itemStack, player);
        ItemAnimationState.start(itemStack, ScorcherAnimationState.SCORCHER_STOP.getName(), gameTime, 25L, false, true);
    }

    private void shootFlame(class_1937 level, class_1309 player, class_1799 itemStack, class_1792 fuelItem) {
        class_243 eyePosition = player.method_33571();
        class_243 viewVector = player.method_5828(1.0f);
        class_243 rightVector = new class_243(-viewVector.field_1350, 0.0, viewVector.field_1352).method_1029();
        FuelProperties properties = FUEL_TYPE.get(fuelItem);
        if (properties == null) {
            return;
        }
        double rightOffset = 0.175;
        double verticalOffset = -0.25;
        class_243 spawnPosition = eyePosition.method_1019(viewVector.method_1021(0.6)).method_1019(rightVector.method_1021(rightOffset)).method_1031(0.0, verticalOffset, 0.0);
        class_243 targetPosition = eyePosition.method_1019(viewVector.method_1021(30.0)).method_1031(0.0, -verticalOffset, 0.0);
        class_243 correctedDirection = targetPosition.method_1020(spawnPosition).method_1029();
        double spread = properties.getSpread();
        class_5819 random = level.method_8409();
        double spreadX = (random.method_43058() - 0.5) * spread;
        double spreadY = (random.method_43058() - 0.5) * spread;
        double spreadZ = (random.method_43058() - 0.5) * spread;
        class_243 spreadVector = new class_243(spreadX, spreadY, spreadZ);
        correctedDirection = correctedDirection.method_1019(spreadVector).method_1029();
        FlameProjectileEntity flame = new FlameProjectileEntity(player, level);
        flame.method_7432((class_1297)player);
        flame.method_5814(spawnPosition.field_1352, spawnPosition.field_1351, spawnPosition.field_1350);
        if (itemStack.method_31574(DNLItems.SOUL_SCORCHER.get())) {
            flame.setDamage(5.0f + properties.getBonusDamage());
            flame.setSoul(true);
        } else {
            flame.setDamage(4.0f + properties.getBonusDamage());
        }
        flame.method_18799(correctedDirection.method_1021(properties.getBulletSpeed()));
        level.method_8649((class_1297)flame);
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 entity, int timeCharged) {
        if (level.field_9236) {
            return;
        }
        if (ItemAnimationState.isAnimating(stack, ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), level.method_8510())) {
            return;
        }
        ItemAnimationState.start(stack, ScorcherAnimationState.SCORCHER_STOP.getName(), level.method_8510(), 25L, false, true);
        this.playScorcherSounds(stack, (class_1657)entity, DNLSounds.SCORCHER_STOP.get(), DNLSounds.SOUL_SCORCHER_STOP.get());
        this.stopScorcherSounds(stack, (class_1657)entity, DNLSounds.SCORCHER_SHOOT.get(), DNLSounds.SOUL_SCORCHER_SHOOT.get());
    }

    private void playScorcherSounds(class_1799 itemStack, class_1657 player, class_3414 scorcher, class_3414 soulScorcher) {
        float radius = 32.0f;
        class_238 detectionBox = player.method_5829().method_1014((double)radius);
        List nearbyPlayers = player.method_37908().method_18467(class_3222.class, detectionBox);
        class_2960 sound = itemStack.method_31574(DNLItems.SOUL_SCORCHER.get()) ? soulScorcher.method_14833() : scorcher.method_14833();
        for (class_3222 otherPlayer : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(player.method_5628(), sound, class_3419.field_15248), otherPlayer);
        }
    }

    private void stopScorcherLingeringSounds(class_1799 itemStack, class_1657 player) {
        float radius = 32.0f;
        class_238 detectionBox = player.method_5829().method_1014((double)radius);
        List nearbyPlayers = player.method_37908().method_18467(class_3222.class, detectionBox);
        ArrayList<class_2960> soundsToStop = new ArrayList<class_2960>(List.of());
        if (itemStack.method_31574(DNLItems.SOUL_SCORCHER.get())) {
            soundsToStop.add(DNLSounds.SOUL_SCORCHER_START.get().method_14833());
            soundsToStop.add(DNLSounds.SOUL_SCORCHER_SHOOT.get().method_14833());
            soundsToStop.add(DNLSounds.SOUL_SCORCHER_OVERHEAT.get().method_14833());
        } else {
            soundsToStop.add(DNLSounds.SCORCHER_START.get().method_14833());
            soundsToStop.add(DNLSounds.SCORCHER_SHOOT.get().method_14833());
            soundsToStop.add(DNLSounds.SCORCHER_OVERHEAT.get().method_14833());
        }
        for (class_3222 otherPlayer : nearbyPlayers) {
            for (class_2960 sound : soundsToStop) {
                Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(player.method_5628(), sound, 20, true), otherPlayer);
            }
        }
    }

    private void stopScorcherSounds(class_1799 itemStack, class_1657 player, class_3414 scorcher, class_3414 soulScorcher) {
        float radius = 32.0f;
        class_238 detectionBox = player.method_5829().method_1014((double)radius);
        List nearbyPlayers = player.method_37908().method_18467(class_3222.class, detectionBox);
        class_2960 sound = itemStack.method_31574(DNLItems.SOUL_SCORCHER.get()) ? soulScorcher.method_14833() : scorcher.method_14833();
        for (class_3222 otherPlayer : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(player.method_5628(), sound, 20, true), otherPlayer);
        }
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public void method_7851(class_1799 itemStack, @Nullable class_1937 level, List<class_2561> components, class_1836 tooltipFlag) {
        super.method_7851(itemStack, level, components, tooltipFlag);
        if (((Boolean)GeneralConfig.TOGGLE_HELPFUL_ITEM_TOOLTIP.get()).booleanValue()) {
            if (itemStack.method_31574(DNLItems.SCORCHER.get())) {
                components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.scorcher.tooltip.ability_name").method_27692(class_124.field_1080));
                components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.scorcher.tooltip.ability_description").method_27692(class_124.field_1063));
            } else if (itemStack.method_31574(DNLItems.SOUL_SCORCHER.get())) {
                components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.soul_scorcher.tooltip.ability_name").method_27692(class_124.field_1080));
                components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.soul_scorcher.tooltip.ability_description").method_27692(class_124.field_1063));
            }
            components.add(class_5244.field_39003);
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.scorcher_common.tooltip.cost").method_27692(class_124.field_1080));
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.scorcher_common.tooltip.cost.coal").method_27692(class_124.field_1063));
            components.add((class_2561)class_2561.method_43471((String)"item.dungeonnowloading.scorcher_common.tooltip.cost.charcoal").method_27692(class_124.field_1063));
        }
    }

    public static void setHeatLevel(class_1799 stack, float heatLevel, long timeStamp) {
        stack.method_7948().method_10548(HEAT_TAG, heatLevel);
        stack.method_7948().method_10544(HEAT_TIME_STAMP, timeStamp);
    }

    private static void ensureUUID(class_1799 stack) {
        if (!stack.method_7985()) {
            stack.method_7980(new class_2487());
        }
        if (!stack.method_7969().method_10545("ScorcherUUID")) {
            stack.method_7969().method_25927("ScorcherUUID", UUID.randomUUID());
        }
    }

    private void setFuelNBT(class_1799 weaponItemStack, class_1792 fuelItem) {
        class_2487 tag = weaponItemStack.method_7948();
        class_2960 fuelId = class_7923.field_41178.method_10221((Object)fuelItem);
        if (fuelId != null) {
            tag.method_10582("FuelType", fuelId.toString());
        }
    }

    public static class_1792 getFuelType(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10545("FuelType")) {
            class_2960 fuelId = new class_2960(tag.method_10558("FuelType"));
            return (class_1792)class_7923.field_41178.method_10223(fuelId);
        }
        return class_1802.field_8162;
    }

    private void setBurnTime(class_1799 itemStack, int tick) {
        itemStack.method_7948().method_10569(BURN_TIME, tick);
    }

    private int getBurnTime(class_1799 itemStack) {
        class_2487 tag = itemStack.method_7969();
        if (tag != null && tag.method_10545(BURN_TIME)) {
            return tag.method_10550(BURN_TIME);
        }
        return 0;
    }

    public static float getHeatLevel(class_1799 stack) {
        return stack.method_7985() ? stack.method_7969().method_10583(HEAT_TAG) : 0.0f;
    }

    public static long getTimeStamp(class_1799 stack) {
        return stack.method_7985() ? stack.method_7969().method_10537(HEAT_TIME_STAMP) : 0L;
    }

    @Override
    public Class<ScorcherAnimationState> getAnimationEnum() {
        return ScorcherAnimationState.class;
    }

    static {
        FUEL_TYPE.put(class_1802.field_8713, new FuelProperties(0.5, 0.0f, 0.4, 30));
        FUEL_TYPE.put(class_1802.field_8665, new FuelProperties(0.5, 0.0f, 0.4, 20));
    }

    public static enum ScorcherAnimationState implements DNLAnimationState
    {
        SCORCHER_ACTIVATED("scorcher_activated"),
        SCORCHER_SHOOT("scorcher_shoot"),
        SCORCHER_STOP("scorcher_stop"),
        SCORCHER_STALLING("scorcher_stalling"),
        SCORCHER_OVERHEAT("scorcher_overheat"),
        SCORCHER_BASE("scorcher_base");

        private final String name;

        private ScorcherAnimationState(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static class FuelProperties {
        private final double spread;
        private final float bonusDamage;
        private final double bulletSpeed;
        private final int burnTime;

        public FuelProperties(double spread, float bonusDamage, double bulletSpeed, int burnTime) {
            this.spread = spread;
            this.bonusDamage = bonusDamage;
            this.bulletSpeed = bulletSpeed;
            this.burnTime = burnTime;
        }

        public double getSpread() {
            return this.spread;
        }

        public float getBonusDamage() {
            return this.bonusDamage;
        }

        public double getBulletSpeed() {
            return this.bulletSpeed;
        }

        public int getBurnTime() {
            return this.burnTime;
        }
    }
}

