/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.game_event_listener;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hexnowloading.dungeonnowloading.block.MendingAuraBlock;
import dev.hexnowloading.dungeonnowloading.block.PreserverBlock;
import dev.hexnowloading.dungeonnowloading.block.entity.MendingAuraBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.entity.PreserverBlockEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLGameEvents;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import dev.hexnowloading.dungeonnowloading.util.event_managers.BlockBurnManager;
import dev.hexnowloading.dungeonnowloading.util.event_managers.BlockDestructionManager;
import dev.hexnowloading.dungeonnowloading.util.event_managers.ContainerDropManager;
import dev.hexnowloading.dungeonnowloading.util.event_managers.ExplosionDestructionManager;
import dev.hexnowloading.dungeonnowloading.util.event_managers.PistonPushManager;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2382;
import net.minecraft.class_2389;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4778;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;

public interface PreserverBlockDestructionSystem {
    public User getUser();

    public static class Listener
    implements class_5714 {
        private final PreserverBlockDestructionSystem system;

        public Listener(PreserverBlockDestructionSystem system) {
            this.system = system;
        }

        public class_2338 getBlockPos() {
            return this.system.getUser().getBlockPos();
        }

        public class_5716 method_32946() {
            return this.system.getUser().getPositionSource();
        }

        public int method_32948() {
            class_2338 absCornerA = this.system.getUser().getBlockPos().method_10081((class_2382)this.system.getUser().getCornerA());
            class_2338 absCornerB = this.system.getUser().getBlockPos().method_10081((class_2382)this.system.getUser().getCornerB());
            int maxDistance = Math.max(Math.abs(absCornerA.method_10263() - absCornerB.method_10263()), Math.max(Math.abs(absCornerA.method_10264() - absCornerB.method_10264()), Math.abs(absCornerA.method_10260() - absCornerB.method_10260())));
            return Listener.squareRegionCalculation(maxDistance);
        }

        public static int squareRegionCalculation(int centerToSideDistance) {
            return (int)Math.ceil((double)centerToSideDistance * Math.sqrt(3.0));
        }

        public static int reverseSquareRegionCalculation(int y) {
            return (int)Math.floor((double)y / Math.sqrt(3.0));
        }

        public boolean method_32947(class_3218 serverLevel, class_5712 gameEvent, class_5712.class_7397 context, class_243 pos) {
            class_2338 eventBlockPos = new class_2338((int)Math.floor(pos.field_1352), (int)Math.floor(pos.field_1351), (int)Math.floor(pos.field_1350));
            class_243 centerPos = (class_243)this.method_32946().method_32956((class_1937)serverLevel).orElseThrow();
            class_2338 centerBlockPos = new class_2338((int)Math.floor(centerPos.field_1352), (int)Math.floor(centerPos.field_1351), (int)Math.floor(centerPos.field_1350));
            User user = this.system.getUser();
            if (!user.isInsideRegion((class_1937)serverLevel, eventBlockPos, centerBlockPos)) {
                return false;
            }
            if (gameEvent == DNLGameEvents.PLAYER_BLOCK_DESTROY_EARLY.get()) {
                PreserverBlockEntity preserverBlock;
                class_2586 class_25862 = serverLevel.method_8321(centerBlockPos);
                if (class_25862 instanceof PreserverBlockEntity && (preserverBlock = (PreserverBlockEntity)class_25862).isPlayerPlaced(eventBlockPos)) {
                    preserverBlock.removePlayerPlacedBlock(eventBlockPos);
                    return false;
                }
                class_25862 = context.comp_713();
                if (class_25862 instanceof class_1657) {
                    class_1657 player = (class_1657)class_25862;
                    if (player.method_31549().field_7477) {
                        return false;
                    }
                }
                if (serverLevel.method_8320(eventBlockPos).method_26204() instanceof MendingAuraBlock) {
                    BlockDestructionManager.cancel();
                    return false;
                }
                if (serverLevel.method_8320(eventBlockPos).method_26204() instanceof PreserverBlock) {
                    return false;
                }
                if (serverLevel.method_8320(eventBlockPos).method_26164(DNLTags.PRESERVER_IGNORE)) {
                    return false;
                }
                if (!this.ignoreBlockTransformation(serverLevel, eventBlockPos)) {
                    return false;
                }
                class_2680 originalBlockState = serverLevel.method_8320(eventBlockPos);
                class_2586 originalBlockEntity = serverLevel.method_8321(eventBlockPos);
                class_2487 compoundTag = new class_2487();
                if (originalBlockEntity != null) {
                    compoundTag = originalBlockEntity.method_38242();
                }
                ContainerDropManager.cancel(eventBlockPos);
                this.placeMendingBlock(serverLevel, originalBlockState, eventBlockPos, gameEvent);
                BlockDestructionManager.cancel();
                class_2586 class_25863 = serverLevel.method_8321(eventBlockPos);
                if (class_25863 instanceof MendingAuraBlockEntity) {
                    MendingAuraBlockEntity blockEntity = (MendingAuraBlockEntity)class_25863;
                    blockEntity.setStoredBlock(originalBlockState, compoundTag);
                }
                if ((class_25863 = serverLevel.method_8320(centerBlockPos).method_26204()) instanceof PreserverBlock) {
                    PreserverBlock preserverBlock2 = (PreserverBlock)class_25863;
                    preserverBlock2.setLitPreserverBlock(serverLevel, centerBlockPos);
                    serverLevel.method_8396(null, centerBlockPos, DNLSounds.MENDING_AURA_POP.get(), class_3419.field_15245, 1.0f, 1.0f);
                }
                return true;
            }
            if (gameEvent == DNLGameEvents.BLOCK_DESTROY_EARLY.get()) {
                PreserverBlockEntity preserverBlock;
                if (serverLevel.method_8320(eventBlockPos).method_26215()) {
                    return false;
                }
                class_2586 originalBlockEntity = serverLevel.method_8321(centerBlockPos);
                if (originalBlockEntity instanceof PreserverBlockEntity && (preserverBlock = (PreserverBlockEntity)originalBlockEntity).isPlayerPlaced(eventBlockPos)) {
                    preserverBlock.removePlayerPlacedBlock(eventBlockPos);
                    return false;
                }
                if (serverLevel.method_8320(eventBlockPos).method_26204() instanceof MendingAuraBlock) {
                    BlockDestructionManager.cancel();
                    return false;
                }
                if (serverLevel.method_8320(eventBlockPos).method_26204() instanceof PreserverBlock) {
                    return false;
                }
                if (serverLevel.method_8320(eventBlockPos).method_26164(DNLTags.PRESERVER_IGNORE)) {
                    return false;
                }
                if (!this.ignoreBlockTransformation(serverLevel, eventBlockPos)) {
                    return false;
                }
                class_2680 originalBlockState = serverLevel.method_8320(eventBlockPos);
                originalBlockEntity = serverLevel.method_8321(eventBlockPos);
                class_2487 compoundTag = new class_2487();
                if (originalBlockEntity != null) {
                    compoundTag = originalBlockEntity.method_38242();
                }
                ContainerDropManager.cancel(eventBlockPos);
                this.placeMendingBlock(serverLevel, originalBlockState, eventBlockPos, gameEvent);
                BlockDestructionManager.cancel();
                class_2586 class_25864 = serverLevel.method_8321(eventBlockPos);
                if (class_25864 instanceof MendingAuraBlockEntity) {
                    MendingAuraBlockEntity blockEntity = (MendingAuraBlockEntity)class_25864;
                    blockEntity.setStoredBlock(originalBlockState, compoundTag);
                }
                if ((class_25864 = serverLevel.method_8320(centerBlockPos).method_26204()) instanceof PreserverBlock) {
                    PreserverBlock preserverBlock3 = (PreserverBlock)class_25864;
                    preserverBlock3.setLitPreserverBlock(serverLevel, centerBlockPos);
                    serverLevel.method_8396(null, centerBlockPos, DNLSounds.MENDING_AURA_POP.get(), class_3419.field_15245, 1.0f, 1.0f);
                }
                return true;
            }
            if (gameEvent == DNLGameEvents.BLOCK_DESTROYED_BY_EXPLOSION.get()) {
                PreserverBlockEntity preserverBlock;
                if (serverLevel.method_8320(eventBlockPos).method_26215()) {
                    return false;
                }
                if (serverLevel.method_8320(eventBlockPos).method_26204() instanceof MendingAuraBlock) {
                    ExplosionDestructionManager.cancel();
                    return false;
                }
                class_2248 originalBlockEntity = serverLevel.method_8320(eventBlockPos).method_26204();
                if (originalBlockEntity instanceof PreserverBlock) {
                    PreserverBlock preserverBlock4 = (PreserverBlock)originalBlockEntity;
                    ExplosionDestructionManager.cancel();
                    preserverBlock4.setLitPreserverBlock(serverLevel, centerBlockPos);
                    return false;
                }
                originalBlockEntity = serverLevel.method_8321(centerBlockPos);
                if (originalBlockEntity instanceof PreserverBlockEntity && (preserverBlock = (PreserverBlockEntity)originalBlockEntity).isPlayerPlaced(eventBlockPos)) {
                    preserverBlock.removePlayerPlacedBlock(eventBlockPos);
                    return false;
                }
                if (serverLevel.method_8320(eventBlockPos).method_26164(DNLTags.PRESERVER_IGNORE)) {
                    return false;
                }
                if (!this.ignoreBlockTransformation(serverLevel, eventBlockPos)) {
                    return false;
                }
                class_2680 originalBlockState = serverLevel.method_8320(eventBlockPos);
                originalBlockEntity = serverLevel.method_8321(eventBlockPos);
                class_2487 compoundTag = new class_2487();
                if (originalBlockEntity != null) {
                    compoundTag = originalBlockEntity.method_38242();
                }
                ContainerDropManager.cancel(eventBlockPos);
                this.placeMendingBlock(serverLevel, originalBlockState, eventBlockPos, gameEvent);
                ExplosionDestructionManager.cancel();
                class_2586 class_25865 = serverLevel.method_8321(eventBlockPos);
                if (class_25865 instanceof MendingAuraBlockEntity) {
                    MendingAuraBlockEntity blockEntity = (MendingAuraBlockEntity)class_25865;
                    blockEntity.setStoredBlock(originalBlockState, compoundTag);
                }
                if ((class_25865 = serverLevel.method_8320(centerBlockPos).method_26204()) instanceof PreserverBlock) {
                    PreserverBlock preserverBlock5 = (PreserverBlock)class_25865;
                    preserverBlock5.setLitPreserverBlock(serverLevel, centerBlockPos);
                    serverLevel.method_8396(null, centerBlockPos, DNLSounds.MENDING_AURA_POP.get(), class_3419.field_15245, 1.0f, 1.0f);
                }
                return true;
            }
            if (gameEvent == DNLGameEvents.BLOCK_BURNED.get()) {
                PreserverBlockEntity preserverBlock;
                class_2586 originalBlockEntity = serverLevel.method_8321(centerBlockPos);
                if (originalBlockEntity instanceof PreserverBlockEntity && (preserverBlock = (PreserverBlockEntity)originalBlockEntity).isPlayerPlaced(eventBlockPos)) {
                    preserverBlock.removePlayerPlacedBlock(eventBlockPos);
                    return false;
                }
                if (serverLevel.method_8320(eventBlockPos).method_26164(DNLTags.PRESERVER_IGNORE)) {
                    return false;
                }
                if (!this.ignoreBlockTransformation(serverLevel, eventBlockPos)) {
                    return false;
                }
                class_2680 originalBlockState = serverLevel.method_8320(eventBlockPos);
                originalBlockEntity = serverLevel.method_8321(eventBlockPos);
                class_2487 compoundTag = new class_2487();
                if (originalBlockEntity != null) {
                    compoundTag = originalBlockEntity.method_38242();
                }
                BlockBurnManager.cancel();
                ContainerDropManager.cancel(eventBlockPos);
                this.placeMendingBlock(serverLevel, originalBlockState, eventBlockPos, gameEvent);
                class_2586 class_25866 = serverLevel.method_8321(eventBlockPos);
                if (class_25866 instanceof MendingAuraBlockEntity) {
                    MendingAuraBlockEntity blockEntity = (MendingAuraBlockEntity)class_25866;
                    blockEntity.setStoredBlock(originalBlockState, compoundTag);
                }
                if ((class_25866 = serverLevel.method_8320(centerBlockPos).method_26204()) instanceof PreserverBlock) {
                    PreserverBlock preserverBlock6 = (PreserverBlock)class_25866;
                    preserverBlock6.setLitPreserverBlock(serverLevel, centerBlockPos);
                    serverLevel.method_8396(null, centerBlockPos, DNLSounds.MENDING_AURA_POP.get(), class_3419.field_15245, 1.0f, 1.0f);
                }
                return true;
            }
            if (gameEvent == DNLGameEvents.BLOCK_PUSHED_EARLY.get()) {
                if (serverLevel.method_8320(eventBlockPos).method_26215()) {
                    return false;
                }
                if (serverLevel.method_8320(eventBlockPos).method_26164(DNLTags.PRESERVER_IGNORE)) {
                    return false;
                }
                if (!this.ignoreBlockTransformation(serverLevel, eventBlockPos)) {
                    return false;
                }
                class_2680 originalBlockState = serverLevel.method_8320(eventBlockPos);
                class_2586 originalBlockEntity = serverLevel.method_8321(eventBlockPos);
                class_2487 compoundTag = new class_2487();
                if (originalBlockEntity != null) {
                    compoundTag = originalBlockEntity.method_38242();
                }
                PistonPushManager.cancel();
                this.placeMendingBlock(serverLevel, originalBlockState, eventBlockPos, gameEvent);
                class_2586 class_25867 = serverLevel.method_8321(eventBlockPos);
                if (class_25867 instanceof MendingAuraBlockEntity) {
                    MendingAuraBlockEntity blockEntity = (MendingAuraBlockEntity)class_25867;
                    blockEntity.setStoredBlock(originalBlockState, compoundTag);
                }
                if ((class_25867 = serverLevel.method_8320(centerBlockPos).method_26204()) instanceof PreserverBlock) {
                    PreserverBlock preserverBlock = (PreserverBlock)class_25867;
                    preserverBlock.setLitPreserverBlock(serverLevel, centerBlockPos);
                    serverLevel.method_8396(null, centerBlockPos, DNLSounds.MENDING_AURA_POP.get(), class_3419.field_15245, 1.0f, 1.0f);
                }
                return true;
            }
            if (gameEvent == class_5712.field_28164) {
                class_1297 class_12972 = context.comp_713();
                if (class_12972 instanceof class_1657) {
                    class_1657 player = (class_1657)class_12972;
                    if (player.method_31549().field_7477) {
                        return false;
                    }
                }
                if ((class_12972 = serverLevel.method_8321(centerBlockPos)) instanceof PreserverBlockEntity) {
                    PreserverBlockEntity blockEntity = (PreserverBlockEntity)class_12972;
                    blockEntity.addPlayerPlacedBlock(eventBlockPos);
                }
                return true;
            }
            return false;
        }

        private boolean ignoreBlockTransformation(class_3218 serverLevel, class_2338 eventBlockPos) {
            class_2680 blockState = serverLevel.method_8320(eventBlockPos);
            class_2248 block = blockState.method_26204();
            return blockState.method_26234((class_1922)serverLevel, eventBlockPos) || blockState.method_26164(DNLTags.NEAR_FULL_HEIGHT_BLOCKS) || block instanceof class_2389 || block instanceof class_2482 || block instanceof class_2510 || block instanceof class_2354 || block instanceof class_2544;
        }

        private void placeMendingBlock(class_3218 serverLevel, class_2680 originalBlockState, class_2338 eventBlockPos, class_5712 gameEvent) {
            serverLevel.method_8652(eventBlockPos, class_2246.field_10124.method_9564(), 2);
            class_2680 mendingAuraState = originalBlockState.method_26204() instanceof class_2510 ? (class_2680)((class_2680)((class_2680)((class_2680)DNLBlocks.MENDING_AURA_STAIRS.get().method_9564().method_11657((class_2769)class_2510.field_11571, (Comparable)((class_2350)originalBlockState.method_11654((class_2769)class_2510.field_11571)))).method_11657((class_2769)class_2510.field_11572, (Comparable)((class_2760)originalBlockState.method_11654((class_2769)class_2510.field_11572)))).method_11657((class_2769)class_2510.field_11565, (Comparable)((class_2778)originalBlockState.method_11654((class_2769)class_2510.field_11565)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12508))) : (originalBlockState.method_26204() instanceof class_2482 ? (class_2680)((class_2680)DNLBlocks.MENDING_AURA_SLAB.get().method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)((class_2771)originalBlockState.method_11654((class_2769)class_2482.field_11501)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12508))) : (originalBlockState.method_26204() instanceof class_2354 ? (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)DNLBlocks.MENDING_AURA_FENCE.get().method_9564().method_11657((class_2769)class_2741.field_12489, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12489)))).method_11657((class_2769)class_2741.field_12540, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12540)))).method_11657((class_2769)class_2741.field_12487, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12487)))).method_11657((class_2769)class_2741.field_12527, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12527)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12508))) : (originalBlockState.method_26204() instanceof class_2389 ? (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)DNLBlocks.MENDING_AURA_PANE.get().method_9564().method_11657((class_2769)class_2741.field_12489, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12489)))).method_11657((class_2769)class_2741.field_12540, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12540)))).method_11657((class_2769)class_2741.field_12487, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12487)))).method_11657((class_2769)class_2741.field_12527, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12527)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12508))) : (originalBlockState.method_26204() instanceof class_2544 ? (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)DNLBlocks.MENDING_AURA_WALL.get().method_9564().method_11657((class_2769)class_2741.field_12519, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12519)))).method_11657((class_2769)class_2741.field_22175, (Comparable)((class_4778)originalBlockState.method_11654((class_2769)class_2741.field_22175)))).method_11657((class_2769)class_2741.field_22176, (Comparable)((class_4778)originalBlockState.method_11654((class_2769)class_2741.field_22176)))).method_11657((class_2769)class_2741.field_22174, (Comparable)((class_4778)originalBlockState.method_11654((class_2769)class_2741.field_22174)))).method_11657((class_2769)class_2741.field_22177, (Comparable)((class_4778)originalBlockState.method_11654((class_2769)class_2741.field_22177)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)originalBlockState.method_11654((class_2769)class_2741.field_12508))) : (originalBlockState.method_26164(DNLTags.NEAR_FULL_HEIGHT_BLOCKS) ? DNLBlocks.MENDING_AURA_PATH.get().method_9564() : DNLBlocks.MENDING_AURA.get().method_9564())))));
            serverLevel.method_8652(eventBlockPos, mendingAuraState, 2);
            class_2248 block = serverLevel.method_8320(eventBlockPos).method_26204();
            if (block instanceof MendingAuraBlock) {
                MendingAuraBlock mendingAuraBlock = (MendingAuraBlock)block;
                mendingAuraBlock.startRestoration((class_1937)serverLevel, eventBlockPos);
            }
        }
    }

    public static class User {
        public static final Codec<User> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("cornerA").forGetter(User::getCornerA), (App)class_2338.field_25064.fieldOf("cornerB").forGetter(User::getCornerB), (App)class_2350.field_29502.fieldOf("facing").forGetter(User::getFacing)).apply((Applicative)instance, (cornerA, cornerB, facing) -> new User(class_2338.field_10980, (class_2338)cornerA, (class_2338)cornerB, (class_2350)facing)));
        private final class_2338 blockPos;
        private class_2338 cornerA;
        private class_2338 cornerB;
        private class_2350 direction;

        public User(class_2338 blockPos, class_2338 cornerA, class_2338 cornerB, class_2350 direction) {
            this.blockPos = blockPos;
            this.cornerA = cornerA;
            this.cornerB = cornerB;
            this.direction = direction;
        }

        public class_2338 getCornerA() {
            return this.cornerA;
        }

        public void setCornerA(class_2338 blockPos) {
            this.cornerA = blockPos;
        }

        public void setCornerB(class_2338 blockPos) {
            this.cornerB = blockPos;
        }

        public class_2338 getCornerB() {
            return this.cornerB;
        }

        public class_2338 getBlockPos() {
            return this.blockPos;
        }

        public class_5716 getPositionSource() {
            return new class_5707(this.blockPos);
        }

        public class_2350 getFacing() {
            return this.direction;
        }

        public void setFacing(class_2350 direction) {
            this.direction = direction;
        }

        public boolean isInsideRegion(class_1937 level, class_2338 eventBlockPos, class_2338 centerBlock) {
            class_2586 blockEntity = level.method_8321(centerBlock);
            if (!(blockEntity instanceof PreserverBlockEntity)) {
                return false;
            }
            PreserverBlockEntity preserverBlockEntity = (PreserverBlockEntity)blockEntity;
            class_2350 nbtDirection = preserverBlockEntity.getUser().getFacing();
            class_2338 absCornerA = this.blockPos.method_10081((class_2382)User.rotateOffset(level, centerBlock, this.cornerA, nbtDirection));
            class_2338 absCornerB = this.blockPos.method_10081((class_2382)User.rotateOffset(level, centerBlock, this.cornerB, nbtDirection));
            int minX = Math.min(absCornerA.method_10263(), absCornerB.method_10263());
            int minY = Math.min(absCornerA.method_10264(), absCornerB.method_10264());
            int minZ = Math.min(absCornerA.method_10260(), absCornerB.method_10260());
            int maxX = Math.max(absCornerA.method_10263(), absCornerB.method_10263());
            int maxY = Math.max(absCornerA.method_10264(), absCornerB.method_10264());
            int maxZ = Math.max(absCornerA.method_10260(), absCornerB.method_10260());
            return eventBlockPos.method_10263() >= minX && eventBlockPos.method_10263() <= maxX && eventBlockPos.method_10264() >= minY && eventBlockPos.method_10264() <= maxY && eventBlockPos.method_10260() >= minZ && eventBlockPos.method_10260() <= maxZ;
        }

        public static class_2338 rotateOffset(class_1937 level, class_2338 pos, class_2338 offset, class_2350 nbtFacing) {
            class_2350 propertyDirection = (class_2350)level.method_8320(pos).method_11654((class_2769)class_2741.field_12525);
            int propertyFacingIndex = switch (propertyDirection) {
                default -> 0;
                case class_2350.field_11034 -> 1;
                case class_2350.field_11035 -> 2;
                case class_2350.field_11039 -> 3;
            };
            int nbtFacingIndex = switch (nbtFacing) {
                default -> 0;
                case class_2350.field_11034 -> 1;
                case class_2350.field_11035 -> 2;
                case class_2350.field_11039 -> 3;
            };
            int facingDifference = propertyFacingIndex - nbtFacingIndex;
            return switch (facingDifference) {
                default -> offset;
                case -3, 1 -> offset.method_10070(class_2470.field_11463);
                case -1, 3 -> offset.method_10070(class_2470.field_11465);
                case -2, 2 -> offset.method_10070(class_2470.field_11464);
            };
        }
    }
}

