/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.util;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.class_8046;
import org.jetbrains.annotations.Nullable;

public abstract class ModelledProjectileEntity
extends class_1297
implements class_8046 {
    @Nullable
    protected UUID ownerUUID;
    @Nullable
    protected class_1297 cachedOwner;
    protected boolean leftOwner;
    protected boolean hasBeenShot;

    public ModelledProjectileEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    public void method_5773() {
        if (!this.hasBeenShot) {
            this.method_32875(class_5712.field_28161, this.method_24921());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        class_1297 owner = this.method_24921();
        if (this.method_37908().field_9236 || (owner == null || !owner.method_31481()) && this.method_37908().method_22340(this.method_24515())) {
            super.method_5773();
            class_239 hitResult = class_1675.method_49997((class_1297)this, this::canHitEntity);
            if (hitResult.method_17783() != class_239.class_240.field_1333) {
                this.onHit(hitResult);
            }
            this.tickProjectile();
        } else {
            this.method_31472();
        }
    }

    @Nullable
    public class_1297 method_24921() {
        if (this.cachedOwner != null && !this.cachedOwner.method_31481()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.method_37908() instanceof class_3218) {
            this.cachedOwner = ((class_3218)this.method_37908()).method_14190(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void setOwner(@Nullable class_1297 entity) {
        if (entity != null) {
            this.ownerUUID = entity.method_5667();
            this.cachedOwner = entity;
        }
    }

    protected boolean checkLeftOwner() {
        class_1297 entity = this.method_24921();
        if (entity != null) {
            for (class_1297 entity1 : this.method_37908().method_8333((class_1297)this, this.method_5829().method_18804(this.method_18798()).method_1014(1.0), owner -> !owner.method_7325() && owner.method_5863())) {
                if (entity1.method_5668() != entity.method_5668()) continue;
                return false;
            }
        }
        return true;
    }

    protected void onHit(class_239 hitResult) {
        class_239.class_240 hitresult$type = hitResult.method_17783();
        if (hitresult$type == class_239.class_240.field_1331) {
            this.onHitEntity((class_3966)hitResult);
            this.method_37908().method_32888(class_5712.field_28162, hitResult.method_17784(), class_5712.class_7397.method_43286((class_1297)this, (class_2680)null));
        } else if (hitresult$type == class_239.class_240.field_1332) {
            class_3965 blockhitresult = (class_3965)hitResult;
            this.onHitBlock(blockhitresult);
            class_2338 blockpos = blockhitresult.method_17777();
            this.method_37908().method_43276(class_5712.field_28162, blockpos, class_5712.class_7397.method_43286((class_1297)this, (class_2680)this.method_37908().method_8320(blockpos)));
        }
    }

    protected boolean canHitEntity(class_1297 entity) {
        if (!entity.method_49108()) {
            return false;
        }
        class_1297 ownerEntity = this.method_24921();
        return (ownerEntity == null || this.leftOwner || !ownerEntity.method_5794(entity)) && !entity.field_5960;
    }

    protected void onHitEntity(class_3966 entityHitResult) {
    }

    protected void onHitBlock(class_3965 blockHitResult) {
    }

    protected void tickProjectile() {
    }

    public void method_5750(double x, double y, double z) {
        this.method_18800(x, y, z);
    }

    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void method_31471(class_2604 recreateFromPacket) {
        super.method_31471(recreateFromPacket);
    }

    protected void method_5749(class_2487 compoundTag) {
        if (this.ownerUUID != null) {
            compoundTag.method_25927("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            compoundTag.method_10556("LeftOwner", true);
        }
        compoundTag.method_10556("HasBeenShot", this.hasBeenShot);
    }

    protected void method_5652(class_2487 compoundTag) {
        if (compoundTag.method_25928("Owner")) {
            this.ownerUUID = compoundTag.method_25926("Owner");
            this.cachedOwner = null;
        }
        this.leftOwner = compoundTag.method_10577("LeftOwner");
        this.hasBeenShot = compoundTag.method_10577("HasBeenShot");
    }
}

