/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.util;

import dev.hexnowloading.dungeonnowloading.config.BossConfig;
import dev.hexnowloading.dungeonnowloading.config.MobConfig;
import dev.hexnowloading.dungeonnowloading.entity.util.ExhaustionTracker;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_5134;

public class EntityScale {
    private static final UUID SCALED_HEALTH_MODIFIER_UUID = UUID.fromString("f47ac10b-58cc-4372-a567-0e02b2c3d479");
    private static final UUID SCALED_ATTACK_MODIFIER_UUID = UUID.fromString("3a284fc3-6c5a-43d7-93ec-d96423e0f34f");
    private static final double bossHealthScale = (Double)BossConfig.BOSS_HEALTH_MODIFIER.get();
    private static final double bossAttackDamageScale = (Double)BossConfig.BOSS_DAMAGE_MODIFIER.get();
    private static final double multiplayerBossHealthScale = (Boolean)BossConfig.TOGGLE_MULTIPLAYER_SCALING.get() != false ? (Double)BossConfig.MULTIPLAYER_BOSS_HEALTH_SCALE.get() : 0.0;
    private static final double multiplayerBossAttackScale = (Boolean)BossConfig.TOGGLE_MULTIPLAYER_SCALING.get() != false ? (Double)BossConfig.MULTIPLAYER_BOSS_ATTACK_SCALE.get() : 0.0;
    private static final double multiplayerBossExhaustionScale = (Boolean)BossConfig.TOGGLE_MULTIPLAYER_SCALING.get() != false ? (Double)BossConfig.MULTIPLAYER_BOSS_EXHAUSTION_SCALE.get() : 0.0;

    public static void scaleBossHealth(class_1309 entityType, int playerCount) {
        double healthMultiplier = bossHealthScale * (1.0 + (double)(playerCount - 1) * multiplayerBossHealthScale) - 1.0;
        class_1322 SCALED_HEALTH_MODIFIER = new class_1322(SCALED_HEALTH_MODIFIER_UUID, "Scaled health", healthMultiplier, class_1322.class_1323.field_6330);
        Objects.requireNonNull(entityType.method_5996(class_5134.field_23716)).method_6202(SCALED_HEALTH_MODIFIER);
        Objects.requireNonNull(entityType.method_5996(class_5134.field_23716)).method_26837(SCALED_HEALTH_MODIFIER);
        entityType.method_6033(entityType.method_6063());
    }

    public static void scaleBossAttack(class_1309 entityType, int playerCount) {
        double attackMultiplier = bossAttackDamageScale * (1.0 + (double)(playerCount - 1) * multiplayerBossAttackScale) - 1.0;
        class_1322 SCALED_ATTACK_MODIFIER = new class_1322(SCALED_ATTACK_MODIFIER_UUID, "Scaled attack", attackMultiplier, class_1322.class_1323.field_6330);
        Objects.requireNonNull(entityType.method_5996(class_5134.field_23721)).method_6202(SCALED_ATTACK_MODIFIER);
        Objects.requireNonNull(entityType.method_5996(class_5134.field_23721)).method_26837(SCALED_ATTACK_MODIFIER);
    }

    public static void scaleBossExhaustion(class_1309 entityType, int playerCount, ExhaustionTracker exhaustionTracker) {
        double exhaustionMultiplier = 1.0 + (double)(playerCount - 1) * multiplayerBossExhaustionScale - 1.0;
        exhaustionTracker.setMaxExhaustion((float)((double)exhaustionTracker.getMaxExhaustion() * (1.0 + exhaustionMultiplier)));
    }

    public static void scaleMobAttributes(class_1309 entity) {
        int health = (int)((double)entity.method_6063() * (Double)MobConfig.DUNGEON_MOB_HEALTH_MODIFIER.get());
        int attackDamage = (int)(entity.method_5996(class_5134.field_23721).method_6194() * (Double)MobConfig.DUNGEON_MOB_ATTACK_MODIFIER.get());
        entity.method_5996(class_5134.field_23716).method_6192((double)health);
        entity.method_5996(class_5134.field_23721).method_6192((double)attackDamage);
        entity.method_6033((float)health);
    }
}

