/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.projectile;

import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.ModelledProjectileEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.AxisParticleType;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import dev.hexnowloading.dungeonnowloading.util.DNLLevelUtil;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_8111;
import org.joml.Vector3f;

public class VertexOrbProjectileEntity
extends ModelledProjectileEntity {
    private static final class_2940<Integer> HURT_TIME = class_2945.method_12791(VertexOrbProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> HURT_TIME_DIRECT = class_2945.method_12791(VertexOrbProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DAMAGE = class_2945.method_12791(VertexOrbProjectileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Vector3f> VELOCITY = class_2945.method_12791(VertexOrbProjectileEntity.class, (class_2941)class_2943.field_42237);
    private static final class_2940<Integer> RADIUS = class_2945.method_12791(VertexOrbProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DYING_TICK = class_2945.method_12791(VertexOrbProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> GROUND_COLLISION = class_2945.method_12791(VertexOrbProjectileEntity.class, (class_2941)class_2943.field_13323);
    private static final int BASE_DAMAGE = 6;
    private static final int SLOWNESS_DURATION = 20;
    private static final int SLOWNESS_AMPLIFIER = 4;
    private static final float HEALTH = 5.0f;
    private static final double BEAM_INITIAL_PARTICLE_SPACING = 0.5;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MIN = 0.2f;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MAX = 0.4f;
    private static final double BEAM_PARTICLE_SPACING = 0.1;
    private static final float BEAM_PARTICLE_SCALE = 0.05f;
    private static final float MAX_RANDOM_PARTICLE_SCALE_MULTIPLIER = 3.0f;
    public static final int DURATION_ON_GROUND = 300;
    private double xPower;
    private double yPower;
    private double zPower;
    private int life;
    private int expansionTick;
    private boolean hasAppliedMovement;
    private boolean hasLanded;
    private boolean delayTick;
    private boolean explosionImmune;

    public VertexOrbProjectileEntity(class_1299<? extends VertexOrbProjectileEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public VertexOrbProjectileEntity(class_1937 level, class_1309 owner, int radius) {
        this((class_1299<? extends VertexOrbProjectileEntity>)DNLEntityTypes.VERTEX_ORB_PROJECTILE.get(), level);
        this.setOwner((class_1297)owner);
        this.setRadius(radius);
        this.setDyingTick(0);
        this.life = 0;
    }

    @Override
    protected void method_5749(class_2487 compoundTag) {
        class_2499 listTag;
        super.method_5749(compoundTag);
        if (compoundTag.method_10573("power", 9) && (listTag = compoundTag.method_10554("power", 6)).size() == 3) {
            this.xPower = listTag.method_10611(0);
            this.yPower = listTag.method_10611(1);
            this.zPower = listTag.method_10611(2);
        }
        if (compoundTag.method_10573("life", 3)) {
            this.life = compoundTag.method_10550("life");
        }
        if (compoundTag.method_10573("radius", 3)) {
            this.setRadius(compoundTag.method_10550("radius"));
        }
        this.hasLanded = compoundTag.method_10577("hasLanded");
    }

    @Override
    protected void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10566("power", (class_2520)this.method_5846(new double[]{this.xPower, this.yPower, this.zPower}));
        compoundTag.method_10569("life", this.life);
        compoundTag.method_10569("radius", this.getRadius());
        compoundTag.method_10556("hasLanded", this.hasLanded);
    }

    protected void method_5693() {
        this.field_6011.method_12784(HURT_TIME, (Object)0);
        this.field_6011.method_12784(HURT_TIME_DIRECT, (Object)1);
        this.field_6011.method_12784(DAMAGE, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(VELOCITY, (Object)class_243.field_1353.method_46409());
        this.field_6011.method_12784(RADIUS, (Object)0);
        this.field_6011.method_12784(DYING_TICK, (Object)0);
        this.field_6011.method_12784(GROUND_COLLISION, (Object)false);
    }

    @Override
    protected void tickProjectile() {
        if (this.getDyingTick() > 0) {
            this.setDyingTick(this.getDyingTick() - 1);
            if (this.getDyingTick() <= 0) {
                this.method_31472();
            }
            return;
        }
        if (!this.hasAppliedMovement) {
            if (!this.method_37908().field_9236) {
                this.method_18800(this.xPower, this.yPower, this.zPower);
                this.setVelocity(new class_243(this.xPower, this.yPower, this.zPower));
            } else {
                double d = this.getVelocity().x * this.getVelocity().x + this.getVelocity().y * this.getVelocity().y + this.getVelocity().z * this.getVelocity().z;
                if (!this.delayTick && d < 1.0E-7) {
                    this.delayTick = true;
                    return;
                }
                this.method_18799(new class_243((double)this.getVelocity().x, (double)this.getVelocity().y, (double)this.getVelocity().z));
            }
            this.hasAppliedMovement = true;
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        this.method_5852();
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (this.life <= 0) {
            this.method_37908().method_8406((class_2394)class_2390.field_11188, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        }
        if (this.method_24828() || this.field_5976 || this.method_18798().method_1027() < 1.0E-7 && this.life <= 0) {
            this.life = 300;
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15152, this.method_5634(), 3.0f, 1.0f);
            this.spawnInitialRedstoneParticles();
            this.expansionTick = 40;
            if (!this.method_37908().field_9236) {
                this.field_6011.method_12778(GROUND_COLLISION, (Object)this.method_24828());
            }
            this.blockDestruction();
        }
        if (this.life > 0) {
            --this.life;
            if (this.expansionTick > 0) {
                --this.expansionTick;
            }
            this.applyEffect();
            if (this.life > 50) {
                this.spawnRedstoneParticle();
            }
            if (!(this.method_37908().field_9236 || this.life > 0 && ((Boolean)this.field_6011.method_12789(GROUND_COLLISION)).booleanValue() && !this.method_37908().method_8320(this.method_24515().method_10074()).method_26215())) {
                this.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    public void method_18799(class_243 vec31) {
        class_243 vec3 = vec31;
        if (((Boolean)this.field_6011.method_12789(GROUND_COLLISION)).booleanValue()) {
            vec3 = class_243.field_1353;
        }
        super.method_18799(vec3);
    }

    private void blockDestruction() {
        if (this.method_37908().field_9236) {
            return;
        }
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15152, class_3419.field_15245, 4.0f, (1.0f + (this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
        class_2338 pos = this.method_24515();
        int r = this.getRadius();
        for (int x = -r; x <= r; ++x) {
            for (int z = -r; z <= r; ++z) {
                for (int y = -r; y <= r; ++y) {
                    class_2338 targetPos = new class_2338(pos.method_10263() + x, pos.method_10264() + y, pos.method_10260() + z);
                    class_2680 blockState = this.method_37908().method_8320(targetPos);
                    if (blockState.method_26215() || blockState.method_26164(class_3481.field_17754) || blockState.method_26164(DNLTags.TORCH_BLOCKS)) continue;
                    DNLLevelUtil.destroyBlockMulti(this.method_37908(), targetPos, false, this, 3);
                }
            }
        }
    }

    private void applyEffect() {
        class_1937 level = this.method_37908();
        if (level.field_9236) {
            return;
        }
        int r = this.getRadius();
        class_238 effectBox = new class_238(this.method_23317() - (double)r, this.method_23318() - (double)r, this.method_23321() - (double)r, this.method_23317() + (double)r, this.method_23318() + (double)r, this.method_23321() + (double)r);
        List entities = this.method_37908().method_18467(class_1309.class, effectBox);
        for (class_1309 entity : entities) {
            if (entity instanceof FairkeeperSerpentEntity || !this.applyDamage((class_1297)entity, 6, 0.6f)) continue;
            entity.method_6092(new class_1293(class_1294.field_5909, 20, 4));
            this.spawnRedstoneBeamParticle((class_3218)level, entity);
        }
    }

    private void spawnRedstoneBeamParticle(class_3218 level, class_1309 target) {
        class_243 start = this.method_19538().method_1031(0.0, this.method_5829().method_17940() / 2.0, 0.0);
        class_243 end = target.method_19538().method_1031(0.0, (double)target.method_17682() * 0.5, 0.0);
        class_243 direction = end.method_1020(start);
        double distance = direction.method_1033();
        double stepSize = 0.5;
        int particleCount = (int)(distance / stepSize);
        class_243 step = direction.method_1029().method_1021(stepSize);
        float particleScale = 0.2f + (float)Math.random() * 0.2f;
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
        for (int i = 0; i <= particleCount; ++i) {
            class_243 particlePos = start.method_1019(step.method_1021((double)i));
            level.method_14199((class_2394)particleData, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void spawnInitialRedstoneParticles() {
        float particleScale = 0.2f + (float)Math.random() * 0.2f;
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
        for (int i = 0; i < 10; ++i) {
            this.method_37908().method_8406((class_2394)particleData, this.method_23317() + (double)(2.0f * (this.method_37908().method_8409().method_43057() - this.method_37908().method_8409().method_43057())), this.method_23318() + (double)(2.0f * (this.method_37908().method_8409().method_43057() - this.method_37908().method_8409().method_43057())), this.method_23321() + (double)(2.0f * (this.method_37908().method_8409().method_43057() - this.method_37908().method_8409().method_43057())), 0.0, 0.0, 0.0);
        }
        this.method_37908().method_8406((class_2394)class_2398.field_11236, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
    }

    private void spawnRedstoneParticle() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        if (this.method_37908().method_8409().method_43057() > 0.3f) {
            return;
        }
        int radius = this.getRadius();
        class_243 center = this.method_19538();
        double centerX = center.field_1352;
        double centerY = center.field_1351 - 0.5;
        double centerZ = center.field_1350;
        int side = this.method_37908().method_8409().method_43048(4);
        double x = centerX;
        double z = centerZ;
        float angleToSide = 0.0f;
        switch (side) {
            case 0: {
                x = centerX + (double)radius + 0.49;
                z = centerZ - (double)radius + this.method_37908().method_8409().method_43058() * (double)(radius * 2);
                angleToSide = 270.0f;
                break;
            }
            case 1: {
                x = centerX - (double)radius - 0.49;
                z = centerZ - (double)radius + this.method_37908().method_8409().method_43058() * (double)(radius * 2);
                angleToSide = 90.0f;
                break;
            }
            case 2: {
                z = centerZ + (double)radius + 0.49;
                x = centerX - (double)radius + this.method_37908().method_8409().method_43058() * (double)(radius * 2);
                angleToSide = 180.0f;
                break;
            }
            case 3: {
                z = centerZ - (double)radius - 0.49;
                x = centerX - (double)radius + this.method_37908().method_8409().method_43058() * (double)(radius * 2);
                angleToSide = 360.0f;
            }
        }
        angleToSide = (angleToSide + 360.0f) % 360.0f;
        serverLevel.method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.VERTEX_BOUNDARY_PARTICLE.get(), 1, angleToSide), x, centerY, z, 1, 0.0, 0.02, 0.0, 0.0);
    }

    private void spawnParticleOnAllPlanes(class_2394 particleData, class_243 center, int radius) {
        double centerX = center.field_1352;
        double centerY = center.field_1351;
        double centerZ = center.field_1350;
    }

    @Override
    protected void onHitEntity(class_3966 entityHitResult) {
        this.applyDamage(entityHitResult.method_17782(), 6, 0.6f);
    }

    private boolean applyDamage(class_1297 targetEntity, int baseDamage, float ownerAttackPercentage) {
        class_1297 class_12972;
        class_1309 owner = null;
        int damage = baseDamage;
        if (this.method_24921() != null && (class_12972 = this.method_24921()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            damage = (int)(livingEntity.method_26825(class_5134.field_23721) * (double)ownerAttackPercentage);
            owner = livingEntity;
        }
        if (targetEntity instanceof class_1309) {
            class_1309 target = (class_1309)targetEntity;
            return target.method_5643(this.method_37908().method_48963().method_48800((class_1297)this, owner), (float)damage);
        }
        return false;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public boolean method_30949(class_1297 entity) {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    public void method_5697(class_1297 $$0) {
    }

    public void method_5762(double $$0, double $$1, double $$2) {
    }

    public boolean method_5679(class_1282 damageSource) {
        if (damageSource.method_49708(class_8111.field_42331)) {
            return true;
        }
        return super.method_5679(damageSource);
    }

    public boolean method_5643(class_1282 damageSource, float f) {
        boolean bl;
        if (this.method_5679(damageSource)) {
            return false;
        }
        if (this.getDyingTick() > 0) {
            return false;
        }
        if (this.method_37908().field_9236 || this.method_31481()) {
            return true;
        }
        if (this.explosionImmune) {
            return false;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + f);
        this.method_5785();
        this.method_32875(class_5712.field_28736, damageSource.method_5529());
        boolean bl2 = bl = damageSource.method_5529() instanceof class_1657 && ((class_1657)damageSource.method_5529()).method_31549().field_7477;
        if (bl || this.getDamage() > 5.0f) {
            if (this.getLife() > 0) {
                this.setDyingTick(20);
                this.method_18382();
            } else {
                this.method_31472();
            }
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), 1.0f);
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15152, this.method_5634(), 1.0f, 2.0f);
            ((class_3218)this.method_37908()).method_14199((class_2394)particleData, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        return true;
    }

    public class_4048 method_18377(class_4050 pose) {
        if (this.getDyingTick() > 0) {
            return class_4048.method_18385((float)0.0f, (float)0.0f);
        }
        return class_4048.method_18384((float)1.0f, (float)1.0f);
    }

    public void method_5879(float f) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public void shootTowardsTarget(double x, double y, double z, class_1309 target, float speed, float inaccuracy) {
        this.shoot(x, y, z, target.method_23317(), target.method_23318(), target.method_23321(), speed, inaccuracy);
    }

    public void shoot(double x, double y, double z, double targetX, double targetY, double targetZ, float speed, float inaccuracy) {
        this.method_5808(x, y, z, this.method_36454(), this.method_36455());
        this.method_23311();
        class_243 direction = new class_243(targetX - this.method_23317(), targetY - this.method_23318(), targetZ - this.method_23321()).method_1029();
        double randX = class_3532.method_15366((class_5819)this.field_5974, (double)-1.0, (double)1.0) * (double)inaccuracy;
        double randY = class_3532.method_15366((class_5819)this.field_5974, (double)-1.0, (double)1.0) * (double)inaccuracy;
        double randZ = class_3532.method_15366((class_5819)this.field_5974, (double)-1.0, (double)1.0) * (double)inaccuracy;
        class_243 inaccurateDirection = new class_243(direction.field_1352 + randX, direction.field_1351 + randY, direction.field_1350 + randZ).method_1029();
        this.xPower = inaccurateDirection.field_1352 * (double)speed;
        this.yPower = inaccurateDirection.field_1351 * (double)speed;
        this.zPower = inaccurateDirection.field_1350 * (double)speed;
        this.method_18800(this.xPower, this.yPower, this.zPower);
        this.setVelocity(new class_243(this.xPower, this.yPower, this.zPower));
        this.hasAppliedMovement = true;
    }

    public int getLife() {
        return this.life;
    }

    public int getMaxLife() {
        return 300;
    }

    public void setDamage(float f) {
        this.field_6011.method_12778(DAMAGE, (Object)Float.valueOf(f));
    }

    public float getDamage() {
        return ((Float)this.field_6011.method_12789(DAMAGE)).floatValue();
    }

    public void setHurtTime(int i) {
        this.field_6011.method_12778(HURT_TIME, (Object)i);
    }

    public int getHurtTime() {
        return (Integer)this.field_6011.method_12789(HURT_TIME);
    }

    public void setHurtDir(int i) {
        this.field_6011.method_12778(HURT_TIME_DIRECT, (Object)i);
    }

    public int getHurtDir() {
        return (Integer)this.field_6011.method_12789(HURT_TIME_DIRECT);
    }

    public void setVelocity(class_243 vec3) {
        this.field_6011.method_12778(VELOCITY, (Object)vec3.method_46409());
    }

    public Vector3f getVelocity() {
        return (Vector3f)this.field_6011.method_12789(VELOCITY);
    }

    public void setRadius(int radius) {
        this.field_6011.method_12778(RADIUS, (Object)radius);
    }

    public int getRadius() {
        return (Integer)this.field_6011.method_12789(RADIUS);
    }

    public void setDyingTick(int tick) {
        this.field_6011.method_12778(DYING_TICK, (Object)tick);
    }

    public int getDyingTick() {
        return (Integer)this.field_6011.method_12789(DYING_TICK);
    }

    public int getExpansionTick() {
        return this.expansionTick;
    }
}

