/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.passive;

import dev.hexnowloading.dungeonnowloading.entity.util.AnimationChainer;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.PlayerSupporterEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.util.SummonFlag;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1538;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_4582;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperCreepEntity
extends class_1314
implements PlayerSupporterEntity,
class_4582 {
    private static final String DEFUSED_CUSTOM_NAME = "Defused";
    private static final float EXPLOSION_RADIUS = 3.0f;
    private static final float POWERED_EXPLOSION_RADIUS = 5.0f;
    private final class_1322 SPEED_MODIFIER = new class_1322(UUID.randomUUID(), "Slowdown Speed", -1.0, class_1322.class_1323.field_6330);
    private static final class_2940<Optional<UUID>> SUMMONER_UUID = class_2945.method_12791(CopperCreepEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> DATA_IS_POWERED = class_2945.method_12791(CopperCreepEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_IS_IGNITED = class_2945.method_12791(CopperCreepEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_IS_ALREADY_SUMMONED = class_2945.method_12791(CopperCreepEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<State> STATE = class_2945.method_12791(CopperCreepEntity.class, EntityStates.COPPER_CREEP_STATE);
    private static final class_2940<Skin> SKIN = class_2945.method_12791(CopperCreepEntity.class, EntityStates.COPPER_CREEP_SKIN);
    private static final class_2940<CopperCreepAnimationState> ANIMATION_STATE = class_2945.method_12791(CopperCreepEntity.class, EntityStates.COPPER_CREEP_ANIMATION_STATE);
    private static final class_2940<Boolean> SKIN_VALIDATION = class_2945.method_12791(CopperCreepEntity.class, (class_2941)class_2943.field_13323);
    private static final byte TRIGGER_IDLE_ANIMATION_STATE = 70;
    private static final byte TRIGGER_WALKING_ANIMATION_STATE = 71;
    private static final byte TRIGGER_RUNNING_ANIMATION_STATE = 72;
    private static final byte TRIGGER_SUMMON_ANIMATION_STATE = 73;
    private static final byte TRIGGER_DETONATION_ANIMATION_STATE = 74;
    private static final byte TRIGGER_SIT_ANIMATION_STATE = 75;
    private static final byte TRIGGER_STAND_ANIMATION_STATE = 76;
    private static final byte TRIGGER_WRONG_OWNER_ANIMATION_STATE = 77;
    private static final byte TRIGGER_SITTING_ANIMATION_STATE = 78;
    private static final byte TRIGGER_SITTING_DETONATION_STATE = 79;
    public class_7094 idleAnimationState = new class_7094();
    public class_7094 walkingAnimationState = new class_7094();
    public class_7094 runningAnimationState = new class_7094();
    public class_7094 summonAnimationState = new class_7094();
    public class_7094 detonationAnimationState = new class_7094();
    public class_7094 sitAnimationState = new class_7094();
    public class_7094 standAnimationState = new class_7094();
    public class_7094 wrongOwnerAnimationState = new class_7094();
    public class_7094 sittingAnimationState = new class_7094();
    public class_7094 sittingDetonationAnimationState = new class_7094();
    private int lightningAttractTimer = 0;
    private int swell = 0;
    private final int MAX_SWELL = class_3532.method_15386((float)25.0f);
    private class_1657 summoner;
    private int aiTick;
    private int sitAnimationTick;
    private int standAnimationTick;
    private AnimationChainer<CopperCreepAnimationState> animationChainer = new AnimationChainer();
    public State currentState;

    public CopperCreepEntity(class_1299<? extends CopperCreepEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6194 = 0;
        this.summoner = null;
        this.lightningAttractTimer = 60 * (3 + this.field_5974.method_43048(28));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1314.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23719, (double)0.175f);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new CopperCreepSittingGoal(this));
        this.field_6201.method_6277(3, (class_1352)new CopperCreepFollowSummoner(this));
        this.field_6201.method_6277(4, (class_1352)new CustomMeleeAttackGoal(this, 2.0, false));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1588.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1588.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true, livingEntity -> {
            class_1657 player;
            return livingEntity instanceof class_1657 && this.isPlayerOnDifferentTeam(player = (class_1657)livingEntity);
        }));
    }

    public void ignite() {
        this.field_6011.method_12778(DATA_IS_IGNITED, (Object)true);
    }

    public float getSwelling(float f) {
        if (this.MAX_SWELL == 0) {
            return 0.0f;
        }
        return class_3532.method_15363((float)((float)this.swell / (float)this.MAX_SWELL), (float)0.0f, (float)1.0f);
    }

    public Optional<UUID> getSummonerUUID() {
        return (Optional)this.field_6011.method_12789(SUMMONER_UUID);
    }

    public void setSummonerUUID(UUID summonerUUID) {
        this.field_6011.method_12778(SUMMONER_UUID, Optional.of(summonerUUID));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ANIMATION_STATE, (Object)CopperCreepAnimationState.IDLE);
        this.field_6011.method_12784(SUMMONER_UUID, Optional.empty());
        this.field_6011.method_12784(DATA_IS_POWERED, (Object)false);
        this.field_6011.method_12784(DATA_IS_IGNITED, (Object)false);
        this.field_6011.method_12784(DATA_IS_ALREADY_SUMMONED, (Object)false);
        this.field_6011.method_12784(STATE, (Object)State.SUMMONING);
        this.field_6011.method_12784(SKIN, (Object)Skin.DEFAULT);
        this.field_6011.method_12784(SKIN_VALIDATION, (Object)false);
    }

    public void method_5652(@NotNull class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.getSummonerUUID().ifPresent(uuid -> compoundTag.method_25927("summonerUUID", uuid));
        if (((Boolean)this.field_6011.method_12789(DATA_IS_POWERED)).booleanValue()) {
            compoundTag.method_10556("powered", true);
        }
        compoundTag.method_10556("ignited", this.isIgnited());
        compoundTag.method_10556("isAlreadySummoned", this.isAlreadySummoned());
        compoundTag.method_10556("isSitting", this.isState(State.SITTING));
        compoundTag.method_10556("isWandering", this.isState(State.WANDERING));
        compoundTag.method_10582("skin", this.getSkin().getId());
    }

    public void method_5749(@NotNull class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (compoundTag.method_10545("summonerUUID")) {
            UUID summonerUUID = compoundTag.method_25926("summonerUUID");
            this.setSummonerUUID(summonerUUID);
        }
        this.field_6011.method_12778(DATA_IS_POWERED, (Object)compoundTag.method_10577("powered"));
        if (compoundTag.method_10577("ignited") && !this.isDefused()) {
            this.ignite();
        }
        this.field_6011.method_12778(DATA_IS_ALREADY_SUMMONED, (Object)compoundTag.method_10577("isAlreadySummoned"));
        if (compoundTag.method_10577("isSitting")) {
            this.setState(State.SITTING);
        }
        if (compoundTag.method_10577("isWandering")) {
            this.setState(State.WANDERING);
        }
        if (SummonFlag.isSummoning()) {
            this.setSkinValidation(true);
        }
        if (compoundTag.method_10545("skin") && !((Boolean)this.field_6011.method_12789(SKIN_VALIDATION)).booleanValue()) {
            this.field_6011.method_12778(SKIN, (Object)Skin.fromId(compoundTag.method_10558("skin")));
        }
        this.setSkinValidation(true);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (itemStack.method_31573(class_3489.field_41662)) {
            class_3414 soundEvent = itemStack.method_31574(class_1802.field_8814) ? class_3417.field_15013 : class_3417.field_15145;
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            if (!this.isDefused()) {
                this.ignite();
            }
            if (!this.method_37908().field_9236) {
                if (!itemStack.method_7963()) {
                    itemStack.method_7934(1);
                } else {
                    itemStack.method_7956(1, (class_1309)player, playerx -> playerx.method_20236(interactionHand));
                }
            }
        } else if (!this.method_37908().field_9236) {
            Optional<UUID> summonerUUID = this.getSummonerUUID();
            if (summonerUUID.isPresent() && summonerUUID.get().equals(player.method_5667())) {
                if (this.getState() == State.IDLE || this.getState() == State.FOLLOWING) {
                    if (this.isDefused() && this.canSit() && this.sitAnimationTick <= 0) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"entity.dungeonnowloading.copper_creep.state_wander"), true);
                        this.setState(State.WANDERING);
                    } else {
                        this.rightClickToSit(player);
                    }
                } else if (this.getState() == State.WANDERING && this.canSit() && this.sitAnimationTick <= 0) {
                    this.rightClickToSit(player);
                } else if (this.getState() == State.SITTING && this.sitAnimationTick <= 0) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"entity.dungeonnowloading.copper_creep.state_follow"), true);
                    this.standUp();
                }
            } else {
                this.playWrongOwnerAnimation();
            }
        }
        return class_1269.method_29236((boolean)this.method_37908().field_9236);
    }

    private void rightClickToSit(class_1657 player) {
        player.method_7353((class_2561)class_2561.method_43471((String)"entity.dungeonnowloading.copper_creep.state_sit"), true);
        this.triggerSitAnimation();
        this.setState(State.SIT);
        this.method_43077(DNLSounds.COPPER_CREEP_SIT_DOWN.get());
        this.method_5942().method_6340();
        class_1324 moveSpeedAttr = this.method_5996(class_5134.field_23719);
        if (moveSpeedAttr != null && !moveSpeedAttr.method_6196(this.SPEED_MODIFIER)) {
            moveSpeedAttr.method_26835(this.SPEED_MODIFIER);
        }
        this.sitAnimationTick = class_3532.method_15386((float)15.0f);
    }

    private boolean canSit() {
        return !this.method_5816() && this.method_24828();
    }

    public class_1657 getSummoner() {
        if (this.summoner == null) {
            Optional<UUID> summonerUUID = this.getSummonerUUID();
            summonerUUID.ifPresent(value -> {
                this.summoner = this.method_37908().method_18470(value);
            });
        }
        return this.summoner;
    }

    public boolean method_6872() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_POWERED);
    }

    public boolean isIgnited() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_IGNITED);
    }

    public void method_5958() {
        if (this.aiTick == 0 && !this.isAlreadySummoned()) {
            this.setState(State.SUMMONING);
            this.triggerSummonAnimation();
            this.method_43077(DNLSounds.COPPER_CREEP_SPAWN.get());
            this.field_6011.method_12778(DATA_IS_ALREADY_SUMMONED, (Object)true);
        }
        if (this.isState(State.SUMMONING) && this.aiTick == 20) {
            this.setState(State.IDLE);
        }
        if (this.getState() != State.SIT && this.getState() != State.SITTING && this.getState() != State.STAND && this.getState() != State.WANDERING) {
            if (this.method_5968() == null) {
                this.setState(State.IDLE);
            } else {
                this.setState(State.FOLLOWING);
            }
        }
        if (this.sitAnimationTick-- > 0 && this.sitAnimationTick <= 0) {
            this.method_5942().method_6340();
            this.setState(State.SITTING);
        }
        if (this.standAnimationTick-- > 0 && this.standAnimationTick <= 0) {
            this.method_5942().method_6340();
            this.setState(State.IDLE);
        }
        ++this.aiTick;
        super.method_5958();
    }

    public boolean isAlreadySummoned() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_ALREADY_SUMMONED);
    }

    public void method_5773() {
        if (this.lightningAttractTimer > 0) {
            --this.lightningAttractTimer;
        }
        if (this.lightningAttractTimer == 0 && !this.method_6872()) {
            this.attemptToAttractLightning();
        }
        if (this.isIgnited()) {
            if (this.swell == 0) {
                if (this.getState() == State.SITTING) {
                    this.triggerSittingDetonationAnimation();
                    this.setState(State.SITTING_DETONATION);
                } else {
                    class_1324 moveSpeedAttr = this.method_5996(class_5134.field_23719);
                    if (moveSpeedAttr != null && !moveSpeedAttr.method_6196(this.SPEED_MODIFIER)) {
                        moveSpeedAttr.method_26835(this.SPEED_MODIFIER);
                    }
                    this.triggerDetonationAnimation();
                    this.setState(State.DETONATION);
                }
                this.method_43077(DNLSounds.COPPER_CREEP_PRIME.get());
            }
            if (this.swell < this.MAX_SWELL) {
                ++this.swell;
            } else if (!this.method_37908().field_9236) {
                this.field_6272 = true;
                float finalExplosionRadius = 3.0f;
                if (this.method_6872()) {
                    finalExplosionRadius = 5.0f;
                }
                class_1282 source = this.method_37908().method_48963().method_48819((class_1297)this, (class_1297)this.getSummoner());
                this.method_37908().method_8454((class_1297)this, source, null, this.method_23317(), this.method_23318(), this.method_23321(), finalExplosionRadius, false, class_1937.class_7867.field_40888);
                this.method_31472();
                this.spawnLingeringCloud();
            }
        }
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.animationChainer.tick(this::transitionTo);
        }
        if (!this.method_37908().field_9236) {
            return;
        }
        if (this.getState() == State.IDLE || this.getState() == State.WANDERING) {
            this.standAnimationState.method_41325();
            this.idleAnimationState.method_41324(this.field_6012);
        }
        if (this.getState() == State.SITTING) {
            this.sitAnimationState.method_41325();
            this.sittingAnimationState.method_41324(this.field_6012);
        }
    }

    private void spawnLingeringCloud() {
        Collection mobEffectInstances = this.method_6026();
        if (!mobEffectInstances.isEmpty()) {
            class_1295 areaEffectCloud = new class_1295(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321());
            areaEffectCloud.method_5603(2.5f);
            areaEffectCloud.method_5609(-0.5f);
            areaEffectCloud.method_5595(10);
            areaEffectCloud.method_5604(areaEffectCloud.method_5605() / 2);
            areaEffectCloud.method_5596(-areaEffectCloud.method_5599() / (float)areaEffectCloud.method_5605());
            for (class_1293 effectInstance : mobEffectInstances) {
                areaEffectCloud.method_5610(new class_1293(effectInstance));
            }
            this.method_37908().method_8649((class_1297)areaEffectCloud);
        }
    }

    public void method_5800(class_3218 serverLevel, class_1538 lightningBolt) {
        this.method_20803(this.method_20802() + 1);
        if (this.method_20802() == 0) {
            this.method_5639(8);
        }
        this.field_6011.method_12778(DATA_IS_POWERED, (Object)true);
    }

    private boolean isPlayerOnDifferentTeam(class_1657 player) {
        Optional<UUID> summonerUUID = this.getSummonerUUID();
        UUID playerUUID = player.method_5667();
        if (summonerUUID.isPresent() && summonerUUID.get().equals(playerUUID)) {
            return false;
        }
        if (player.method_7337() || player.method_7325()) {
            return false;
        }
        if (!summonerUUID.isPresent()) {
            return false;
        }
        class_1657 summoner = this.getSummoner();
        if (summoner == null) {
            return false;
        }
        boolean isAllied = player.method_5722((class_1297)summoner);
        return !isAllied;
    }

    public boolean isDefused() {
        return this.method_16914();
    }

    private void attemptToAttractLightning() {
        class_1538 lightningBolt;
        if (this.method_37908().method_8546() && this.hasClearSkyAbove() && (lightningBolt = (class_1538)class_1299.field_6112.method_5883(this.method_37908())) != null) {
            lightningBolt.method_24203(this.method_23317(), this.method_23318(), this.method_23321());
            this.method_37908().method_8649((class_1297)lightningBolt);
            this.field_6011.method_12778(DATA_IS_POWERED, (Object)true);
        }
    }

    private boolean hasClearSkyAbove() {
        class_2338 posAbove = this.method_24515().method_10084();
        while (posAbove.method_10264() < this.method_37908().method_31600()) {
            if (!this.method_37908().method_22347(posAbove)) {
                return false;
            }
            posAbove = posAbove.method_10084();
        }
        return true;
    }

    private void standUp() {
        this.triggerStandAnimation();
        this.setState(State.STAND);
        this.method_43077(DNLSounds.COPPER_CREEP_STAND_UP.get());
        this.method_5942().method_6340();
        class_1324 moveSpeedAttr = this.method_5996(class_5134.field_23719);
        if (moveSpeedAttr != null) {
            moveSpeedAttr.method_6202(this.SPEED_MODIFIER);
        }
        this.standAnimationTick = class_3532.method_15386((float)13.334f);
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        boolean hurt = super.method_5643(damageSource, amount);
        if (hurt && !this.method_37908().field_9236 && this.getState() == State.SITTING) {
            this.standUp();
        }
        return hurt;
    }

    protected float method_5867() {
        return this.field_5994 + 0.4f;
    }

    protected void method_5712(class_2338 pos, class_2680 blockState) {
        if (this.getState() == State.SITTING || this.getState() == State.SITTING_DETONATION) {
            return;
        }
        this.method_5783(DNLSounds.COPPER_CREEP_STEP.get(), 0.5f, 1.0f);
    }

    public class_1309.class_6823 method_39760() {
        return new class_1309.class_6823(DNLSounds.COPPER_CREEP_LAND.get(), DNLSounds.COPPER_CREEP_LAND.get());
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return DNLSounds.COPPER_CREEP_HIT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return DNLSounds.COPPER_CREEP_DEATH.get();
    }

    public State getState() {
        return (State)((Object)this.field_6011.method_12789(STATE));
    }

    public boolean isState(State state) {
        return this.getState().equals((Object)state);
    }

    private void playWrongOwnerAnimation() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(CopperCreepAnimationState.WRONG_OWNER, 0.3333f));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.looping(CopperCreepAnimationState.IDLE, 2.0f));
    }

    private void triggerSummonAnimation() {
        this.transitionTo(CopperCreepAnimationState.SUMMON);
    }

    private void triggerDetonationAnimation() {
        this.transitionTo(CopperCreepAnimationState.DETONATION);
    }

    private void triggerSitAnimation() {
        this.transitionTo(CopperCreepAnimationState.SIT);
    }

    private void triggerStandAnimation() {
        this.transitionTo(CopperCreepAnimationState.STAND);
    }

    private void triggerWrongOwnerAnimation() {
        this.transitionTo(CopperCreepAnimationState.WRONG_OWNER);
    }

    private void triggerSittingDetonationAnimation() {
        this.transitionTo(CopperCreepAnimationState.SITTING_DETONATION);
    }

    private void setState(State state) {
        this.currentState = state;
        this.field_6011.method_12778(STATE, (Object)state);
    }

    public Skin getSkin() {
        return (Skin)((Object)this.field_6011.method_12789(SKIN));
    }

    public void setSkin(Skin skin) {
        this.field_6011.method_12778(SKIN, (Object)skin);
    }

    public void setCosmeticMode(String id) {
        this.setSkin(Skin.fromId(id));
    }

    public void setSkinValidation(boolean skinValidation) {
        this.field_6011.method_12778(SKIN_VALIDATION, (Object)skinValidation);
    }

    public CopperCreepAnimationState getAnimationState() {
        return (CopperCreepAnimationState)((Object)this.field_6011.method_12789(ANIMATION_STATE));
    }

    public void setAnimationState(CopperCreepAnimationState animationState) {
        this.field_6011.method_12778(ANIMATION_STATE, (Object)animationState);
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (ANIMATION_STATE.equals(entityDataAccessor)) {
            CopperCreepAnimationState animationState = this.getAnimationState();
            this.resetAnimations();
            switch (animationState) {
                case IDLE: {
                    this.idleAnimationState.method_41324(this.field_6012);
                    break;
                }
                case SUMMON: {
                    this.summonAnimationState.method_41324(this.field_6012);
                    break;
                }
                case DETONATION: {
                    this.detonationAnimationState.method_41324(this.field_6012);
                    break;
                }
                case SIT: {
                    this.sitAnimationState.method_41324(this.field_6012);
                    break;
                }
                case STAND: {
                    this.standAnimationState.method_41324(this.field_6012);
                    break;
                }
                case WRONG_OWNER: {
                    this.wrongOwnerAnimationState.method_41324(this.field_6012);
                    break;
                }
                case SITTING: {
                    this.sittingAnimationState.method_41324(this.field_6012);
                    break;
                }
                case SITTING_DETONATION: {
                    this.sittingDetonationAnimationState.method_41324(this.field_6012);
                }
            }
        }
        super.method_5674(entityDataAccessor);
    }

    public CopperCreepEntity transitionTo(CopperCreepAnimationState animationState) {
        switch (animationState) {
            case IDLE: {
                this.setAnimationState(CopperCreepAnimationState.IDLE);
                break;
            }
            case SUMMON: {
                this.setAnimationState(CopperCreepAnimationState.SUMMON);
                break;
            }
            case DETONATION: {
                this.setAnimationState(CopperCreepAnimationState.DETONATION);
                break;
            }
            case SIT: {
                this.setAnimationState(CopperCreepAnimationState.SIT);
                break;
            }
            case STAND: {
                this.setAnimationState(CopperCreepAnimationState.STAND);
                break;
            }
            case WRONG_OWNER: {
                this.setAnimationState(CopperCreepAnimationState.WRONG_OWNER);
                break;
            }
            case SITTING: {
                this.setAnimationState(CopperCreepAnimationState.SITTING);
                break;
            }
            case SITTING_DETONATION: {
                this.setAnimationState(CopperCreepAnimationState.SITTING_DETONATION);
            }
        }
        return this;
    }

    private void resetAnimations() {
        this.idleAnimationState.method_41325();
        this.walkingAnimationState.method_41325();
        this.runningAnimationState.method_41325();
        this.summonAnimationState.method_41325();
        this.detonationAnimationState.method_41325();
        this.sitAnimationState.method_41325();
        this.sittingAnimationState.method_41325();
        this.standAnimationState.method_41325();
        this.wrongOwnerAnimationState.method_41325();
        this.sittingDetonationAnimationState.method_41325();
    }

    private class CopperCreepSittingGoal
    extends class_1352 {
        private final CopperCreepEntity copperCreep;

        public CopperCreepSittingGoal(CopperCreepEntity copperCreep) {
            this.copperCreep = copperCreep;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407, class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            return this.copperCreep.getState() == State.SITTING;
        }

        public void method_6269() {
            this.copperCreep.method_5942().method_6340();
            this.copperCreep.method_5980(null);
        }
    }

    private class CopperCreepFollowSummoner
    extends class_1352 {
        private final CopperCreepEntity copperCreep;
        private int updatePathTick;
        private float speed;

        public CopperCreepFollowSummoner(CopperCreepEntity copperCreep) {
            this.copperCreep = copperCreep;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.copperCreep.getState() == State.IDLE && this.copperCreep.method_5968() == null && this.copperCreep.getSummoner() != null;
        }

        public boolean method_6266() {
            return this.copperCreep.getState() != State.WANDERING && this.copperCreep.method_5968() == null && this.copperCreep.getSummoner() != null;
        }

        public void method_6270() {
            this.copperCreep.method_5942().method_6340();
        }

        public void method_6268() {
            if (this.updatePathTick-- > 0) {
                class_1657 summoner = this.copperCreep.getSummoner();
                float distance = this.copperCreep.method_5739((class_1297)summoner);
                if (distance < 5.0f) {
                    this.speed = 0.8f;
                    this.copperCreep.setState(State.WALKING_TOWARDS_PLAYER);
                } else {
                    this.speed = 2.0f;
                    this.copperCreep.setState(State.RUNNING_TOWARDS_PLAYER);
                }
            } else {
                this.copperCreep.method_5942().method_6335((class_1297)this.copperCreep.getSummoner(), (double)this.speed);
                this.updatePathTick = this.method_38847(10);
            }
        }
    }

    private class CustomMeleeAttackGoal
    extends class_1366 {
        private final CopperCreepEntity copperCreep;

        public CustomMeleeAttackGoal(CopperCreepEntity mob, double v, boolean b) {
            super((class_1314)mob, v, b);
            this.copperCreep = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.copperCreep.getState() != State.WANDERING && super.method_6264();
        }

        public boolean method_6266() {
            if (this.copperCreep.getState() != State.FOLLOWING) {
                return false;
            }
            return super.method_6266();
        }

        protected void method_6288(class_1309 $$0, double $$1) {
        }
    }

    public static enum CopperCreepAnimationState {
        IDLE,
        SUMMON,
        DETONATION,
        SIT,
        STAND,
        WRONG_OWNER,
        SITTING,
        SITTING_DETONATION;

    }

    public static enum State {
        SUMMONING,
        IDLE,
        RUNNING_TOWARDS_PLAYER,
        WALKING_TOWARDS_PLAYER,
        FOLLOWING,
        WANDERING,
        DETONATION,
        SITTING_DETONATION,
        SITTING,
        SIT,
        STAND,
        WRONG_OWNER;

    }

    public static enum Skin {
        DEFAULT("default"),
        BUTLER("butler");

        public final String name;

        private Skin(String name) {
            this.name = name;
        }

        public String getId() {
            return this.name;
        }

        public static Skin fromId(String id) {
            for (Skin skin : Skin.values()) {
                if (!skin.name.equalsIgnoreCase(id)) continue;
                return skin;
            }
            return DEFAULT;
        }
    }

    private class CopperCreepInWaterGoal
    extends class_1352 {
        private final CopperCreepEntity copperCreep;

        public CopperCreepInWaterGoal(CopperCreepEntity copperCreep) {
            this.copperCreep = copperCreep;
        }

        public boolean method_6264() {
            return this.copperCreep.getState() == State.SITTING && !this.copperCreep.canSit();
        }

        public void method_6269() {
            this.copperCreep.standUp();
        }
    }
}

