/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.monster;

import dev.hexnowloading.dungeonnowloading.entity.ai.AllRangeMeleeAttackGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ScuttleFlameThrowerAttackGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.SlumberingEntityLookAtPlayerGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.SlumberingEntityPlayerTargetGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.SlumberingEntityRandomStrollGoal;
import dev.hexnowloading.dungeonnowloading.entity.projectile.FlameProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.SlumberingEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1370;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class ScuttleEntity
extends class_1588
implements class_1569,
SlumberingEntity {
    private static final class_2940<ScuttleState> STATE = class_2945.method_12791(ScuttleEntity.class, EntityStates.SCUTTLE_STATE);
    private int aiTick = 0;
    private int renderOldTick;
    private boolean renderHeating;
    private boolean renderCooling;
    private float oldAgeInTicks;
    private boolean rotateStarted;
    private int flamePosOldTick;
    private boolean mouthOpeningStarted;
    private boolean mouthClosingStarted;
    public final class_7094 wakingUpAnimationState = new class_7094();
    public final class_7094 mouthOpenAnimationState = new class_7094();
    public final class_7094 mouthCloseAnimationState = new class_7094();
    public final class_7094 idleClosedAnimationState = new class_7094();
    public final class_7094 idleOpenedAnimationState = new class_7094();
    public final class_7094 blockFormAnimationState = new class_7094();
    private static final byte TRIGGER_WAKING_UP_ANIMATION_BYTE = 70;
    private static final byte TRIGGER_MOUTH_OPEN_ANIMATION_BYTE = 71;
    private static final byte TRIGGER_MOUTH_CLOSE_ANIMATION_BYTE = 72;
    private static final byte TRIGGER_IDLE_CLOSED_ANIMATION_BYTE = 73;
    private static final byte TRIGGER_IDLE_OPENED_ANIMATION_BYTE = 74;
    private static final byte TRIGGER_BLOCK_FORM_ANIMATION_BYTE = 75;
    private static final byte TRIGGER_ANIMATION_STOP_BYTE = 76;

    public ScuttleEntity(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
        this.setState(ScuttleState.SLUMBERING);
        this.field_6194 = 20;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 50.0).method_26868(class_5134.field_23721, 15.0).method_26868(class_5134.field_23722, 1.25).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23718, 0.5).method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23724, 20.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new ScuttleFlameThrowerAttackGoal(this));
        this.field_6201.method_6277(2, (class_1352)new AllRangeMeleeAttackGoal((class_1314)this, 1.0, true, 1.1f));
        this.field_6201.method_6277(3, (class_1352)new class_1370((class_1314)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new SlumberingEntityRandomStrollGoal((class_1314)this, 0.5));
        this.field_6201.method_6277(5, (class_1352)new SlumberingEntityLookAtPlayerGoal((class_1308)this, class_1657.class, 6.0f));
        this.field_6185.method_6277(2, (class_1352)new SlumberingEntityPlayerTargetGoal((class_1308)this));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(STATE, (Object)ScuttleState.SLUMBERING);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10556("Slumbering", this.isSlumbering());
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        boolean isSlumbering = compoundTag.method_10577("Slumbering");
        this.field_6011.method_12778(STATE, (Object)(isSlumbering ? ScuttleState.SLUMBERING : ScuttleState.CLOSED));
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            return;
        }
        double LOWER_FLAME_HEIGHT = 2.3;
        double HIGHER_FLAME_HEIGHT = 3.0;
        switch (this.getState()) {
            case OPENING: {
                float timeInSeconds;
                if (!this.isMouthOpeningStarted()) {
                    this.setFlamePosOldTick(this.field_6012);
                    this.setMouthOpeningStarted(true);
                }
                float time = (timeInSeconds = ((float)this.field_6012 - (float)this.getFlamePosOldTick()) / 20.0f - 0.38f) > 0.0f ? timeInSeconds / 0.19999999f : 0.0f;
                double height = time < 1.0f ? LOWER_FLAME_HEIGHT + (HIGHER_FLAME_HEIGHT - LOWER_FLAME_HEIGHT) * (double)time : HIGHER_FLAME_HEIGHT;
                this.animateParticles(0.03f, height, 0.1);
                break;
            }
            case OPENED: {
                this.setMouthOpeningStarted(false);
                this.animateParticles(0.2f, HIGHER_FLAME_HEIGHT, 0.7);
                ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.LARGE_FLAME_PARTICLE.get(), 1.0f);
                this.method_37908().method_8406((class_2394)particleData, this.method_23317() + ((double)this.method_6051().method_43057() - 0.5) * 0.3, this.method_23318() + HIGHER_FLAME_HEIGHT + 0.3 + ((double)this.method_6051().method_43057() - 0.5) * 0.3, this.method_23321() + ((double)this.method_6051().method_43057() - 0.5) * 0.3, 0.0, 0.0, 0.0);
                break;
            }
            case CLOSING: {
                float timeInSeconds;
                if (!this.isMouthClosingStarted()) {
                    this.setFlamePosOldTick(this.field_6012);
                    this.setMouthClosingStarted(true);
                }
                float time = (timeInSeconds = ((float)this.field_6012 - (float)this.getFlamePosOldTick()) / 20.0f - 0.38f) > 0.0f ? timeInSeconds / 0.08000001f : 0.0f;
                double height = time < 1.0f ? HIGHER_FLAME_HEIGHT - (HIGHER_FLAME_HEIGHT - LOWER_FLAME_HEIGHT) * (double)time : LOWER_FLAME_HEIGHT;
                this.animateParticles(0.03f, height, 0.1);
                break;
            }
            default: {
                this.setMouthClosingStarted(false);
                this.animateParticles(0.03f, LOWER_FLAME_HEIGHT, 0.1);
            }
        }
    }

    private void animateParticles(float chance, double height, double spread) {
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.LARGE_FLAME_PARTICLE.get(), 1.0f);
        this.method_37908().method_8494((class_2394)particleData, this.method_23317() + ((double)this.method_6051().method_43057() - 0.5) * spread, this.method_23318() + height + ((double)this.method_6051().method_43057() - 0.5) * 0.3, this.method_23321() + ((double)this.method_6051().method_43057() - 0.5) * spread, 0.0, 0.0, 0.0);
        if (this.method_6051().method_43057() < chance) {
            this.method_37908().method_8406((class_2394)class_2398.field_11239, this.method_23317() + ((double)this.method_6051().method_43057() - 0.5) * 0.3, this.method_23318() + height + ((double)this.method_6051().method_43057() - 0.5) * 0.3, this.method_23321() + ((double)this.method_6051().method_43057() - 0.5) * 0.3, 0.0, 0.0, 0.0);
            this.method_37908().method_8406((class_2394)class_2398.field_17430, this.method_23317() + ((double)this.method_6051().method_43057() - 0.5) * 0.3, this.method_23318() + height + ((double)this.method_6051().method_43057() - 0.5) * 0.3, this.method_23321() + ((double)this.method_6051().method_43057() - 0.5) * 0.3, 0.0, 0.02, 0.0);
        }
    }

    protected void method_5958() {
        if (this.isSlumbering()) {
            this.setState(ScuttleState.AWAKENING);
            this.triggerWakingUpAnimation();
            this.method_43077(DNLSounds.SCUTTLE_WAKING.get());
            this.aiTick = 72;
        }
        if (this.isState(ScuttleState.AWAKENING)) {
            if (this.aiTick > 0) {
                --this.aiTick;
            } else {
                this.setState(ScuttleState.CLOSED);
                this.triggerIdleClosedAnimation();
            }
        }
        super.method_5958();
    }

    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 compoundTag) {
        return super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected float method_18394(class_4050 pose, class_4048 entityDimensions) {
        return 1.45f;
    }

    public boolean method_5643(class_1282 damageSource, float damage) {
        if (!this.isAttackingState() && damageSource.method_5526() instanceof class_1665) {
            return false;
        }
        if (damageSource.method_5526() instanceof FlameProjectileEntity) {
            return false;
        }
        boolean hurtFr = super.method_5643(damageSource, damage);
        if (hurtFr) {
            this.playDeflectSound();
        }
        return hurtFr;
    }

    public boolean method_30948() {
        return this.isSlumbering();
    }

    public void method_5711(byte b) {
        switch (b) {
            case 70: {
                this.wakingUpAnimationState.method_41322(this.field_6012);
                break;
            }
            case 71: {
                this.mouthOpenAnimationState.method_41322(this.field_6012);
                break;
            }
            case 72: {
                this.idleOpenedAnimationState.method_41325();
                this.mouthCloseAnimationState.method_41322(this.field_6012);
                break;
            }
            case 73: {
                this.idleClosedAnimationState.method_41322(this.field_6012);
                break;
            }
            case 74: {
                this.mouthOpenAnimationState.method_41325();
                this.idleClosedAnimationState.method_41325();
                this.idleOpenedAnimationState.method_41322(this.field_6012);
                break;
            }
            case 75: {
                this.blockFormAnimationState.method_41322(this.field_6012);
                break;
            }
            case 76: {
                this.resetAnimations();
                break;
            }
            default: {
                super.method_5711(b);
            }
        }
    }

    private void resetAnimations() {
        this.wakingUpAnimationState.method_41325();
        this.mouthOpenAnimationState.method_41325();
        this.mouthCloseAnimationState.method_41325();
        this.idleOpenedAnimationState.method_41325();
        this.idleClosedAnimationState.method_41325();
        this.blockFormAnimationState.method_41325();
    }

    public void playDeflectSound() {
        this.method_5783(DNLSounds.SCUTTLE_DEFLECT.get(), 1.0f, 1.0f);
    }

    public void playShootingOpenSound() {
        this.method_5783(DNLSounds.SCUTTLE_SHOOTING_OPEN.get(), 1.5f, 1.0f);
    }

    public void playShootingChargeSound() {
        this.method_5783(DNLSounds.SCUTTLE_SHOOTING_CHARGE.get(), 1.5f, 1.0f);
    }

    public void playShootingBurstSound() {
        this.method_5783(DNLSounds.SCUTTLE_SHOOTING_BURST.get(), 1.5f, 1.0f);
    }

    public void playShootingFlameSound() {
        this.method_5783(DNLSounds.SCUTTLE_SHOOTING_FLAME.get(), 1.5f, 1.0f);
    }

    public void playShootingStopSound() {
        this.method_5783(DNLSounds.SCUTTLE_SHOOTING_STOP.get(), 1.5f, 1.0f);
    }

    public void playShootingCloseSound() {
        this.method_5783(DNLSounds.SCUTTLE_SHOOTING_CLOSE.get(), 1.5f, 1.0f);
    }

    @Nullable
    protected class_3414 method_5994() {
        return DNLSounds.SCUTTLE_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return DNLSounds.SCUTTLE_HURT.get();
    }

    protected class_3414 method_6002() {
        return DNLSounds.SCUTTLE_DEATH.get();
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        this.method_5783(DNLSounds.SCUTTLE_STEP.get(), 0.5f, 1.0f);
    }

    public void setRenderOldTick(int tick) {
        this.renderOldTick = tick;
    }

    public int getRenderOldTick() {
        return this.renderOldTick;
    }

    public void setRenderHeating(boolean b) {
        this.renderHeating = b;
    }

    public boolean isRenderHeating() {
        return this.renderHeating;
    }

    public void setRenderCooling(boolean b) {
        this.renderCooling = b;
    }

    public boolean isRenderCooling() {
        return this.renderCooling;
    }

    public void setOldAgeInTicks(float tick) {
        this.oldAgeInTicks = tick;
    }

    public float getOldAgeInTicks() {
        return this.oldAgeInTicks;
    }

    public void setRotateStarted(boolean b) {
        this.rotateStarted = b;
    }

    public boolean isRotateStarted() {
        return this.rotateStarted;
    }

    public int getFlamePosOldTick() {
        return this.flamePosOldTick;
    }

    public void setFlamePosOldTick(int flamePosOldTick) {
        this.flamePosOldTick = flamePosOldTick;
    }

    public boolean isMouthOpeningStarted() {
        return this.mouthOpeningStarted;
    }

    public void setMouthOpeningStarted(boolean mouthOpeningStarted) {
        this.mouthOpeningStarted = mouthOpeningStarted;
    }

    public boolean isMouthClosingStarted() {
        return this.mouthClosingStarted;
    }

    public void setMouthClosingStarted(boolean mouthClosingStarted) {
        this.mouthClosingStarted = mouthClosingStarted;
    }

    public void setState(ScuttleState scuttleState) {
        this.field_6011.method_12778(STATE, (Object)scuttleState);
    }

    public ScuttleState getState() {
        return (ScuttleState)((Object)this.field_6011.method_12789(STATE));
    }

    public boolean isState(ScuttleState scuttleState) {
        return this.getState().equals((Object)scuttleState);
    }

    public boolean isAttackingState() {
        return this.getState().equals((Object)ScuttleState.OPENING) || this.getState().equals((Object)ScuttleState.OPENED) || this.getState().equals((Object)ScuttleState.CLOSING);
    }

    public void triggerWakingUpAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)70);
    }

    public void triggerMouthOpenAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)71);
    }

    public void triggerMouthCloseAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)72);
    }

    public void triggerIdleOpenedAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)74);
    }

    public void triggerIdleClosedAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)73);
    }

    public void triggerBlockFormAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)75);
    }

    public void triggerAnimationStop() {
        this.method_37908().method_8421((class_1297)this, (byte)76);
    }

    @Override
    public boolean isStationary() {
        return this.getState().equals((Object)ScuttleState.SLUMBERING) || this.getState().equals((Object)ScuttleState.AWAKENING) || this.getState().equals((Object)ScuttleState.OPENING) || this.getState().equals((Object)ScuttleState.OPENED) || this.getState().equals((Object)ScuttleState.CLOSING);
    }

    @Override
    public boolean isSlumbering() {
        return this.isState(ScuttleState.SLUMBERING);
    }

    public static enum ScuttleState {
        SLUMBERING,
        AWAKENING,
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

