/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.monster;

import dev.hexnowloading.dungeonnowloading.entity.ai.BallistaGolemArrowAttackGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.BallistaGolemMeleeAttackGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.BallistaGolemReloadGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.SlumberingEntityPlayerTargetGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.control.move.BallistaGolemMoveControl;
import dev.hexnowloading.dungeonnowloading.entity.ai.control.pathfinding.BallistaGolemPathNavigation;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.SlumberingEntity;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStartTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStopTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1399;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1665;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2397;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import net.minecraft.class_7094;

public class BallistaGolemEntity
extends class_1588
implements class_1569,
SlumberingEntity {
    private static final class_2940<BallistaGolemState> STATE = class_2945.method_12791(BallistaGolemEntity.class, EntityStates.BALLISTA_GOLEM_STATE);
    private static final class_2940<Integer> ARROW_COUNT = class_2945.method_12791(BallistaGolemEntity.class, (class_2941)class_2943.field_13327);
    public static final int BALLISTA_GOLEM_MELEE_RANGE = 7;
    private int aiTick = 0;
    public final class_7094 wakeUpAnimationState = new class_7094();
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 reloadAnimationState = new class_7094();
    public final class_7094 shootAnimationState = new class_7094();
    private static final byte TRIGGER_WAKING_UP_ANIMATION_BYTE = 70;
    private static final byte TRIGGER_IDLE_ANIMATION_BYTE = 71;
    private static final byte TRIGGER_RELOAD_ANIMATION_BYTE = 72;
    private static final byte TRIGGER_SHOOT_ANIMATION_BYTE = 73;

    public BallistaGolemEntity(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
        this.setState(BallistaGolemState.SLUMBERING);
        this.setBallistaArrowCount(6);
        this.method_49477(1.0f);
        this.method_5941(class_7.field_6, 0.0f);
        this.field_6207 = new BallistaGolemMoveControl(this);
        this.field_6189 = new BallistaGolemPathNavigation((class_1308)this, this.method_37908());
        this.field_6194 = 50;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 100.0).method_26868(class_5134.field_23721, 19.0).method_26868(class_5134.field_23722, 1.0).method_26868(class_5134.field_23719, 0.35).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23724, 15.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new BallistaGolemReloadGoal(this));
        this.field_6201.method_6277(2, (class_1352)new BallistaGolemArrowAttackGoal(this));
        this.field_6201.method_6277(3, (class_1352)new BallistaGolemMeleeAttackGoal((class_1314)this, 1.0, true, 1.1f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new SlumberingEntityPlayerTargetGoal((class_1308)this));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(STATE, (Object)BallistaGolemState.SLUMBERING);
        this.field_6011.method_12784(ARROW_COUNT, (Object)6);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10556("Slumbering", this.isSlumbering());
        compoundTag.method_10569("ArrowCount", ((Integer)this.field_6011.method_12789(ARROW_COUNT)).intValue());
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        boolean isSlumbering = compoundTag.method_10577("Slumbering");
        this.field_6011.method_12778(STATE, (Object)(isSlumbering ? BallistaGolemState.SLUMBERING : BallistaGolemState.IDLE));
        this.field_6011.method_12778(ARROW_COUNT, (Object)compoundTag.method_10550("ArrowCount"));
    }

    public void method_5773() {
        super.method_5773();
    }

    protected void method_5958() {
        if (this.isSlumbering()) {
            this.setState(BallistaGolemState.AWAKENING);
            this.triggerWakingUpAnimation();
            this.aiTick = 153;
        }
        if (this.isState(BallistaGolemState.AWAKENING)) {
            if (this.aiTick == 147) {
                this.playBallsitaGolemSound(DNLSounds.BALLISTA_GOLEM_WAKING.get());
            }
            if (this.aiTick > 0) {
                --this.aiTick;
            } else {
                this.setState(BallistaGolemState.IDLE);
                this.triggerIdleAnimation();
            }
        }
        if (this.field_5976 && this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            boolean brokeLeaves = false;
            class_238 box = this.method_5829().method_1014(0.2);
            for (class_2338 pos : class_2338.method_10094((int)class_3532.method_15357((double)box.field_1323), (int)class_3532.method_15357((double)box.field_1322), (int)class_3532.method_15357((double)box.field_1321), (int)class_3532.method_15357((double)box.field_1320), (int)class_3532.method_15357((double)box.field_1325), (int)class_3532.method_15357((double)box.field_1324))) {
                boolean destroyed;
                class_2680 state = this.method_37908().method_8320(pos);
                if (!(state.method_26204() instanceof class_2397) || !(destroyed = this.method_37908().method_8651(pos, true, (class_1297)this))) continue;
                brokeLeaves = true;
            }
            if (!brokeLeaves && this.method_24828()) {
                this.method_6043();
            }
        }
        super.method_5958();
    }

    public double method_33191(class_1309 livingEntity) {
        return this.method_17681() * this.method_17681();
    }

    protected float method_18394(class_4050 pose, class_4048 entityDimensions) {
        return 2.0f;
    }

    public boolean method_30948() {
        return this.isSlumbering();
    }

    public void method_5711(byte b) {
        switch (b) {
            case 70: {
                this.wakeUpAnimationState.method_41322(this.field_6012);
                break;
            }
            case 71: {
                this.idleAnimationState.method_41322(this.field_6012);
                break;
            }
            case 73: {
                this.idleAnimationState.method_41325();
                this.shootAnimationState.method_41322(this.field_6012);
                break;
            }
            case 72: {
                this.idleAnimationState.method_41325();
                this.reloadAnimationState.method_41322(this.field_6012);
                break;
            }
            default: {
                super.method_5711(b);
            }
        }
    }

    public void playBallsitaGolemSound(class_3414 soundEvent) {
        float radius = 32.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        for (class_3222 player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.method_5628(), soundEvent.method_14833(), class_3419.field_15251), player);
        }
    }

    public void stopBallsitaGolemSounds() {
        float radius = 32.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        ArrayList<class_2960> soundsToStop = new ArrayList<class_2960>(List.of());
        soundsToStop.add(DNLSounds.BALLISTA_GOLEM_WAKING.get().method_14833());
        soundsToStop.add(DNLSounds.BALLISTA_GOLEM_RELOAD.get().method_14833());
        for (class_3222 player : nearbyPlayers) {
            for (class_2960 sound : soundsToStop) {
                Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(this.method_5628(), sound, 20, true), player);
            }
        }
    }

    protected float method_5867() {
        return this.field_5994 + 0.85f;
    }

    protected void method_5712(class_2338 $$0, class_2680 $$1) {
        this.method_5783(DNLSounds.BALLISTA_GOLEM_STEP.get(), 1.5f, 1.0f);
    }

    protected class_3414 method_6002() {
        return DNLSounds.BALLISTA_GOLEM_DEATH.get();
    }

    protected class_3414 method_6011(class_1282 $$0) {
        return DNLSounds.BALLISTA_GOLEM_HURT.get();
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        if (damageSource.method_5526() instanceof class_1665) {
            return false;
        }
        return super.method_5643(damageSource, amount);
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        if (!this.method_37908().field_9236) {
            this.stopBallsitaGolemSounds();
        }
    }

    @Override
    public boolean isSlumbering() {
        return this.isState(BallistaGolemState.SLUMBERING);
    }

    @Override
    public boolean isStationary() {
        return this.isSlumbering() || this.isState(BallistaGolemState.AWAKENING) || this.isState(BallistaGolemState.SHOOT) || this.isState(BallistaGolemState.RELOAD);
    }

    public void setBallistaArrowCount(int arrowCount) {
        this.field_6011.method_12778(ARROW_COUNT, (Object)arrowCount);
    }

    public int getBallistaArrowCount() {
        return (Integer)this.field_6011.method_12789(ARROW_COUNT);
    }

    public double getFollowDistance() {
        return this.method_26825(class_5134.field_23717);
    }

    public void setState(BallistaGolemState ballistaGolemState) {
        this.field_6011.method_12778(STATE, (Object)ballistaGolemState);
    }

    public BallistaGolemState getState() {
        return (BallistaGolemState)((Object)this.field_6011.method_12789(STATE));
    }

    public boolean isState(BallistaGolemState ballistaGolemState) {
        return this.getState().equals((Object)ballistaGolemState);
    }

    public void triggerWakingUpAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)70);
    }

    public void triggerIdleAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)71);
    }

    public void triggerShootAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)73);
    }

    public void triggerReloadAnimation() {
        this.method_37908().method_8421((class_1297)this, (byte)72);
    }

    public static enum BallistaGolemState {
        SLUMBERING,
        AWAKENING,
        IDLE,
        SHOOT,
        RELOAD;

    }
}

