/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.boss;

import com.mojang.logging.LogUtils;
import dev.hexnowloading.dungeonnowloading.entity.ai.BossTargetSelectorGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosAwakenGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosCircleAroundGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosDropScuttleGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosDropVertexPillarGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosShootVertexDomainGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperOurosShootVertexOrbGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.control.move.FairkeeperOurosMoveControl;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperOurosPartEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexDomainProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexOrbProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.AnimationChainer;
import dev.hexnowloading.dungeonnowloading.entity.util.Boss;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.SlumberingEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.WeightedTargetProvider;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStartTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStopTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLMobEffects;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import dev.hexnowloading.dungeonnowloading.util.DNLLevelUtil;
import dev.hexnowloading.dungeonnowloading.util.NbtHelper;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1334;
import net.minecraft.class_1352;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1665;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5635;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FairkeeperOurosEntity
extends class_1588
implements Boss,
class_1569,
SlumberingEntity,
FairkeeperSerpentEntity,
WeightedTargetProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2940<FairkeeperOurosState> STATE = class_2945.method_12791(FairkeeperOurosEntity.class, EntityStates.FAIRKEEPER_OUROS_STATE);
    private static final class_2940<FairkeeperOurosAnimationState> OUROS_ANIMATION_STATE = class_2945.method_12791(FairkeeperOurosEntity.class, EntityStates.FAIRKEEPER_OUROS_ANIMATION_STATE);
    private static final class_2940<Optional<UUID>> CHILD_UUID = class_2945.method_12791(FairkeeperOurosEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> IS_ON_CEILING = class_2945.method_12791(FairkeeperOurosEntity.class, (class_2941)class_2943.field_13323);
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 openMouthAnimationState = new class_7094();
    public final class_7094 openedMouthAnimationState = new class_7094();
    public final class_7094 closeMouthAnimationState = new class_7094();
    private final Deque<class_243> positionHistory = new LinkedList<class_243>();
    private final Map<UUID, Double> damageMap = new HashMap<UUID, Double>();
    private final Map<UUID, class_1309> attackers = new HashMap<UUID, class_1309>();
    private final Map<UUID, Double> threatScores = new HashMap<UUID, Double>();
    private float previousTilt = 0.0f;
    private FairkeeperSerpentCallerEntity fairkeeperSerpentCaller;
    private UUID callerUUID;
    private int attackTick;
    private int destructionTick;
    private int slitheringSoundTick;
    private int partIndex;
    private class_243 awakenEndPos;
    private boolean targetRandomPlayer;
    private boolean canDestroyBlocks;
    private boolean changeTarget;
    private class_1282 killedDamageSource;
    private AnimationChainer<FairkeeperOurosAnimationState> animationChainer = new AnimationChainer();
    private final class_3213 bossEvent;
    public static final int SEGMENT_COUNT = 14;
    public static int SEGMENT_DELAY_STEP = 13;
    private int mouthOpenAnimationTimeOut;
    private static final int MOUTH_OPEN_ANIMATION_DURATION = 19;
    private static final int SLITHERING_SOUND_INTERVAL = 140;

    public FairkeeperOurosEntity(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new FairkeeperOurosMoveControl((class_1308)this);
        this.field_6204 = new class_1334((class_1308)this);
        this.method_49477(0.0f);
        this.method_5971();
        this.field_6194 = 0;
        this.bossEvent = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5783, class_1259.class_1261.field_5795).method_5406(true);
    }

    public FairkeeperOurosEntity(class_1937 level, FairkeeperSerpentCallerEntity fairkeeperSerpentCaller) {
        this(DNLEntityTypes.FAIRKEEPER_OUROS.get(), level);
        this.fairkeeperSerpentCaller = fairkeeperSerpentCaller;
        this.callerUUID = this.fairkeeperSerpentCaller.method_5667();
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 500.0).method_26868(class_5134.field_23721, 20.0).method_26868(class_5134.field_23722, 1.5).method_26868(class_5134.field_23719, 0.4).method_26868(class_5134.field_23720, 0.4).method_26868(class_5134.field_23717, 30.0).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new FairkeeperOurosAwakenGoal(this));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.SUMMON_SCUTTLE, this, 20.0, 1.3, false, true));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosDropScuttleGoal(FairkeeperOurosState.SUMMON_SCUTTLE, this, 1));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosDropVertexPillarGoal(FairkeeperOurosState.DROP_PILLAR_LINE_CENTER, this, 1.3, FairkeeperOurosDropVertexPillarGoal.PATTERN_LINE_CENTER));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosDropVertexPillarGoal(FairkeeperOurosState.DROP_PILLAR_LINE_INNER, this, 1.7, FairkeeperOurosDropVertexPillarGoal.PATTERN_LINE_INNER));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosDropVertexPillarGoal(FairkeeperOurosState.DROP_PILLAR_LINE_OUTER, this, 1.7, FairkeeperOurosDropVertexPillarGoal.PATTERN_LINE_OUTER));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB, this, 20.0, 1.3, false, true));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosShootVertexOrbGoal(FairkeeperOurosState.SHOOT_SINGLE_VERTEX_ORB, this, 1, 0.05f, 2));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.SHOOT_TRIPLE_VERTEX_ORB, this, 20.0, 1.3, false, true));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosShootVertexOrbGoal(FairkeeperOurosState.SHOOT_TRIPLE_VERTEX_ORB, this, 3, 0.2f, 2));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.SHOOT_VERTEX_DOMAIN, this, 20.0, 1.3, false, true));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosShootVertexDomainGoal(FairkeeperOurosState.SHOOT_VERTEX_DOMAIN, this));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.SUMMON_MORE_SCUTTLES, this, 20.0, 1.3, false, true));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosDropScuttleGoal(FairkeeperOurosState.SUMMON_MORE_SCUTTLES, this, 3));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.DESPERATE, this, 20.0, 1.3, false, true));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperOurosShootVertexOrbGoal(FairkeeperOurosState.DESPERATE, this, 9, 0.2f, 2));
        this.field_6201.method_6277(4, (class_1352)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.IDLE, this, 20.0, 1.3, false, true));
        this.field_6201.method_6277(5, (class_1352)new FairkeeperOurosCircleAroundGoal(FairkeeperOurosState.IDLE, this, 20.0, 1.3, false, false));
        this.field_6185.method_6277(2, (class_1352)new BossTargetSelectorGoal((class_1308)this));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CHILD_UUID, Optional.empty());
        this.field_6011.method_12784(IS_ON_CEILING, (Object)false);
        this.field_6011.method_12784(STATE, (Object)FairkeeperOurosState.IDLE);
        this.field_6011.method_12784(OUROS_ANIMATION_STATE, (Object)FairkeeperOurosAnimationState.IDLE);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10556("Slumbering", this.isSlumbering());
        if (this.getChildId() != null) {
            compoundTag.method_25927("ChildUUID", this.getChildId());
        }
        if (this.getCallerId() != null) {
            compoundTag.method_25927("CallerUUID", this.getCallerId());
        }
        if (this.getAwakenEndPos() != null) {
            compoundTag.method_10566("AwakenEndPos", (class_2520)NbtHelper.newDoubleList(this.getAwakenEndPos().field_1352, this.getAwakenEndPos().field_1351, this.getAwakenEndPos().field_1350));
        }
        compoundTag.method_10556("CanDestroyBlocks", this.canDestroyBlocks);
        compoundTag.method_10556("Awakened", !this.isState(FairkeeperOurosState.AWAKENING));
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (this.method_16914()) {
            this.bossEvent.method_5413(this.method_5476());
        }
        if (compoundTag.method_25928("ChildUUID")) {
            this.setChildId(compoundTag.method_25926("ChildUUID"));
        }
        if (compoundTag.method_25928("CallerUUID")) {
            this.setCallerId(compoundTag.method_25926("CallerUUID"));
        }
        if (compoundTag.method_10545("AwakenEndPos")) {
            this.awakenEndPos = new class_243(compoundTag.method_10554("AwakenEndPos", 6).method_10611(0), compoundTag.method_10554("AwakenEndPos", 6).method_10611(1), compoundTag.method_10554("AwakenEndPos", 6).method_10611(2));
        }
        this.setCanDestroyBlocks(compoundTag.method_10577("CanDestroyBlocks"));
        this.setState(compoundTag.method_10577("Awakened") ? FairkeeperOurosState.IDLE : FairkeeperOurosState.AWAKENING);
    }

    public void method_5665(@Nullable class_2561 component) {
        super.method_5665(component);
        this.bossEvent.method_5413(this.method_5476());
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        this.bossEvent.method_14088(serverPlayer);
    }

    public void method_5742(class_3222 serverPlayer) {
        super.method_5742(serverPlayer);
        this.bossEvent.method_14089(serverPlayer);
    }

    public void method_5773() {
        super.method_5773();
        this.animationControl();
    }

    private void animationControl() {
        if (this.method_37908().field_9236) {
            return;
        }
        this.animationChainer.tick(this::transitionTo);
    }

    public void playMouthOpen() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosAnimationState.MOUTH_OPEN, 0.9167f, () -> this.playMouthOpenSound(this.method_23317(), this.method_23318(), this.method_23321()), null));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosAnimationState.MOUTH_OPENED, 0.1667f));
    }

    public void playMouthClose() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosAnimationState.MOUTH_CLOSE, 1.6667f, () -> this.playMouthCloseSound(this.method_23317(), this.method_23318(), this.method_23321()), null));
    }

    public void playDeathAnimation() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperOurosAnimationState.MOUTH_OPENED, 0.1667f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void segmentControl() {
        int i;
        class_1297 child = this.getChild();
        if (this.positionHistory.isEmpty()) {
            class_243 currentPos = this.method_19538();
            int requiredHistorySize = 15 * SEGMENT_DELAY_STEP;
            for (i = 0; i < requiredHistorySize; ++i) {
                this.positionHistory.addLast(currentPos);
            }
        }
        if (child == null && !this.method_29504()) {
            class_1588 partParent = this;
            int segments = 14;
            for (i = 0; i < segments; ++i) {
                FairkeeperOurosPartEntity bodyPartParent;
                FairkeeperOurosPartEntity part = new FairkeeperOurosPartEntity(DNLEntityTypes.FAIRKEEPER_OUROS_PART.get(), (class_1309)partParent, (class_1309)this, i);
                if (partParent == this) {
                    this.setChildId(part.method_5667());
                } else if (partParent instanceof FairkeeperOurosPartEntity && !(bodyPartParent = (FairkeeperOurosPartEntity)partParent).isTail()) {
                    if (!bodyPartParent.isTail()) {
                        bodyPartParent.setChildId(part.method_5667());
                    } else {
                        bodyPartParent.setChildId(null);
                    }
                }
                part.method_5814(partParent.method_23317(), partParent.method_23318(), partParent.method_23321());
                part.method_36456(partParent.method_36454());
                part.field_6283 = partParent.method_36454();
                part.field_6241 = partParent.method_36454();
                part.setRotatable(false);
                partParent = part;
                if (i == segments - 1) {
                    part.setTail(true);
                }
                this.method_37908().method_8649((class_1297)part);
            }
        }
        if (this.method_18798().method_1027() > 0.01) {
            Deque<class_243> deque = this.positionHistory;
            synchronized (deque) {
                this.positionHistory.addFirst(new class_243(this.method_23317(), this.method_23318(), this.method_23321()));
                int maxHistorySize = 15 * SEGMENT_DELAY_STEP;
                if (this.positionHistory.size() > maxHistorySize) {
                    this.positionHistory.pollLast();
                }
            }
        }
        if (!this.onCieling() && this.method_18798().field_1351 > 0.0) {
            this.method_18799(this.method_18798().method_18805(1.0, 0.8, 1.0));
        }
        if (!this.isState(FairkeeperOurosState.AWAKENING)) {
            this.lookTowardTarget();
        }
    }

    public class_243 getSegmentTargetPosition(int segmentIndex) {
        double segmentSpacing = 4.0;
        double targetDistance = (double)segmentIndex * segmentSpacing;
        ArrayList<class_243> history = new ArrayList<class_243>(this.positionHistory);
        if (history.size() < 2) {
            return this.method_19538();
        }
        class_243 current = (class_243)history.get(0);
        double accumulated = 0.0;
        for (int i = 1; i < history.size(); ++i) {
            class_243 next = (class_243)history.get(i);
            double dist = current.method_1022(next);
            if (accumulated + dist >= targetDistance) {
                double remaining = targetDistance - accumulated;
                double t = remaining / dist;
                return current.method_35590(next, t);
            }
            accumulated += dist;
            current = next;
        }
        return (class_243)history.get(history.size() - 1);
    }

    private void lookTowardTarget() {
        double directionX = this.method_5962().method_6236() - this.method_23317();
        double directionZ = this.method_5962().method_6237() - this.method_23321();
        double yaw = Math.toDegrees(Math.atan2(directionZ, directionX)) - 90.0;
        this.method_36456((float)yaw);
        this.field_6283 = (float)yaw;
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_5787()) {
            boolean isRising;
            double upwardGravity = -0.08;
            boolean bl = isRising = this.method_18798().field_1351 >= 0.0;
            if (isRising && this.method_6059(class_1294.field_5906)) {
                upwardGravity = -0.01;
            }
            if (this.method_6128()) {
                double collisionHorizontalVelocity;
                double collisionVelocityDifference;
                float collisionDamage;
                this.method_45318();
                class_243 currentVelocity = this.method_18798();
                class_243 lookDirection = this.method_5720();
                float pitchRadians = this.method_36455() * ((float)Math.PI / 180);
                double horizontalLookDistance = Math.sqrt(lookDirection.field_1352 * lookDirection.field_1352 + lookDirection.field_1350 * lookDirection.field_1350);
                double horizontalVelocity = currentVelocity.method_37267();
                double lookMagnitude = lookDirection.method_1033();
                double adjustedCosPitch = Math.cos(pitchRadians);
                adjustedCosPitch = adjustedCosPitch * adjustedCosPitch * Math.min(1.0, lookMagnitude / 0.4);
                currentVelocity = this.method_18798().method_1031(0.0, upwardGravity * (-1.0 + adjustedCosPitch * 0.75), 0.0);
                if (currentVelocity.field_1351 > 0.0 && horizontalLookDistance > 0.0) {
                    double risingAdjustment = currentVelocity.field_1351 * 0.1 * adjustedCosPitch;
                    currentVelocity = currentVelocity.method_1031(lookDirection.field_1352 * risingAdjustment / horizontalLookDistance, risingAdjustment, lookDirection.field_1350 * risingAdjustment / horizontalLookDistance);
                }
                if (pitchRadians > 0.0f && horizontalLookDistance > 0.0) {
                    double upwardAdjustment = horizontalVelocity * (double)class_3532.method_15374((float)pitchRadians) * 0.04;
                    currentVelocity = currentVelocity.method_1031(-lookDirection.field_1352 * upwardAdjustment / horizontalLookDistance, upwardAdjustment * 3.2, -lookDirection.field_1350 * upwardAdjustment / horizontalLookDistance);
                }
                if (horizontalLookDistance > 0.0) {
                    currentVelocity = currentVelocity.method_1031((lookDirection.field_1352 / horizontalLookDistance * horizontalVelocity - currentVelocity.field_1352) * 0.1, 0.0, (lookDirection.field_1350 / horizontalLookDistance * horizontalVelocity - currentVelocity.field_1350) * 0.1);
                }
                this.method_18799(currentVelocity.method_18805((double)0.99f, (double)0.98f, (double)0.99f));
                this.method_5784(class_1313.field_6308, this.method_18798());
                if (this.field_5976 && !this.method_37908().field_9236 && (collisionDamage = (float)((collisionVelocityDifference = horizontalVelocity - (collisionHorizontalVelocity = this.method_18798().method_37267())) * 10.0 - 3.0)) > 0.0f) {
                    this.method_5783(this.getFallDamageSound((int)collisionDamage), 1.0f, 1.0f);
                    this.method_5643(this.method_48923().method_48828(), collisionDamage);
                }
                if (this.onCieling() && !this.method_37908().field_9236) {
                    this.method_5729(7, false);
                }
            } else {
                class_2338 blockBelow = this.method_23314();
                float blockFriction = this.method_37908().method_8320(blockBelow).method_26204().method_9499();
                float groundFriction = this.onCieling() ? blockFriction * 0.91f : 0.91f;
                this.method_5724(this.getFrictionInfluencedSpeed(blockFriction), movementInput);
                this.method_18799(this.method_18798());
                this.method_5784(class_1313.field_6308, this.method_18798());
                class_243 adjustedMovement = this.method_18798();
                if ((this.field_5976 || this.field_6282) && (this.method_6101() || this.method_36601().method_27852(class_2246.field_27879) && class_5635.method_32355((class_1297)this))) {
                    adjustedMovement = new class_243(adjustedMovement.field_1352, -0.2, adjustedMovement.field_1350);
                }
                double adjustedYVelocity = adjustedMovement.field_1351;
                if (this.method_6059(class_1294.field_5902)) {
                    adjustedYVelocity += (0.05 * (double)(this.method_6112(class_1294.field_5902).method_5578() + 1) - adjustedMovement.field_1351) * 0.2;
                } else if (this.method_37908().field_9236 && !this.method_37908().method_22340(blockBelow)) {
                    adjustedYVelocity = this.method_23318() > (double)this.method_37908().method_31607() ? -0.1 : 0.0;
                } else if (!this.method_5740()) {
                    adjustedYVelocity -= upwardGravity;
                }
                if (this.method_35053()) {
                    this.method_18800(adjustedMovement.field_1352, adjustedYVelocity, adjustedMovement.field_1350);
                } else {
                    this.method_18800(adjustedMovement.field_1352 * (double)groundFriction, adjustedYVelocity * (double)0.98f, adjustedMovement.field_1350 * (double)groundFriction);
                }
            }
        }
    }

    private float getFrictionInfluencedSpeed(float $$0) {
        return this.onCieling() ? this.method_6029() * (0.21600002f / ($$0 * $$0 * $$0)) : this.method_49484();
    }

    protected class_2338 method_43258(float $$0) {
        if (this.field_44784.isPresent()) {
            class_2338 $$1 = (class_2338)this.field_44784.get();
            if (!($$0 > 1.0E-5f)) {
                return $$1;
            }
            class_2680 $$2 = this.method_37908().method_8320($$1);
            return !((double)$$0 <= 0.5 && $$2.method_26164(class_3481.field_16584) || $$2.method_26164(class_3481.field_15504) || $$2.method_26204() instanceof class_2349) ? $$1.method_33096(class_3532.method_15357((double)(this.method_19538().field_1351 + (double)$$0))) : $$1;
        }
        int $$3 = class_3532.method_15357((double)this.method_19538().field_1352);
        int $$4 = class_3532.method_15357((double)(this.method_19538().field_1351 + (double)$$0));
        int $$5 = class_3532.method_15357((double)this.method_19538().field_1350);
        return new class_2338($$3, $$4, $$5);
    }

    private class_3414 getFallDamageSound(int $$0) {
        return $$0 > 4 ? this.method_39760().comp_302() : this.method_39760().comp_301();
    }

    public boolean onCieling() {
        return this.field_5992 && !this.field_36331;
    }

    protected void method_5958() {
        if (this.isState(FairkeeperOurosState.AWAKENING)) {
            this.enableBossBar();
        }
        this.segmentControl();
        this.slitheringSoundControl();
        this.findCaller();
        this.performContactDamage();
        this.abilityCooldown();
        this.blockDestructionTick();
        super.method_5958();
        this.bossEvent.method_5408(this.method_6032() / this.method_6063());
    }

    private void slitheringSoundControl() {
        if (this.slitheringSoundTick-- <= 0) {
            this.playSlitheringSound();
            this.slitheringSoundTick = 140;
        }
    }

    private void findCaller() {
        if (this.fairkeeperSerpentCaller == null) {
            this.fairkeeperSerpentCaller = (FairkeeperSerpentCallerEntity)((class_3218)this.method_37908()).method_14190(this.getCallerId());
        }
    }

    private void performContactDamage() {
        this.method_37908().method_8333((class_1297)this, this.method_5829(), this::canPerformContactDamageTo).forEach(entity -> {
            entity.method_5697((class_1297)this);
            entity.method_5643(entity.method_37908().method_48963().method_48812((class_1309)this), (float)(this.method_26825(class_5134.field_23721) * 0.5));
        });
    }

    private boolean canPerformContactDamageTo(class_1297 entity) {
        if (entity instanceof FairkeeperOurosPartEntity) {
            FairkeeperOurosPartEntity part = (FairkeeperOurosPartEntity)entity;
            return !this.method_5667().equals(part.getHeadId());
        }
        return !(entity instanceof VertexOrbProjectileEntity) && !(entity instanceof VertexDomainProjectileEntity);
    }

    private void blockDestructionTick() {
        if (!this.canDestroyBlocks) {
            return;
        }
        int DESTRUCTION_RANGE = 4;
        if (this.method_18798().method_1027() > 0.01) {
            return;
        }
        if (this.destructionTick-- > 0) {
            return;
        }
        this.destructionTick = 2;
        this.destroyContactBlocks(-DESTRUCTION_RANGE, DESTRUCTION_RANGE, -1, 3, -DESTRUCTION_RANGE, DESTRUCTION_RANGE);
    }

    private void destroyContactBlocks(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        boolean blockBroken = false;
        for (int ix = minX; ix <= maxX; ++ix) {
            for (int iz = minZ; iz <= maxZ; ++iz) {
                for (int iy = minY; iy <= maxY; ++iy) {
                    int dx = this.method_31477() + ix;
                    int dy = this.method_31478() + iy;
                    int dz = this.method_31479() + iz;
                    class_2338 blockPos = new class_2338(dx, dy, dz);
                    class_2680 blockState = this.method_37908().method_8320(blockPos);
                    if (blockState.method_26215() || blockState.method_26164(class_3481.field_17754) || blockState.method_26164(DNLTags.TORCH_BLOCKS)) continue;
                    blockBroken = DNLLevelUtil.destroyBlockMulti(this.method_37908(), blockPos, false, (class_1297)this, 3);
                }
            }
        }
        if (blockBroken) {
            this.method_43077(class_3417.field_15026);
        }
    }

    private void abilityCooldown() {
        if (this.fairkeeperSerpentCaller == null) {
            return;
        }
        if (!this.isState(FairkeeperOurosState.IDLE)) {
            return;
        }
        if (this.attackTick > 0) {
            --this.attackTick;
            return;
        }
        if (this.getCaller() != null) {
            this.getCaller().setOurosWaitingForCommand(true);
        }
    }

    public void stopAttacking(int cooldown) {
        this.setState(FairkeeperOurosState.IDLE);
        this.setAttackTick(cooldown);
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        if (damageSource.method_5529() instanceof FairkeeperSerpentEntity) {
            class_1297 class_12972 = damageSource.method_5526();
            if (class_12972 instanceof class_1665) {
                class_1665 arrow = (class_1665)class_12972;
                arrow.method_5650(class_1297.class_5529.field_26999);
            }
            return false;
        }
        this.playHurtSound(this.method_23317(), this.method_23318(), this.method_23321());
        return this.hurtAndTrackAttackers(damageSource, amount);
    }

    private boolean hurtAndTrackAttackers(class_1282 source, float amount) {
        boolean result = super.method_5643(source, amount);
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1309) {
            class_1309 livingEntity = (class_1309)attacker;
            this.recordDamage(livingEntity, amount);
        }
        return result;
    }

    protected void method_6108() {
        ++this.field_6213;
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.field_6213 == 1) {
            this.playDeathAnimation();
            this.stopSlitheringSound();
            this.playDeathSound(this.method_23317(), this.method_23318(), this.method_23321());
            this.partIndex = 0;
            for (int i = 0; i <= 13; ++i) {
                FairkeeperOurosPartEntity part = this.getPart(i);
                if (part == null) continue;
                part.method_6033(0.0f);
            }
        }
        if (this.field_6213 % 10 == 0) {
            if (this.partIndex <= 13) {
                FairkeeperOurosPartEntity part = this.getPart(13 - this.partIndex);
                if (part != null) {
                    this.method_37908().method_8396(null, part.method_24515(), class_3417.field_15152, class_3419.field_15245, 4.0f, (1.0f + (this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11236, part.method_23317(), part.method_23318(), part.method_23321(), 1, 0.0, 0.0, 0.0, 1.0);
                    part.method_5650(class_1297.class_5529.field_26998);
                }
            } else if (!this.method_31481()) {
                FairkeeperSerpentCallerEntity caller = this.getCaller();
                if (caller != null) {
                    caller.defeatedOuros();
                }
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15152, class_3419.field_15245, 4.0f, (1.0f + (this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11236, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.0, 0.0, 0.0, 1.0);
                this.method_37908().method_8421((class_1297)this, (byte)60);
                this.method_5650(class_1297.class_5529.field_26998);
            }
            ++this.partIndex;
        }
    }

    private FairkeeperOurosPartEntity getPart(int index) {
        FairkeeperOurosPartEntity part = (FairkeeperOurosPartEntity)this.getChild();
        if (part == null) {
            return null;
        }
        for (int i = 0; i < index; ++i) {
            if ((part = (FairkeeperOurosPartEntity)part.getChild()) != null) continue;
            return null;
        }
        return part;
    }

    public void method_6078(class_1282 damageSource) {
        FairkeeperSerpentCallerEntity caller = this.getCaller();
        if (caller != null) {
            caller.setLastDamageSource(damageSource);
            caller.dyingOuros();
            if (caller.isBorosDefeated()) {
                caller.stopAllBossMusic();
            }
        }
        super.method_6078(damageSource);
    }

    public boolean method_6049(class_1293 mobEffectInstance) {
        class_1291 effect = mobEffectInstance.method_5579();
        if (effect == class_1294.field_5899 || effect == DNLMobEffects.VERTEX_TRANSMISSION.get()) {
            return false;
        }
        return super.method_6049(mobEffectInstance);
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (OUROS_ANIMATION_STATE.equals(entityDataAccessor)) {
            FairkeeperOurosAnimationState animationState = this.getAnimationState();
            this.resetAnimations();
            switch (animationState) {
                case IDLE: {
                    this.idleAnimationState.method_41324(this.field_6012);
                    break;
                }
                case MOUTH_OPEN: {
                    this.openMouthAnimationState.method_41324(this.field_6012);
                    break;
                }
                case MOUTH_OPENED: {
                    this.openedMouthAnimationState.method_41324(this.field_6012);
                    break;
                }
                case MOUTH_CLOSE: {
                    this.closeMouthAnimationState.method_41324(this.field_6012);
                }
            }
        }
        super.method_5674(entityDataAccessor);
    }

    private void resetAnimations() {
        this.idleAnimationState.method_41325();
        this.openMouthAnimationState.method_41325();
        this.openedMouthAnimationState.method_41325();
        this.closeMouthAnimationState.method_41325();
    }

    public FairkeeperOurosEntity transitionTo(FairkeeperOurosAnimationState state) {
        switch (state) {
            case IDLE: {
                this.setAnimationState(FairkeeperOurosAnimationState.IDLE);
                break;
            }
            case MOUTH_OPEN: {
                this.setAnimationState(FairkeeperOurosAnimationState.MOUTH_OPEN);
                break;
            }
            case MOUTH_OPENED: {
                this.setAnimationState(FairkeeperOurosAnimationState.MOUTH_OPENED);
                break;
            }
            case MOUTH_CLOSE: {
                this.setAnimationState(FairkeeperOurosAnimationState.MOUTH_CLOSE);
            }
        }
        return this;
    }

    public void playSlitheringSound() {
        float radius = 64.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        for (class_3222 player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.method_5628(), DNLSounds.FAIRKEEPER_OUROS_SLITHER.get().method_14833(), class_3419.field_15251, 4.0f, 1.0f, false, 64.0f, 0.0f), player);
        }
    }

    public void stopSlitheringSound() {
        float radius = 64.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        for (class_3222 player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(this.method_5628(), DNLSounds.FAIRKEEPER_OUROS_SLITHER.get().method_14833(), 20, false), player);
        }
    }

    public void playMouthOpenSound(double x, double y, double z) {
        this.method_37908().method_43128(null, x, y, z, DNLSounds.FAIRKEEPER_MOUTH_OPEN.get(), this.method_5634(), 4.0f, 1.0f);
    }

    public void playMouthCloseSound(double x, double y, double z) {
        this.method_37908().method_43128(null, x, y, z, DNLSounds.FAIRKEEPER_MOUTH_CLOSE.get(), this.method_5634(), 4.0f, 1.0f);
    }

    public void playVertexDomainShootSound(double x, double y, double z) {
        this.method_37908().method_43128(null, x, y, z, DNLSounds.FAIRKEEPER_OUROS_SHOOT_VERTEX_DOMAIN.get(), this.method_5634(), 4.0f, 1.0f);
    }

    public void playHurtSound(double x, double y, double z) {
        this.method_37908().method_43128(null, x, y, z, DNLSounds.FAIRKEEPER_OUROS_HURT.get(), this.method_5634(), 4.0f, 1.0f);
    }

    public void playDeathSound(double x, double y, double z) {
        this.method_37908().method_43128(null, x, y, z, DNLSounds.FAIRKEEPER_OUROS_DEATH.get(), this.method_5634(), 4.0f, 1.0f);
    }

    public boolean method_5757() {
        return false;
    }

    @Override
    public class_2338 resetRegionCenter() {
        return this.getCaller().method_24515();
    }

    @Override
    public boolean resetCondition() {
        return false;
    }

    @Override
    public void resetBoss() {
        this.method_5650(class_1297.class_5529.field_26999);
    }

    public boolean method_30949(class_1297 entity) {
        return !(entity instanceof VertexDomainProjectileEntity) && super.method_30949(entity);
    }

    public void method_5697(class_1297 entity) {
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected boolean method_5876() {
        return false;
    }

    protected void method_5623(double $$0, boolean $$1, class_2680 $$2, class_2338 $$3) {
    }

    protected int method_23329(float $$0, float $$1) {
        return 0;
    }

    public boolean method_5747(float v, float v1, class_1282 damageSource) {
        return false;
    }

    public class_1297 getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.method_37908().field_9236) {
            return ((class_3218)this.method_37908()).method_14190(id);
        }
        return null;
    }

    public FairkeeperSerpentCallerEntity getCaller() {
        return this.fairkeeperSerpentCaller;
    }

    @Override
    public class_2338 getArenaCenter() {
        FairkeeperSerpentCallerEntity entity = this.getCaller();
        if (entity != null) {
            return entity.method_24515();
        }
        return this.method_24515();
    }

    @Override
    public int getArenaSize() {
        FairkeeperSerpentCallerEntity entity = this.getCaller();
        if (entity != null) {
            return entity.getArenaSize();
        }
        return (int)this.getFollowDistance();
    }

    public void enableBossBar() {
        this.bossEvent.method_14091(true);
    }

    public void disableBossBar() {
        this.bossEvent.method_14091(false);
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    public void setAttackTick(int i) {
        this.attackTick = i;
    }

    public double getAttackDamage() {
        return this.method_26825(class_5134.field_23721);
    }

    public double getFollowDistance() {
        return this.method_26825(class_5134.field_23717);
    }

    public void setState(FairkeeperOurosState FairkeeperOurosState2) {
        this.field_6011.method_12778(STATE, (Object)FairkeeperOurosState2);
    }

    public FairkeeperOurosState getState() {
        return (FairkeeperOurosState)((Object)this.field_6011.method_12789(STATE));
    }

    public boolean isState(FairkeeperOurosState FairkeeperOurosState2) {
        return this.getState().equals((Object)FairkeeperOurosState2);
    }

    public UUID getChildId() {
        return ((Optional)this.field_6011.method_12789(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.field_6011.method_12778(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public UUID getCallerId() {
        return this.callerUUID;
    }

    public void setCallerId(@Nullable UUID uniqueId) {
        this.callerUUID = uniqueId;
    }

    public Queue<class_243> getPositionHistory() {
        return this.positionHistory;
    }

    public float getPreviousTilt() {
        return this.previousTilt;
    }

    public void setPreviousTilt(float tilt) {
        this.previousTilt = tilt;
    }

    public class_243 getAwakenEndPos() {
        return this.awakenEndPos;
    }

    public void setAwakenEndPos(class_243 blockPos) {
        this.awakenEndPos = blockPos;
    }

    public void setIsOnCeiling(boolean b) {
        this.field_6011.method_12778(IS_ON_CEILING, (Object)b);
    }

    public boolean isOnCeiling() {
        return (Boolean)this.field_6011.method_12789(IS_ON_CEILING);
    }

    @Override
    public boolean isStationary() {
        return false;
    }

    @Override
    public boolean isSlumbering() {
        return false;
    }

    public void setAnimationState(FairkeeperOurosAnimationState animationState) {
        this.field_6011.method_12778(OUROS_ANIMATION_STATE, (Object)animationState);
    }

    public FairkeeperOurosAnimationState getAnimationState() {
        return (FairkeeperOurosAnimationState)((Object)this.field_6011.method_12789(OUROS_ANIMATION_STATE));
    }

    public void setCanDestroyBlocks(boolean b) {
        this.canDestroyBlocks = b;
    }

    public boolean canDestroyBlocks() {
        return this.canDestroyBlocks;
    }

    @Override
    public Map<UUID, Double> getDamageMap() {
        return this.damageMap;
    }

    @Override
    public Map<UUID, class_1309> getAttackers() {
        return this.attackers;
    }

    @Override
    public Map<UUID, Double> getThreatScoreMap() {
        return this.threatScores;
    }

    public static enum FairkeeperOurosState {
        AWAKENING,
        IDLE,
        SUMMON_SCUTTLE,
        SUMMON_MORE_SCUTTLES,
        DROP_PILLAR_RANDOM,
        DROP_PILLAR_SMALL_SQUARE,
        DROP_PILLAR_LINE_CENTER,
        DROP_PILLAR_LINE_OUTER,
        DROP_PILLAR_CROSS,
        DROP_PILLAR_LINE_INNER,
        SHOOT_SINGLE_VERTEX_ORB,
        SHOOT_TRIPLE_VERTEX_ORB,
        SHOOT_VERTEX_DOMAIN,
        EXHAUSTED,
        DESPERATE,
        DYING;

    }

    public static enum FairkeeperOurosAnimationState {
        IDLE,
        MOUTH_OPEN,
        MOUTH_OPENED,
        MOUTH_CLOSE;

    }
}

