/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.boss;

import com.mojang.logging.LogUtils;
import dev.hexnowloading.dungeonnowloading.entity.ai.BossTargetSelectorGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosAwakenGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosCircleAndShootArrowGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosCircleAroundPlayerGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosEatVertexProjectilesGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosFlameThrowerGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosPursueAndShootArrowGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosShootArrowAboveGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosShootArrowGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosTackleGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosPartEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexDomainProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexOrbProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.AnimationChainer;
import dev.hexnowloading.dungeonnowloading.entity.util.Boss;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.SlumberingEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.WeightedTargetProvider;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStartTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStopTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLMobEffects;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import dev.hexnowloading.dungeonnowloading.util.DNLLevelUtil;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1665;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FairkeeperBorosEntity
extends class_1588
implements Boss,
class_1569,
SlumberingEntity,
FairkeeperSerpentEntity,
WeightedTargetProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2940<FairkeeperBorosState> STATE = class_2945.method_12791(FairkeeperBorosEntity.class, EntityStates.FAIRKEEPER_BOROS_STATE);
    private static final class_2940<FairkeeperBorosAnimationState> ANIMATION_STATE = class_2945.method_12791(FairkeeperBorosEntity.class, EntityStates.FAIRKEEPER_BOROS_ANIMATION_STATE);
    private static final class_2940<Optional<UUID>> CHILD_UUID = class_2945.method_12791(FairkeeperBorosEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> HAS_ARMOR = class_2945.method_12791(FairkeeperBorosEntity.class, (class_2941)class_2943.field_13323);
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 pursueOpenMouthAnimationState = new class_7094();
    public final class_7094 pursueOpenedMouthAnimationState = new class_7094();
    public final class_7094 pursueCloseMouthAnimationState = new class_7094();
    private final Deque<class_243> positionHistory = new LinkedList<class_243>();
    private Set<UUID> partList;
    private final Map<UUID, Double> damageMap = new HashMap<UUID, Double>();
    private final Map<UUID, class_1309> attackers = new HashMap<UUID, class_1309>();
    private final Map<UUID, Double> threatScores = new HashMap<UUID, Double>();
    private class_243 awakenEndPos;
    private FairkeeperSerpentCallerEntity fairkeeperSerpentCaller;
    private UUID callerUUID;
    private int attackTick;
    private int destructionTick;
    private int stuckTick;
    private int slitheringSoundTick;
    private int partIndex;
    private float previousTilt = 0.0f;
    private float armorHealth;
    private boolean targetRandomPlayer;
    private boolean damageFromOtherSegment;
    private boolean canDestroyBlocks;
    private boolean changeTarget;
    private class_1282 killedDamageSource;
    private AnimationChainer<FairkeeperBorosAnimationState> animationChainer = new AnimationChainer();
    private final class_3213 bossEvent;
    public static final int SEGMENT_COUNT = 14;
    public static int SEGMENT_DELAY_STEP = 13;
    private static final float MAX_ARMOR_HEALTH = 150.0f;
    public static final float SHOOT_ARROW_HEIGHT = 0.3f;
    private int mouthOpenAnimationTimeOut;
    private static final int MOUTH_OPEN_ANIMATION_DURATION = 19;
    private static final int STUCK_THRESHOLD = 100;
    private static final int SLITHERING_SOUND_INTERVAL = 140;

    public FairkeeperBorosEntity(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
        this.method_49477(1.0f);
        this.method_5971();
        this.setArmor(true);
        this.setArmorHealth(150.0f);
        this.field_6194 = 0;
        this.bossEvent = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5783, class_1259.class_1261.field_5795).method_5406(true);
    }

    public FairkeeperBorosEntity(class_1937 level, FairkeeperSerpentCallerEntity fairkeeperSerpentCaller) {
        this(DNLEntityTypes.FAIRKEEPER_BOROS.get(), level);
        this.fairkeeperSerpentCaller = fairkeeperSerpentCaller;
        this.callerUUID = this.fairkeeperSerpentCaller.method_5667();
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 500.0).method_26868(class_5134.field_23721, 20.0).method_26868(class_5134.field_23722, 1.5).method_26868(class_5134.field_23719, 0.4).method_26868(class_5134.field_23717, 30.0).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new FairkeeperBorosAwakenGoal(this));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosTackleGoal(FairkeeperBorosState.TACKLE_FAST, this, 1.5, 10.0, 0.7f));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosTackleGoal(FairkeeperBorosState.FLAME_TACKLE, this, 1.3, 6.0, 0.5));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosFlameThrowerGoal(FairkeeperBorosState.FLAME_TACKLE, this, 40));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosTackleGoal(FairkeeperBorosState.TACKLE, this, 1.3, 6.0, 0.5));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosShootArrowGoal(FairkeeperBorosState.SHOOT_ARROW_LINE, this, 1.5, FairkeeperBorosShootArrowGoal.PATTERN_LINE));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosShootArrowGoal(FairkeeperBorosState.SHOOT_ARROW_LINE_FAST, this, 1.7f, FairkeeperBorosShootArrowGoal.PATTERN_LINE_FAST));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosCircleAndShootArrowGoal(FairkeeperBorosState.SHOOT_ARROW_SMALL_CIRCLE, this, 1.7f, FairkeeperBorosCircleAndShootArrowGoal.PATTERN_SMALL_CIRLCE));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosCircleAndShootArrowGoal(FairkeeperBorosState.SHOOT_ARROW_LARGE_CIRCLE, this, 1.7f, FairkeeperBorosCircleAndShootArrowGoal.PATTERN_LARGE_CIRCLE));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosPursueAndShootArrowGoal(FairkeeperBorosState.PURSUE_AND_SHOOT_TRIPLE_ARROW, this, 1.3f, 3.0, 30, FairkeeperBorosPursueAndShootArrowGoal.PATTERN_TRIPLE));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosPursueAndShootArrowGoal(FairkeeperBorosState.PURSUE_AND_SHOOT_SINGLE_ARROW, this, 1.3f, 5.0, 30, FairkeeperBorosPursueAndShootArrowGoal.PATTERN_SINGLE));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosShootArrowAboveGoal(FairkeeperBorosState.SHOOT_ARROW_ABOVE, this, 1.5, FairkeeperBorosShootArrowAboveGoal.PATTERN_PLAYER_LARGE_CIRCLE));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosFlameThrowerGoal(FairkeeperBorosState.DESPERATE, this, 40));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosPursueAndShootArrowGoal(FairkeeperBorosState.DESPERATE, this, 1.5, 2.0, 30, FairkeeperBorosPursueAndShootArrowGoal.PATTERN_DESPERATE));
        this.field_6201.method_6277(3, (class_1352)new FairkeeperBorosEatVertexProjectilesGoal(FairkeeperBorosState.EAT_VERTEX_PROJECTILES, this, 1.5));
        this.field_6201.method_6277(4, (class_1352)new FairkeeperBorosCircleAroundPlayerGoal(FairkeeperBorosState.IDLE, this, 20.0, 1.5, true, true));
        this.field_6201.method_6277(5, (class_1352)new FairkeeperBorosCircleAroundPlayerGoal(FairkeeperBorosState.IDLE, this, 20.0, 1.5, true, false));
        this.field_6185.method_6277(2, (class_1352)new BossTargetSelectorGoal((class_1308)this));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CHILD_UUID, Optional.empty());
        this.field_6011.method_12784(STATE, (Object)FairkeeperBorosState.IDLE);
        this.field_6011.method_12784(ANIMATION_STATE, (Object)FairkeeperBorosAnimationState.IDLE);
        this.field_6011.method_12784(HAS_ARMOR, (Object)true);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        if (this.getChildId() != null) {
            compoundTag.method_25927("ChildUUID", this.getChildId());
        }
        if (this.getCallerId() != null) {
            compoundTag.method_25927("CallerUUID", this.getCallerId());
        }
        compoundTag.method_10556("CanDestroyBlocks", this.canDestroyBlocks);
        compoundTag.method_10556("Awakened", !this.isState(FairkeeperBorosState.AWAKENING));
        compoundTag.method_10556("Armor", this.hasArmor());
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (this.method_16914()) {
            this.bossEvent.method_5413(this.method_5476());
        }
        if (compoundTag.method_25928("ChildUUID")) {
            this.setChildId(compoundTag.method_25926("ChildUUID"));
        }
        if (compoundTag.method_25928("CallerUUID")) {
            this.setCallerId(compoundTag.method_25926("CallerUUID"));
        }
        this.setCanDestroyBlocks(compoundTag.method_10577("CanDestroyBlocks"));
        this.setState(compoundTag.method_10577("Awakened") ? FairkeeperBorosState.IDLE : FairkeeperBorosState.AWAKENING);
        this.setArmor(compoundTag.method_10577("Armor"));
    }

    public void method_5665(@Nullable class_2561 component) {
        super.method_5665(component);
        this.bossEvent.method_5413(this.method_5476());
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        this.bossEvent.method_14088(serverPlayer);
        if (this.isSlumbering()) {
            this.disableBossBar();
        }
    }

    public void method_5742(class_3222 serverPlayer) {
        super.method_5742(serverPlayer);
        this.bossEvent.method_14089(serverPlayer);
    }

    public void method_5773() {
        super.method_5773();
        this.animationControl();
    }

    private void animationControl() {
        if (this.method_37908().field_9236) {
            return;
        }
        this.animationChainer.tick(this::transitionTo);
    }

    public void playMouthOpenAndClose() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperBorosAnimationState.MOUTH_OPEN, 0.9167f, () -> this.playMouthOpenSound(this.method_23317(), this.method_23318(), this.method_23321()), null));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperBorosAnimationState.MOUTH_CLOSE, 0.7083f, () -> this.playMouthCloseSound(this.method_23317(), this.method_23318(), this.method_23321()), null));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.looping(FairkeeperBorosAnimationState.IDLE, 0.0f));
    }

    public void playMouthOpen() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperBorosAnimationState.MOUTH_OPEN, 0.9167f, () -> this.playMouthOpenSound(this.method_23317(), this.method_23318(), this.method_23321()), null));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.looping(FairkeeperBorosAnimationState.MOUTH_OPENED, 0.1667f));
    }

    public void playMouthOpenForShootingArrow() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperBorosAnimationState.MOUTH_OPEN, 1.75f, () -> this.playMouthOpenSound(this.method_23317(), this.method_23318(), this.method_23321()), () -> this.playArrowSound(this.method_23317(), this.method_23318(), this.method_23321(), 3.0f)));
    }

    public void playMouthClose() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperBorosAnimationState.MOUTH_CLOSE, 0.7083f, () -> this.playMouthCloseSound(this.method_23317(), this.method_23318(), this.method_23321()), null));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.looping(FairkeeperBorosAnimationState.IDLE, 0.0f));
    }

    private void playDeathAnimation() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.looping(FairkeeperBorosAnimationState.MOUTH_OPENED, 0.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void segmentControl() {
        if (!this.method_37908().field_9236) {
            int i;
            class_1297 child = this.getChild();
            if (this.positionHistory.isEmpty()) {
                class_243 currentPos = this.method_19538();
                int requiredHistorySize = 15 * SEGMENT_DELAY_STEP;
                for (i = 0; i < requiredHistorySize; ++i) {
                    this.positionHistory.addLast(currentPos);
                }
            }
            if (child == null && !this.method_29504()) {
                class_1588 partParent = this;
                int segments = 14;
                for (i = 0; i < segments; ++i) {
                    FairkeeperBorosPartEntity bodyPartParent;
                    FairkeeperBorosPartEntity part = new FairkeeperBorosPartEntity(DNLEntityTypes.FAIRKEEPER_BOROS_PART.get(), (class_1309)partParent, (class_1309)this, i);
                    if (partParent == this) {
                        this.setChildId(part.method_5667());
                    } else if (partParent instanceof FairkeeperBorosPartEntity && !(bodyPartParent = (FairkeeperBorosPartEntity)partParent).isTail()) {
                        bodyPartParent.setChild((class_1297)part);
                    }
                    part.method_5814(partParent.method_23317(), partParent.method_23318(), partParent.method_23321());
                    part.method_36456(partParent.method_36454());
                    part.field_6283 = partParent.method_36454();
                    part.field_6241 = partParent.method_36454();
                    part.setRotatable(false);
                    partParent = part;
                    if (i == segments - 1) {
                        part.setTail(true);
                    }
                    this.method_37908().method_8649((class_1297)part);
                }
            }
            if (this.method_18798().method_1027() > 0.01) {
                Deque<class_243> deque = this.positionHistory;
                synchronized (deque) {
                    this.positionHistory.addFirst(new class_243(this.method_23317(), this.method_23318(), this.method_23321()));
                    int maxHistorySize = 15 * SEGMENT_DELAY_STEP;
                    if (this.positionHistory.size() > maxHistorySize) {
                        this.positionHistory.pollLast();
                    }
                }
            }
            if (!this.method_24828() && this.method_18798().field_1351 < 0.0) {
                this.method_18799(this.method_18798().method_18805(1.0, 0.8, 1.0));
            }
            if (!this.isState(FairkeeperBorosState.AWAKENING)) {
                this.lookTowardTarget();
            }
        }
    }

    public class_243 getSegmentTargetPosition(int segmentIndex) {
        double segmentSpacing = 4.0;
        double targetDistance = (double)segmentIndex * segmentSpacing;
        ArrayList<class_243> history = new ArrayList<class_243>(this.positionHistory);
        if (history.size() < 2) {
            return this.method_19538();
        }
        class_243 current = (class_243)history.get(0);
        double accumulated = 0.0;
        for (int i = 1; i < history.size(); ++i) {
            class_243 next = (class_243)history.get(i);
            double dist = current.method_1022(next);
            if (accumulated + dist >= targetDistance) {
                double remaining = targetDistance - accumulated;
                double t = remaining / dist;
                return current.method_35590(next, t);
            }
            accumulated += dist;
            current = next;
        }
        return (class_243)history.get(history.size() - 1);
    }

    private void lookTowardTarget() {
        double directionX = this.method_5962().method_6236() - this.method_23317();
        double directionZ = this.method_5962().method_6237() - this.method_23321();
        double yaw = Math.toDegrees(Math.atan2(directionZ, directionX)) - 90.0;
        this.method_36456((float)yaw);
        this.field_6283 = (float)yaw;
    }

    protected void method_5958() {
        if (this.isState(FairkeeperBorosState.AWAKENING)) {
            this.enableBossBar();
        }
        this.segmentControl();
        this.slitheringSoundControl();
        this.findCaller();
        this.performContactDamage();
        this.abilityCooldown();
        this.stuckTracker();
        this.blockDestructionTick();
        super.method_5958();
        this.bossEvent.method_5408(this.method_6032() / this.method_6063());
    }

    private void slitheringSoundControl() {
        if (this.slitheringSoundTick-- <= 0) {
            this.playSlitheringSound();
            this.slitheringSoundTick = 140;
        }
    }

    private void findCaller() {
        if (this.fairkeeperSerpentCaller == null) {
            this.fairkeeperSerpentCaller = (FairkeeperSerpentCallerEntity)((class_3218)this.method_37908()).method_14190(this.getCallerId());
        }
    }

    private void stuckTracker() {
        boolean isStuck;
        class_243 motion = this.method_18798();
        boolean bl = isStuck = motion.method_1027() < 1.0E-6;
        if (isStuck) {
            ++this.stuckTick;
        }
        if (this.stuckTick > 0 && !isStuck) {
            this.stuckTick = 0;
        }
    }

    private void performContactDamage() {
        this.method_37908().method_8333((class_1297)this, this.method_5829(), this::canPerformContactDamageTo).forEach(entity -> {
            entity.method_5697((class_1297)this);
            entity.method_5643(entity.method_37908().method_48963().method_48812((class_1309)this), this.getContactDamage());
        });
    }

    private float getContactDamage() {
        return (float)(this.method_26825(class_5134.field_23721) * (double)(this.isState(FairkeeperBorosState.TACKLE) ? 1.5f : 0.5f));
    }

    private boolean canPerformContactDamageTo(class_1297 entity) {
        if (entity instanceof FairkeeperBorosPartEntity) {
            FairkeeperBorosPartEntity part = (FairkeeperBorosPartEntity)entity;
            return !this.method_5667().equals(part.getHeadId());
        }
        return !(entity instanceof VertexOrbProjectileEntity) && !(entity instanceof VertexDomainProjectileEntity);
    }

    private void blockDestructionTick() {
        if (!this.canDestroyBlocks) {
            return;
        }
        int DESTRUCTION_RANGE = 4;
        if (this.method_18798().method_1027() > 0.01) {
            return;
        }
        if (this.destructionTick-- > 0) {
            return;
        }
        this.destructionTick = 2;
        this.destroyContactBlocks(-DESTRUCTION_RANGE, DESTRUCTION_RANGE, 0, 4, -DESTRUCTION_RANGE, DESTRUCTION_RANGE);
    }

    private void destroyContactBlocks(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        boolean blockBroken = false;
        for (int ix = minX; ix <= maxX; ++ix) {
            for (int iz = minZ; iz <= maxZ; ++iz) {
                for (int iy = minY; iy <= maxY; ++iy) {
                    int dx = this.method_31477() + ix;
                    int dy = this.method_31478() + iy;
                    int dz = this.method_31479() + iz;
                    class_2338 blockPos = new class_2338(dx, dy, dz);
                    class_2680 blockState = this.method_37908().method_8320(blockPos);
                    if (blockState.method_26215() || blockState.method_26164(class_3481.field_17754) || blockState.method_26164(DNLTags.TORCH_BLOCKS)) continue;
                    blockBroken = DNLLevelUtil.destroyBlockMulti(this.method_37908(), blockPos, false, (class_1297)this, 3);
                }
            }
        }
        if (blockBroken) {
            this.method_43077(class_3417.field_15026);
        }
    }

    private void abilityCooldown() {
        if (this.fairkeeperSerpentCaller == null) {
            return;
        }
        if (!this.isState(FairkeeperBorosState.IDLE)) {
            return;
        }
        if (this.attackTick > 0) {
            --this.attackTick;
            return;
        }
        if (this.getCaller() != null) {
            this.getCaller().setBorosWaitingForCommand(true);
        }
    }

    public void stopAttacking(int cooldown) {
        this.setState(FairkeeperBorosState.IDLE);
        this.setAttackTick(cooldown);
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        class_1309 livingEntity;
        class_1297 class_12972;
        if (damageSource.method_5529() instanceof FairkeeperSerpentEntity) {
            class_1297 class_12973 = damageSource.method_5526();
            if (class_12973 instanceof class_1665) {
                class_1665 arrow = (class_1665)class_12973;
                arrow.method_5650(class_1297.class_5529.field_26999);
            }
            return false;
        }
        if (!this.isDamageFromOtherSegment() && this.hasArmor() && (this.getAnimationState().equals((Object)FairkeeperBorosAnimationState.MOUTH_OPEN) || this.getAnimationState().equals((Object)FairkeeperBorosAnimationState.MOUTH_OPENED) || this.getAnimationState().equals((Object)FairkeeperBorosAnimationState.MOUTH_CLOSE))) {
            this.playHurtSound(this.method_23317(), this.method_23318(), this.method_23321());
            return this.hurtAndTrackAttackers(damageSource, amount);
        }
        if (this.isDamageFromOtherSegment()) {
            this.setDamageFromOtherSegment(false);
            this.playHurtSound(this.method_23317(), this.method_23318(), this.method_23321());
            return this.hurtAndTrackAttackers(damageSource, amount);
        }
        if (!this.hasArmor() || damageSource.method_5530() || damageSource.method_48789(DNLTags.FAIRKEEPER_BOROS_BYPASS_ARMOR)) {
            this.playHurtSound(this.method_23317(), this.method_23318(), this.method_23321());
            return this.hurtAndTrackAttackers(damageSource, amount);
        }
        if (damageSource.method_48789(DNLTags.FAIRKEEPER_BOROS_ARMOR_HURTABLE) || (class_12972 = damageSource.method_5526()) instanceof class_1309 && (livingEntity = (class_1309)class_12972).method_42149() && amount > 6.0f) {
            float nonKillableDamage;
            boolean penetratesArmor = this.getArmorHealth() - amount <= 0.0f;
            float f = nonKillableDamage = penetratesArmor ? 0.0f : amount;
            if (penetratesArmor) {
                this.setArmor(false);
                class_1937 class_19372 = this.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    serverLevel.method_14199((class_2394)class_2398.field_11236, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15152, class_3419.field_15251, 1.0f, 1.0f);
                return this.hurtAndTrackAttackers(damageSource, 0.0f);
            }
            this.method_37908().method_8396(null, this.method_24515(), DNLSounds.FAIRKEEPER_BOROS_ARMOR_BREAK.get(), class_3419.field_15251, 1.0f, 1.0f);
            this.setArmorHealth(this.getArmorHealth() - nonKillableDamage);
            return this.hurtAndTrackAttackers(damageSource, 0.0f);
        }
        if (damageSource.method_49708(class_8111.field_42335) || damageSource.method_49708(class_8111.field_42337)) {
            return false;
        }
        this.method_37908().method_8396(null, this.method_24515(), DNLSounds.FAIRKEEPER_BOROS_ARMOR_HIT.get(), class_3419.field_15251, 1.0f, 1.0f);
        return false;
    }

    private boolean hurtAndTrackAttackers(class_1282 source, float amount) {
        boolean result = super.method_5643(source, amount);
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1309) {
            class_1309 livingEntity = (class_1309)attacker;
            this.recordDamage(livingEntity, amount);
        }
        return result;
    }

    protected void method_6108() {
        ++this.field_6213;
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.field_6213 == 1) {
            this.partIndex = 0;
            this.playDeathAnimation();
            this.stopSlitheringSound();
            this.playDeathSound(this.method_23317(), this.method_23318(), this.method_23321());
            this.stopFlameShootingSound();
            for (int i = 0; i <= 13; ++i) {
                FairkeeperBorosPartEntity part = this.getPart(i);
                if (part == null) continue;
                part.method_6033(0.0f);
            }
        }
        if (this.field_6213 % 10 == 0) {
            if (this.partIndex <= 13) {
                FairkeeperBorosPartEntity part = this.getPart(13 - this.partIndex);
                if (part != null) {
                    this.method_37908().method_8396(null, part.method_24515(), class_3417.field_15152, class_3419.field_15245, 4.0f, (1.0f + (this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11236, part.method_23317(), part.method_23318(), part.method_23321(), 1, 0.0, 0.0, 0.0, 1.0);
                    part.method_5650(class_1297.class_5529.field_26998);
                }
            } else {
                FairkeeperSerpentCallerEntity caller = this.getCaller();
                if (caller != null) {
                    caller.defeatedBoros();
                }
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15152, class_3419.field_15245, 4.0f, (1.0f + (this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11236, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.0, 0.0, 0.0, 1.0);
                this.method_37908().method_8421((class_1297)this, (byte)60);
                this.method_5650(class_1297.class_5529.field_26998);
            }
            ++this.partIndex;
        }
    }

    private FairkeeperBorosPartEntity getPart(int index) {
        FairkeeperBorosPartEntity part = (FairkeeperBorosPartEntity)this.getChild();
        if (part == null) {
            return null;
        }
        for (int i = 0; i < index; ++i) {
            if ((part = (FairkeeperBorosPartEntity)part.getChild()) != null) continue;
            return null;
        }
        return part;
    }

    public void method_6078(class_1282 damageSource) {
        FairkeeperSerpentCallerEntity caller = this.getCaller();
        if (caller != null) {
            caller.dyingBoros();
            caller.setLastDamageSource(damageSource);
            if (caller.isOurosDefeated()) {
                caller.stopAllBossMusic();
            }
        }
        super.method_6078(damageSource);
    }

    public boolean method_6049(class_1293 mobEffectInstance) {
        class_1291 effect = mobEffectInstance.method_5579();
        if (effect == class_1294.field_5899 || effect == DNLMobEffects.VERTEX_TRANSMISSION.get()) {
            return false;
        }
        return super.method_6049(mobEffectInstance);
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (ANIMATION_STATE.equals(entityDataAccessor)) {
            FairkeeperBorosAnimationState animationState = this.getAnimationState();
            this.resetAnimations();
            switch (animationState) {
                case IDLE: {
                    this.idleAnimationState.method_41324(this.field_6012);
                    break;
                }
                case MOUTH_OPEN: 
                case MOUTH_OPEN_WITHOUT_OPENED: {
                    this.pursueOpenMouthAnimationState.method_41324(this.field_6012);
                    break;
                }
                case MOUTH_OPENED: {
                    this.pursueOpenedMouthAnimationState.method_41324(this.field_6012);
                    break;
                }
                case MOUTH_CLOSE: {
                    this.pursueCloseMouthAnimationState.method_41324(this.field_6012);
                }
            }
        }
        super.method_5674(entityDataAccessor);
    }

    private void resetAnimations() {
        this.idleAnimationState.method_41325();
        this.pursueOpenMouthAnimationState.method_41325();
        this.pursueOpenedMouthAnimationState.method_41325();
        this.pursueCloseMouthAnimationState.method_41325();
    }

    public FairkeeperBorosEntity transitionTo(FairkeeperBorosAnimationState state) {
        switch (state) {
            case IDLE: {
                this.setAnimationState(FairkeeperBorosAnimationState.IDLE);
                break;
            }
            case MOUTH_OPEN: {
                this.setAnimationState(FairkeeperBorosAnimationState.MOUTH_OPEN);
                break;
            }
            case MOUTH_OPENED: {
                this.setAnimationState(FairkeeperBorosAnimationState.MOUTH_OPENED);
                break;
            }
            case MOUTH_CLOSE: {
                this.setAnimationState(FairkeeperBorosAnimationState.MOUTH_CLOSE);
                break;
            }
            case MOUTH_OPEN_WITHOUT_OPENED: {
                this.setAnimationState(FairkeeperBorosAnimationState.MOUTH_OPEN_WITHOUT_OPENED);
            }
        }
        return this;
    }

    @Override
    public class_2338 resetRegionCenter() {
        return this.getCaller().method_24515();
    }

    @Override
    public boolean resetCondition() {
        return false;
    }

    @Override
    public void resetBoss() {
        this.method_5650(class_1297.class_5529.field_26999);
    }

    public boolean method_30949(class_1297 entity) {
        return !(entity instanceof VertexDomainProjectileEntity) && super.method_30949(entity);
    }

    public void method_5697(class_1297 entity) {
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected boolean method_5876() {
        return false;
    }

    public boolean method_5757() {
        return false;
    }

    protected void method_5623(double $$0, boolean $$1, class_2680 $$2, class_2338 $$3) {
    }

    protected int method_23329(float $$0, float $$1) {
        return 0;
    }

    public boolean method_5747(float v, float v1, class_1282 damageSource) {
        return false;
    }

    public void playSlitheringSound() {
        float radius = 32.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        for (class_3222 player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.method_5628(), DNLSounds.FAIRKEEPER_BOROS_SLITHER.get().method_14833(), class_3419.field_15251, 3.0f, 1.0f, false, 16.0f, 0.0f), player);
        }
    }

    public void stopSlitheringSound() {
        float radius = 32.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        for (class_3222 player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(this.method_5628(), DNLSounds.FAIRKEEPER_BOROS_SLITHER.get().method_14833(), 20, false), player);
        }
    }

    public void playFlameShootingSound() {
        float radius = 32.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        for (class_3222 player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.method_5628(), DNLSounds.FAIRKEEPER_BOROS_FIRE_ATTACK.get().method_14833(), class_3419.field_15251, 3.0f, 1.0f, false, 32.0f, 0.0f), player);
        }
    }

    public void stopFlameShootingSound() {
        float radius = 32.0f;
        class_238 detectionBox = this.method_5829().method_1014((double)radius);
        List nearbyPlayers = this.method_37908().method_18467(class_3222.class, detectionBox);
        for (class_3222 player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(this.method_5628(), DNLSounds.FAIRKEEPER_BOROS_FIRE_ATTACK.get().method_14833(), 20, true), player);
        }
    }

    public void playMouthOpenSound(double x, double y, double z) {
        this.method_37908().method_43128(null, x, y, z, DNLSounds.FAIRKEEPER_MOUTH_OPEN.get(), this.method_5634(), 3.0f, 1.0f);
    }

    public void playMouthCloseSound(double x, double y, double z) {
        this.method_37908().method_43128(null, x, y, z, DNLSounds.FAIRKEEPER_MOUTH_CLOSE.get(), this.method_5634(), 3.0f, 1.0f);
    }

    public void playBeamSound(double x, double y, double z, float volume) {
        this.method_37908().method_43128(null, x, y, z, DNLSounds.FAIRKEEPER_BOROS_ARROW_WARNING.get(), this.method_5634(), volume, 1.0f);
    }

    public void playArrowSound(double x, double y, double z, float volume) {
        this.method_37908().method_43128(null, x, y, z, DNLSounds.FAIRKEEPER_BOROS_ARROW_SHOOT.get(), this.method_5634(), volume, 1.0f);
    }

    public void playHealSound(double x, double y, double z) {
        this.method_37908().method_43128(null, x, y, z, DNLSounds.FAIRKEEPER_BOROS_HEAL.get(), this.method_5634(), 3.0f, 1.0f);
    }

    public void playDeathSound(double x, double y, double z) {
        this.method_37908().method_43128(null, x, y, z, DNLSounds.FAIRKEEPER_BOROS_DEATH.get(), this.method_5634(), 3.0f, 1.0f);
    }

    public void playHurtSound(double x, double y, double z) {
        this.method_37908().method_43128(null, x, y, z, DNLSounds.FAIRKEEPER_BOROS_HURT.get(), this.method_5634(), 3.0f, 1.0f);
    }

    public class_1297 getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.method_37908().field_9236) {
            return ((class_3218)this.method_37908()).method_14190(id);
        }
        return null;
    }

    public FairkeeperSerpentCallerEntity getCaller() {
        return this.fairkeeperSerpentCaller;
    }

    @Override
    public class_2338 getArenaCenter() {
        FairkeeperSerpentCallerEntity entity = this.getCaller();
        return ((class_1297)Objects.requireNonNullElse(entity, this)).method_24515();
    }

    @Override
    public int getArenaSize() {
        FairkeeperSerpentCallerEntity entity = this.getCaller();
        if (entity != null) {
            return entity.getArenaSize();
        }
        return (int)this.getFollowDistance();
    }

    public boolean isStuck() {
        return this.method_18798().method_1027() < (double)0.01f;
    }

    public void enableBossBar() {
        this.bossEvent.method_14091(true);
    }

    public void disableBossBar() {
        this.bossEvent.method_14091(false);
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    public void setAttackTick(int i) {
        this.attackTick = i;
    }

    public double getAttackDamage() {
        return this.method_26825(class_5134.field_23721);
    }

    public double getFollowDistance() {
        return this.method_26825(class_5134.field_23717);
    }

    public void setState(FairkeeperBorosState fairkeeperState) {
        this.field_6011.method_12778(STATE, (Object)fairkeeperState);
    }

    public FairkeeperBorosState getState() {
        return (FairkeeperBorosState)((Object)this.field_6011.method_12789(STATE));
    }

    public void setAnimationState(FairkeeperBorosAnimationState animationState) {
        this.field_6011.method_12778(ANIMATION_STATE, (Object)animationState);
    }

    public FairkeeperBorosAnimationState getAnimationState() {
        return (FairkeeperBorosAnimationState)((Object)this.field_6011.method_12789(ANIMATION_STATE));
    }

    public boolean isState(FairkeeperBorosState fairkeeperState) {
        return this.getState().equals((Object)fairkeeperState);
    }

    public UUID getChildId() {
        return ((Optional)this.field_6011.method_12789(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.field_6011.method_12778(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public UUID getCallerId() {
        return this.callerUUID;
    }

    public void setCallerId(@Nullable UUID uniqueId) {
        this.callerUUID = uniqueId;
    }

    public Queue<class_243> getPositionHistory() {
        return this.positionHistory;
    }

    public float getPreviousTilt() {
        return this.previousTilt;
    }

    public void setPreviousTilt(float tilt) {
        this.previousTilt = tilt;
    }

    public class_243 getAwakenEndPos() {
        return this.awakenEndPos;
    }

    public void setAwakenEndPos(class_243 blockPos) {
        this.awakenEndPos = blockPos;
    }

    public boolean hasArmor() {
        return (Boolean)this.field_6011.method_12789(HAS_ARMOR);
    }

    public void setArmor(boolean b) {
        this.field_6011.method_12778(HAS_ARMOR, (Object)b);
    }

    public float getArmorHealth() {
        return this.armorHealth;
    }

    public void setArmorHealth(float f) {
        this.armorHealth = f;
    }

    public void setDamageFromOtherSegment(boolean b) {
        this.damageFromOtherSegment = b;
    }

    public boolean isDamageFromOtherSegment() {
        return this.damageFromOtherSegment;
    }

    public void setCanDestroyBlocks(boolean b) {
        this.canDestroyBlocks = b;
    }

    public boolean canDestroyBlocks() {
        return this.canDestroyBlocks;
    }

    @Override
    public boolean isStationary() {
        return false;
    }

    @Override
    public boolean isSlumbering() {
        return false;
    }

    @Override
    public Map<UUID, Double> getDamageMap() {
        return this.damageMap;
    }

    @Override
    public Map<UUID, class_1309> getAttackers() {
        return this.attackers;
    }

    @Override
    public Map<UUID, Double> getThreatScoreMap() {
        return this.threatScores;
    }

    public static enum FairkeeperBorosState {
        AWAKENING,
        IDLE,
        TACKLE,
        TACKLE_FAST,
        PURSUE_RANDOM,
        FLAME_TACKLE,
        SHOOT_ARROW_RANDOM,
        SHOOT_ARROW_LINE,
        SHOOT_ARROW_LINE_FAST,
        SHOOT_ARROW_SLITHER,
        SHOOT_ARROW_SMALL_CIRCLE,
        SHOOT_ARROW_LARGE_CIRCLE,
        SHOOT_ARROW_PLAYER_LARGE_CRICLE,
        PURSUE_AND_SHOOT_TRIPLE_ARROW,
        PURSUE_AND_SHOOT_SINGLE_ARROW,
        SHOOT_ARROW_ABOVE,
        EAT_VERTEX_PROJECTILES,
        EXHAUSTED,
        DESPERATE,
        DYING;

    }

    public static enum FairkeeperBorosAnimationState {
        IDLE,
        MOUTH_OPEN_WITHOUT_OPENED,
        MOUTH_OPEN,
        MOUTH_OPENED,
        MOUTH_CLOSE;

    }
}

