/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.monster.ScuttleEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.FlameProjectileEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_5134;

public class ScuttleFlameThrowerAttackGoal
extends class_1352 {
    private static final UUID FULL_KNOCKBACK_RESISTANCE_MODIFIER_UUID = UUID.fromString("2a6f22a4-5468-4eed-b100-fe77cdc8bd98");
    private final class_1322 FULL_KNOCKBACK_RESISTANCE = new class_1322(FULL_KNOCKBACK_RESISTANCE_MODIFIER_UUID, "Full knockback resistance", 0.5, class_1322.class_1323.field_6328);
    private final class_1322 CLOSED_ARMOR = new class_1322(UUID.randomUUID(), "Closed armor bonus", -1.0, class_1322.class_1323.field_6330);
    private final ScuttleEntity scuttleEntity;
    private int nextScanTick;
    private int attackTicks;

    public ScuttleFlameThrowerAttackGoal(ScuttleEntity scuttleEntity) {
        this.scuttleEntity = scuttleEntity;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    private int nextStartTick() {
        return ScuttleFlameThrowerAttackGoal.method_38848((int)10);
    }

    private int nextCooldownStartTick() {
        return ScuttleFlameThrowerAttackGoal.method_38848((int)(100 + this.scuttleEntity.method_6051().method_43048(100)));
    }

    public boolean method_6264() {
        if (this.nextScanTick > 0) {
            --this.nextScanTick;
            return false;
        }
        double DETECTION_RANGE = 5.0;
        boolean hasTargetInRange = this.scuttleEntity.method_5968() != null && this.scuttleEntity.method_47922(this.scuttleEntity.method_5968()) < DETECTION_RANGE * DETECTION_RANGE;
        this.nextScanTick = this.nextStartTick();
        return this.scuttleEntity.isState(ScuttleEntity.ScuttleState.CLOSED) && hasTargetInRange;
    }

    public boolean method_6266() {
        return this.scuttleEntity.isAttackingState();
    }

    public void method_6269() {
        class_1324 attributeInstance1;
        this.scuttleEntity.setState(ScuttleEntity.ScuttleState.OPENING);
        this.scuttleEntity.triggerMouthOpenAnimation();
        this.scuttleEntity.playShootingOpenSound();
        class_1324 attributeInstance = this.scuttleEntity.method_5996(class_5134.field_23718);
        if (attributeInstance != null) {
            attributeInstance.method_26835(this.FULL_KNOCKBACK_RESISTANCE);
        }
        if ((attributeInstance1 = this.scuttleEntity.method_5996(class_5134.field_23724)) != null) {
            attributeInstance1.method_26835(this.CLOSED_ARMOR);
        }
        this.attackTicks = 10;
    }

    public void method_6268() {
        if (this.attackTicks % 10 == 0) {
            class_238 aabb = new class_238(this.scuttleEntity.method_24515()).method_1014((double)1.2f);
            List targets = this.scuttleEntity.method_37908().method_18467(class_1657.class, aabb);
            for (class_1657 player : targets) {
                player.method_5639(5);
                this.scuttleEntity.method_6121((class_1297)player);
            }
        }
        if (this.attackTicks > 0) {
            --this.attackTicks;
        } else {
            switch (this.scuttleEntity.getState()) {
                case OPENING: {
                    this.scuttleEntity.setState(ScuttleEntity.ScuttleState.OPENED);
                    this.scuttleEntity.triggerIdleOpenedAnimation();
                    this.scuttleEntity.playShootingChargeSound();
                    this.attackTicks = 90;
                    break;
                }
                case OPENED: {
                    this.scuttleEntity.setState(ScuttleEntity.ScuttleState.CLOSING);
                    this.scuttleEntity.triggerMouthCloseAnimation();
                    this.attackTicks = 8;
                    break;
                }
                default: {
                    class_1324 attributeInstance1;
                    class_1324 attributeInstance = this.scuttleEntity.method_5996(class_5134.field_23718);
                    if (attributeInstance != null) {
                        attributeInstance.method_6202(this.FULL_KNOCKBACK_RESISTANCE);
                    }
                    if ((attributeInstance1 = this.scuttleEntity.method_5996(class_5134.field_23724)) != null) {
                        attributeInstance1.method_6202(this.CLOSED_ARMOR);
                    }
                    this.scuttleEntity.setState(ScuttleEntity.ScuttleState.CLOSED);
                    this.scuttleEntity.triggerIdleClosedAnimation();
                    this.nextScanTick = this.nextCooldownStartTick();
                }
            }
        }
        if (this.scuttleEntity.isState(ScuttleEntity.ScuttleState.CLOSING) && this.attackTicks == 7) {
            this.scuttleEntity.playShootingCloseSound();
        }
        if (this.scuttleEntity.isState(ScuttleEntity.ScuttleState.OPENED)) {
            if (this.attackTicks == 70) {
                this.scuttleEntity.playShootingBurstSound();
            }
            if (this.attackTicks == 40) {
                this.scuttleEntity.playShootingStopSound();
            }
            if (this.attackTicks > 20 && this.attackTicks < 70 && this.attackTicks % 2 == 0) {
                this.scuttleEntity.playShootingFlameSound();
                for (int i = 0; i < 4; ++i) {
                    float PROJECTILE_SPEED = 0.3f;
                    float DISTANCE = 1.0f;
                    float rotationRadian = (float)Math.PI / 180 * this.scuttleEntity.method_36454() + (float)(90 * i) + (float)((int)(180.0f * ((50.0f - (float)this.attackTicks) / 50.0f)));
                    FlameProjectileEntity flameProjectileEntity = new FlameProjectileEntity((class_1309)this.scuttleEntity, this.scuttleEntity.method_37908());
                    flameProjectileEntity.method_7432((class_1297)this.scuttleEntity);
                    flameProjectileEntity.method_24919((class_1297)this.scuttleEntity, 0.0f, this.scuttleEntity.method_36454() + (float)(90 * i) + (float)((int)(180.0f * ((50.0f - (float)this.attackTicks) / 50.0f))), 0.0f, PROJECTILE_SPEED, DISTANCE);
                    this.scuttleEntity.method_37908().method_8649((class_1297)flameProjectileEntity);
                }
            }
        }
    }
}

