/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import com.google.common.collect.ImmutableList;
import dev.hexnowloading.dungeonnowloading.entity.ai.StoppableGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosPartEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.BorusArrowEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.apache.commons.lang3.tuple.Triple;

public class FairkeeperBorosShootArrowAboveGoal
extends StoppableGoal {
    private final FairkeeperBorosEntity boros;
    private class_1297 circlingTarget;
    private final double radius;
    private final double speed;
    private final boolean clockwise;
    private final boolean circlePlayer;
    private double angle;
    private double travelledAngle;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int arenaSize;
    private class_2338 arenaCenter;
    private class_243 targetPos;
    private FairkeeperBorosEntity.FairkeeperBorosState state;
    private ShootingPattern pattern;
    private List<FairkeeperBorosPartEntity> partList = new ArrayList<FairkeeperBorosPartEntity>();
    private int stoppingTick;
    private int targetIndex = 0;
    private int playSoundForPart;
    private static final double THRESHOLD = 2.0;
    private static final int STOP_DURATION = 32;
    private static final int SHOOT_ARROW_TICK = 15;
    private static final int BEAM_TICK = 30;
    private static final float FULL_ARENA_SIZE = 49.0f;
    private static List<Integer> ODD_PARTS = List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(9), Integer.valueOf(11));
    private static List<Integer> EVEN_PARTS = List.of(Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(8), Integer.valueOf(10), Integer.valueOf(12));
    private static List<Integer> ALL_PARTS = List.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
    public static ShootingPattern PATTERN_SMALL_CIRLCE = new ShootingPattern(false, true, 0.2857143f, (ImmutableList<Triple<ShootingType, List<Integer>, Float>>)ImmutableList.of((Object)Triple.of((Object)((Object)ShootingType.RIGHT), ODD_PARTS, (Object)Float.valueOf(360.0f)), (Object)Triple.of((Object)((Object)ShootingType.RIGHT), EVEN_PARTS, (Object)Float.valueOf(360.0f)), (Object)Triple.of((Object)((Object)ShootingType.RIGHT), ODD_PARTS, (Object)Float.valueOf(360.0f))));
    public static ShootingPattern PATTERN_LARGE_CIRCLE = new ShootingPattern(false, true, 0.59183675f, (ImmutableList<Triple<ShootingType, List<Integer>, Float>>)ImmutableList.of((Object)Triple.of((Object)((Object)ShootingType.LEFT), ODD_PARTS, (Object)Float.valueOf(120.0f)), (Object)Triple.of((Object)((Object)ShootingType.LEFT), EVEN_PARTS, (Object)Float.valueOf(240.0f)), (Object)Triple.of((Object)((Object)ShootingType.LEFT), ODD_PARTS, (Object)Float.valueOf(360.0f))));
    public static ShootingPattern PATTERN_PLAYER_LARGE_CIRCLE = new ShootingPattern(false, true, 0.59183675f, (ImmutableList<Triple<ShootingType, List<Integer>, Float>>)ImmutableList.of((Object)Triple.of((Object)((Object)ShootingType.LEFT), ODD_PARTS, (Object)Float.valueOf(120.0f)), (Object)Triple.of((Object)((Object)ShootingType.LEFT), EVEN_PARTS, (Object)Float.valueOf(240.0f)), (Object)Triple.of((Object)((Object)ShootingType.LEFT), ODD_PARTS, (Object)Float.valueOf(360.0f))));

    public FairkeeperBorosShootArrowAboveGoal(FairkeeperBorosEntity.FairkeeperBorosState state, FairkeeperBorosEntity boros, double speed, ShootingPattern pattern) {
        this.state = state;
        this.boros = boros;
        this.radius = pattern.ratio * 49.0f / 2.0f;
        this.speed = speed;
        this.clockwise = pattern.rotateClockWise;
        this.circlePlayer = pattern.circlePlayer;
        this.pattern = pattern;
        this.angle = 0.0;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        boolean b;
        if (this.circlePlayer) {
            this.circlingTarget = this.boros.method_5968();
            b = this.circlingTarget != null && this.circlingTarget.method_5805();
        } else {
            this.circlingTarget = this.boros.getCaller();
            b = this.circlingTarget != null;
        }
        return b && this.boros.isState(this.state);
    }

    @Override
    public void method_6269() {
        FairkeeperBorosPartEntity currentPart;
        super.method_6269();
        FairkeeperSerpentCallerEntity caller = this.boros.getCaller();
        if (caller != null) {
            this.arenaSize = caller.getArenaSize();
            class_2338 callerPos = caller.method_24515();
            this.arenaCenter = new class_2338(callerPos.method_10263(), (int)this.boros.method_23318(), callerPos.method_10260());
        }
        if ((currentPart = (FairkeeperBorosPartEntity)this.boros.getChild()) == null) {
            this.stopGoal();
            return;
        }
        this.partList.add(currentPart);
        for (int i = 0; i < 12; ++i) {
            if ((currentPart = (FairkeeperBorosPartEntity)currentPart.getChild()) == null) {
                this.stopGoal();
                return;
            }
            this.partList.add(currentPart);
        }
        if (this.circlingTarget == null) {
            this.stopGoal();
            return;
        }
        double centerX = this.circlePlayer ? this.circlingTarget.method_23317() : (double)this.arenaCenter.method_10263();
        double centerZ = this.circlePlayer ? this.circlingTarget.method_23321() : (double)this.arenaCenter.method_10260();
        double deltaX = this.boros.method_23317() - centerX;
        double deltaZ = this.boros.method_23321() - centerZ;
        this.angle = Math.toDegrees(Math.atan2(deltaZ, deltaX));
        this.angle = (this.angle + 360.0) % 360.0;
        this.travelledAngle = 0.0;
        this.targetIndex = 0;
        this.stoppingTick = 0;
        this.updateTargetPosition();
    }

    public void method_6270() {
        this.boros.stopAttacking(20);
    }

    public void method_6268() {
        if (this.stoppingTick > 0) {
            --this.stoppingTick;
            if (this.stoppingTick == FairkeeperBorosShootArrowAboveGoal.method_38848((int)30)) {
                this.playSoundForPart = 0;
                ((List)((Triple)this.pattern.positionList().get(this.targetIndex)).getMiddle()).stream().forEach(partIndex -> {
                    ShootingType shootingType = (ShootingType)((Object)((Object)((Triple)this.pattern.positionList().get(this.targetIndex)).getLeft()));
                    FairkeeperBorosPartEntity part = this.partList.get((int)partIndex);
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.LEFT) {
                        this.spawnRedstoneTrail(part, 0.0, 0.0, 0.0, 30.0, 30);
                    }
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.RIGHT) {
                        this.spawnRedstoneTrail(part, 0.0, 3.0, 0.0, 30.0, 30);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_LEFT) {
                        this.spawnRedstoneTrail(part, 0.0, 3.0, 0.0, 30.0, 30);
                        this.spawnRedstoneTrail(part, 0.0, 3.0, 0.0, 30.0, 30);
                        this.spawnRedstoneTrail(part, 0.0, 3.0, 0.0, 30.0, 30);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_RIGHT) {
                        this.spawnRedstoneTrail(part, 0.0, 3.0, 0.0, 30.0, 30);
                        this.spawnRedstoneTrail(part, 0.0, 3.0, 0.0, 30.0, 30);
                        this.spawnRedstoneTrail(part, 0.0, 3.0, 0.0, 30.0, 30);
                    }
                    if (this.playSoundForPart % 3 == 0) {
                        this.boros.playBeamSound(part.method_23317(), part.method_23318(), part.method_23321(), 3.0f);
                    }
                    ++this.playSoundForPart;
                });
            }
            if (this.stoppingTick == FairkeeperBorosShootArrowAboveGoal.method_38848((int)15)) {
                this.playSoundForPart = 0;
                ((List)((Triple)this.pattern.positionList().get(this.targetIndex)).getMiddle()).stream().forEach(partIndex -> {
                    ShootingType shootingType = (ShootingType)((Object)((Object)((Triple)this.pattern.positionList().get(this.targetIndex)).getLeft()));
                    FairkeeperBorosPartEntity part = this.partList.get((int)partIndex);
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.LEFT) {
                        this.shootArrow(part, 0.0, 0.0, 0.0);
                    }
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.RIGHT) {
                        this.shootArrow(part, 0.0, 3.0, 0.0);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_LEFT) {
                        this.shootArrow(part, 0.0, 3.0, 0.0);
                        this.shootArrow(part, 0.0, 3.0, 0.0);
                        this.shootArrow(part, 0.0, 3.0, 0.0);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_RIGHT) {
                        this.shootArrow(part, 0.0, 3.0, 0.0);
                        this.shootArrow(part, 0.0, 3.0, 0.0);
                        this.shootArrow(part, 0.0, 3.0, 0.0);
                    }
                    if (this.playSoundForPart % 3 == 0) {
                        this.boros.playArrowSound(part.method_23317(), part.method_23318(), part.method_23321(), 3.0f);
                    }
                    ++this.playSoundForPart;
                });
            }
            if (this.stoppingTick <= 0) {
                ++this.targetIndex;
                if (this.targetIndex >= this.pattern.positionList().size()) {
                    this.stopGoal();
                    return;
                }
                double difference = ((Float)((Triple)this.pattern.positionList.get(this.targetIndex)).getRight()).floatValue() - ((Float)((Triple)this.pattern.positionList.get(this.targetIndex - 1)).getRight()).floatValue();
                if (difference * difference < 1.0E-7) {
                    this.stoppingTick = FairkeeperBorosShootArrowAboveGoal.method_38848((int)32);
                    return;
                }
            } else {
                return;
            }
        }
        if (this.circlingTarget != null) {
            double deltaZ;
            double deltaX = this.boros.method_23317() - this.targetX;
            if (deltaX * deltaX + (deltaZ = this.boros.method_23321() - this.targetZ) * deltaZ < 4.0) {
                this.angle += this.clockwise ? -10.0 : 10.0;
                this.angle = (this.angle + 360.0) % 360.0;
                this.travelledAngle += this.clockwise ? -10.0 : 10.0;
                if (this.hasCompletedRevolution()) {
                    this.stoppingTick = FairkeeperBorosShootArrowAboveGoal.method_38848((int)32);
                    return;
                }
                this.updateTargetPosition();
            }
            this.boros.method_5962().method_6239(this.targetX, this.targetY, this.targetZ, this.speed);
        }
    }

    private void updateTargetPosition() {
        double angleRad = Math.toRadians(this.angle);
        double centerX = this.circlePlayer ? this.circlingTarget.method_23317() : (double)this.arenaCenter.method_10263();
        double centerZ = this.circlePlayer ? this.circlingTarget.method_23321() : (double)this.arenaCenter.method_10260();
        double potentialX = centerX + this.radius * Math.cos(angleRad);
        double potentialZ = centerZ + this.radius * Math.sin(angleRad);
        double minX = this.arenaCenter.method_10263() - this.arenaSize + 1;
        double maxX = this.arenaCenter.method_10263() + this.arenaSize - 1;
        double minZ = this.arenaCenter.method_10260() - this.arenaSize + 1;
        double maxZ = this.arenaCenter.method_10260() + this.arenaSize - 1;
        this.targetX = Math.max(minX, Math.min(maxX, potentialX));
        this.targetZ = Math.max(minZ, Math.min(maxZ, potentialZ));
        this.targetY = this.boros.method_23318();
    }

    private boolean hasCompletedRevolution() {
        return Math.abs(this.travelledAngle) >= (double)((Float)((Triple)this.pattern.positionList().get(this.targetIndex)).getRight()).floatValue();
    }

    private void shootArrow(FairkeeperBorosPartEntity partEntity, double rxOffset, double ryOffset, double rzOffset) {
        class_243 startPos = new class_243(partEntity.method_23317() + rxOffset, partEntity.method_23318() + ryOffset + partEntity.method_5829().method_17940() * (double)0.3f, partEntity.method_23321() + rzOffset);
        class_243 direction = this.targetPos.method_1020(startPos).method_1029();
        BorusArrowEntity arrow = new BorusArrowEntity((class_1309)this.boros, this.boros.method_37908());
        arrow.method_33574(startPos);
        arrow.method_7485(direction.field_1352, direction.field_1351, direction.field_1350, 2.0f, 0.0f);
        this.boros.method_37908().method_8649((class_1297)arrow);
    }

    private void spawnRedstoneTrail(FairkeeperBorosPartEntity partEntity, double rxOffset, double ryOffset, double rzOffset, double beamLength, int particleCount) {
        class_1309 target = this.boros.method_5968();
        if (target == null) {
            return;
        }
        class_243 startPos = new class_243(partEntity.method_23317() + rxOffset, partEntity.method_23318() + ryOffset + partEntity.method_5829().method_17940() * (double)0.3f, partEntity.method_23321() + rzOffset);
        this.targetPos = target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0);
        class_243 direction = this.targetPos.method_1020(startPos).method_1029();
        double stepSize = beamLength / (double)particleCount;
        for (int i = 0; i < particleCount; ++i) {
            class_243 particlePos = startPos.method_1019(direction.method_1021((double)i * stepSize));
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.ARROW_HAZARD_INDICATOR.get(), 0.5f);
            ((class_3218)partEntity.method_37908()).method_14199((class_2394)particleData, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private record ShootingPattern(boolean circlePlayer, boolean rotateClockWise, float ratio, ImmutableList<Triple<ShootingType, List<Integer>, Float>> positionList) {
    }

    private static enum ShootingType {
        NONE,
        LEFT,
        RIGHT,
        BOTH,
        TRIPLE_LEFT,
        TRIPLE_RIGHT,
        TRIPLE_BOTH;

    }
}

