/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import com.google.common.collect.ImmutableList;
import dev.hexnowloading.dungeonnowloading.entity.ai.StoppableGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.BorusArrowEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class FairkeeperBorosPursueAndShootArrowGoal
extends StoppableGoal {
    private final FairkeeperBorosEntity boros;
    private final FairkeeperBorosEntity.FairkeeperBorosState state;
    private final ShootingPattern pattern;
    private final double speed;
    private class_1309 target;
    private class_243 targetPosition;
    private final double shootingRange;
    private int stoppingTick;
    private int maxShootingCooldown;
    private int shootingCooldown;
    private int targetIndex;
    private int totalDuration;
    private static final int EXPIRY_DURATION = 300;
    private static final int STOP_DURATION = 42;
    private static final int BEAM_TICK = 40;
    private static final int SHOOT_ARROW_TICK = 25;
    private static final int CLOSE_MOUTH_TICK = 18;
    private static final int DEFAULT_SHOOTING_COOLDOWN = 60;
    private static final float ADDED_SPEED = 0.2f;
    public static final ShootingPattern PATTERN_SINGLE = new ShootingPattern((ImmutableList<ImmutableList<Float>>)ImmutableList.of((Object)ImmutableList.of((Object)Float.valueOf(0.0f)), (Object)ImmutableList.of((Object)Float.valueOf(0.0f)), (Object)ImmutableList.of((Object)Float.valueOf(0.0f))));
    public static final ShootingPattern PATTERN_DOUBLE = new ShootingPattern((ImmutableList<ImmutableList<Float>>)ImmutableList.of((Object)ImmutableList.of((Object)Float.valueOf(10.0f), (Object)Float.valueOf(-10.0f)), (Object)ImmutableList.of((Object)Float.valueOf(10.0f), (Object)Float.valueOf(-10.0f)), (Object)ImmutableList.of((Object)Float.valueOf(10.0f), (Object)Float.valueOf(-10.0f))));
    public static final ShootingPattern PATTERN_TRIPLE = new ShootingPattern((ImmutableList<ImmutableList<Float>>)ImmutableList.of((Object)ImmutableList.of((Object)Float.valueOf(15.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(-15.0f)), (Object)ImmutableList.of((Object)Float.valueOf(15.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(-15.0f)), (Object)ImmutableList.of((Object)Float.valueOf(15.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(-15.0f))));
    public static final ShootingPattern PATTERN_DESPERATE = new ShootingPattern((ImmutableList<ImmutableList<Float>>)ImmutableList.of((Object)ImmutableList.of((Object)Float.valueOf(25.0f), (Object)Float.valueOf(15.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(-15.0f), (Object)Float.valueOf(-25.0f)), (Object)ImmutableList.of((Object)Float.valueOf(30.0f), (Object)Float.valueOf(10.0f), (Object)Float.valueOf(-10.0f), (Object)Float.valueOf(-30.0f)), (Object)ImmutableList.of((Object)Float.valueOf(25.0f), (Object)Float.valueOf(15.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(-15.0f), (Object)Float.valueOf(-25.0f)), (Object)ImmutableList.of((Object)Float.valueOf(30.0f), (Object)Float.valueOf(10.0f), (Object)Float.valueOf(-10.0f), (Object)Float.valueOf(-30.0f)), (Object)ImmutableList.of((Object)Float.valueOf(30.0f), (Object)Float.valueOf(20.0f), (Object)Float.valueOf(10.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(-10.0f), (Object)Float.valueOf(-50.0f))));

    public FairkeeperBorosPursueAndShootArrowGoal(FairkeeperBorosEntity.FairkeeperBorosState state, FairkeeperBorosEntity boros, double speed, double shootingRange, int shootingCooldown, ShootingPattern pattern) {
        this.state = state;
        this.boros = boros;
        this.speed = speed;
        this.shootingRange = shootingRange;
        this.maxShootingCooldown = shootingCooldown;
        this.pattern = pattern;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        this.target = this.boros.method_5968();
        return this.target != null && this.target.method_5805() && this.boros.isState(this.state);
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.targetPosition = this.target.method_30950(1.0f);
        this.targetIndex = 0;
        this.shootingCooldown = this.maxShootingCooldown;
        this.totalDuration = FairkeeperBorosPursueAndShootArrowGoal.method_38848((int)300);
    }

    public void method_6270() {
        this.boros.stopAttacking(20);
    }

    public void method_6268() {
        if (this.stoppingTick > 0) {
            --this.stoppingTick;
            if (this.stoppingTick == FairkeeperBorosPursueAndShootArrowGoal.method_38848((int)40)) {
                ((ImmutableList)this.pattern.arrowPattern.get(this.targetIndex)).stream().forEach(angle -> this.spawnRedstoneTrail(this.boros, angle.floatValue(), 0.0, 0.0));
                this.boros.playBeamSound(this.boros.method_23317(), this.boros.method_23318(), this.boros.method_23321(), 3.0f);
                this.boros.playMouthOpenSound(this.boros.method_23317(), this.boros.method_23318(), this.boros.method_23321());
                this.boros.playMouthOpenForShootingArrow();
                this.boros.transitionTo(FairkeeperBorosEntity.FairkeeperBorosAnimationState.MOUTH_OPEN_WITHOUT_OPENED);
            }
            if (this.stoppingTick == FairkeeperBorosPursueAndShootArrowGoal.method_38848((int)25)) {
                ((ImmutableList)this.pattern.arrowPattern.get(this.targetIndex)).stream().forEach(angle -> this.shootArrow(this.boros, angle.floatValue(), 0.0, 0.0));
                this.boros.playArrowSound(this.boros.method_23317(), this.boros.method_23318(), this.boros.method_23321(), 3.0f);
            }
            if (this.stoppingTick == FairkeeperBorosPursueAndShootArrowGoal.method_38848((int)18)) {
                this.boros.playMouthClose();
            }
            if (this.stoppingTick <= 0) {
                ++this.targetIndex;
                if (this.targetIndex >= this.pattern.arrowPattern.size()) {
                    this.stopGoal();
                    return;
                }
                this.shootingCooldown = this.maxShootingCooldown;
            } else {
                return;
            }
        }
        if (this.totalDuration > 0) {
            --this.totalDuration;
        } else {
            this.stopGoal();
            return;
        }
        double updatedSpeed = this.speed;
        double distanceSqr = this.boros.method_5858((class_1297)this.target);
        this.targetPosition = this.target.method_30950(1.0f);
        if (this.shootingCooldown <= 0) {
            this.stoppingTick = FairkeeperBorosPursueAndShootArrowGoal.method_38848((int)42);
            return;
        }
        --this.shootingCooldown;
        if (distanceSqr < this.shootingRange * this.shootingRange) {
            updatedSpeed = this.speed + (double)0.2f;
        }
        this.boros.method_5962().method_6239(this.targetPosition.field_1352, this.targetPosition.field_1351, this.targetPosition.field_1350, updatedSpeed);
    }

    private void shootArrow(FairkeeperBorosEntity partEntity, float angleOffset, double rxOffset, double rzOffset) {
        double viewDistance = 2.0;
        float borosFacingYaw = partEntity.method_36454();
        double finalAngle = Math.toRadians(borosFacingYaw - angleOffset);
        double cosFinal = Math.cos(finalAngle);
        double sinFinal = Math.sin(finalAngle);
        class_243 shootDirection = new class_243(-sinFinal, 0.0, cosFinal).method_1029();
        double rotatedRxOffset = rxOffset * cosFinal - rzOffset * sinFinal;
        double rotatedRzOffset = rxOffset * sinFinal + rzOffset * cosFinal;
        class_243 startPos = new class_243(partEntity.method_23317() + rotatedRxOffset, partEntity.method_23318() + partEntity.method_5829().method_17940() * (double)0.3f, partEntity.method_23321() + rotatedRzOffset);
        class_243 arrowPos = startPos.method_1019(shootDirection.method_1021(viewDistance));
        BorusArrowEntity arrow = new BorusArrowEntity((class_1309)this.boros, this.boros.method_37908());
        arrow.method_33574(arrowPos);
        arrow.method_24919((class_1297)partEntity, partEntity.method_36455(), borosFacingYaw - angleOffset, 0.0f, 2.0f, 1.0f);
        this.boros.method_37908().method_8649((class_1297)arrow);
    }

    private void spawnRedstoneTrail(FairkeeperBorosEntity partEntity, float angleOffset, double rxOffset, double rzOffset) {
        double viewDistance = 2.0;
        float borosFacingYaw = partEntity.method_36454();
        double finalAngle = Math.toRadians(borosFacingYaw - angleOffset);
        double cosFinal = Math.cos(finalAngle);
        double sinFinal = Math.sin(finalAngle);
        class_243 beamDirection = new class_243(-sinFinal, 0.0, cosFinal).method_1029();
        double rotatedRxOffset = rxOffset * cosFinal - rzOffset * sinFinal;
        double rotatedRzOffset = rxOffset * sinFinal + rzOffset * cosFinal;
        class_243 startPos = new class_243(partEntity.method_23317() + rotatedRxOffset, partEntity.method_23318() + partEntity.method_5829().method_17940() * (double)0.3f, partEntity.method_23321() + rotatedRzOffset).method_1019(beamDirection.method_1021(viewDistance));
        for (int i = 0; i <= 30; ++i) {
            class_243 particlePos = startPos.method_1019(beamDirection.method_1021((double)i));
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.ARROW_HAZARD_INDICATOR.get(), 0.5f);
            ((class_3218)partEntity.method_37908()).method_14199((class_2394)particleData, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public record ShootingPattern(ImmutableList<ImmutableList<Float>> arrowPattern) {
    }
}

