/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.components;

import dev.hexnowloading.dungeonnowloading.components.VertexNodeConnectionContext;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexArrowProjectileEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.potion.VertexTransmissionEffect;
import dev.hexnowloading.dungeonnowloading.registry.DNLMobEffects;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.util.DNLMath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3419;

public class VertexNode {
    private List<VertexNodeConnectionContext> connectedNodes = new ArrayList<VertexNodeConnectionContext>();
    private class_1297 entityRef;
    private boolean attemptedConnection = false;
    private static final double BEAM_PARTICLE_SPACING = 0.1;
    private static final double BEAM_INITIAL_PARTICLE_SPACING = 0.8;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MIN = 0.2f;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MAX = 0.4f;
    private static final float BEAM_PARTICLE_SCALE = 0.05f;
    private static final double BEAM_PLAYER_EYE_LEVEL_OFFSET = -0.5;
    private static final float MAX_RANDOM_PARTICLE_SCALE_MULTIPLIER = 3.0f;
    private static final int MAX_CONNECTION_COUNT = 2;
    private static final double MAX_CONNECTION_RADIUS = 10.0;
    private static final double BEAM_HITBOX_RADIUS = 0.5;
    private static final int ENTITY_EFFECT_DURATION_TICKS = 60;

    public VertexNode(class_1297 entityRef) {
        this.entityRef = entityRef;
    }

    public int getConnectionCount() {
        return this.connectedNodes.size();
    }

    public boolean attemptedConnection() {
        return this.attemptedConnection;
    }

    public boolean connectionLimitReached() {
        return this.getConnectionCount() >= 2;
    }

    public void disconnect_all() {
        for (VertexNodeConnectionContext connectedNodeCtx : this.connectedNodes) {
            connectedNodeCtx.getVertexNode().disconnectNode(this);
        }
        this.connectedNodes.clear();
        this.attemptedConnection = false;
    }

    public void disconnectNode(VertexNode node) {
        this.connectedNodes.removeIf(nodeConnectionCtx -> nodeConnectionCtx.getVertexNode() == node);
    }

    public void connectNode(VertexNode node, boolean isBeamParent) {
        this.connectedNodes.add(new VertexNodeConnectionContext(node, isBeamParent));
        this.entityRef.method_37908().method_43128(null, this.entityRef.method_23317(), this.entityRef.method_23318(), this.entityRef.method_23321(), DNLSounds.VERTEX_NODE_CONNECT.get(), class_3419.field_15254, 0.5f, 1.2f / (DNLMath.randomRange(0.0f, 1.0f) * 0.2f + 0.9f));
    }

    public void connectToNearbyNodes(class_1297 sourceEntity) {
        this.connectToNearbyNodes(sourceEntity, false);
    }

    public void connectToNearbyNodes(class_1297 sourceEntity, boolean isReconnectionCase) {
        List<VertexNode> nearbyNodes = this.getNearbyNodes(sourceEntity);
        for (VertexNode node : nearbyNodes) {
            this.connectNode(node, true);
            node.connectNode(this, false);
            if (isReconnectionCase) continue;
            this.spawnInitialParticleBeamVFX(sourceEntity.method_37908(), this.getEyeLevelPositionAdjusted(sourceEntity), this.getEyeLevelPositionAdjusted(node.entityRef));
        }
        this.attemptedConnection = true;
    }

    public void tick(class_1297 entity) {
        boolean isClientSide = entity.method_37908().field_9236;
        for (VertexNodeConnectionContext connectedNodeContext : new ArrayList<VertexNodeConnectionContext>(this.connectedNodes)) {
            class_1309 livingEntity2;
            VertexNode connectedNode = connectedNodeContext.getVertexNode();
            boolean isBeamParent = connectedNodeContext.isBeamParent();
            if (isBeamParent) {
                this.spawnParticleBeamVFX(entity.method_37908(), this.getEyeLevelPositionAdjusted(entity), this.getEyeLevelPositionAdjusted(connectedNode.entityRef));
            }
            if (!isClientSide && isBeamParent && entity.field_6012 % 2 == 0) {
                List<class_1309> entitiesTouchingBeam = this.getLivingEntitiesTouchingBeam(entity.method_37908(), entity.method_19538(), connectedNode.entityRef.method_19538(), 0.5);
                entitiesTouchingBeam.remove(this.entityRef);
                entitiesTouchingBeam.remove(connectedNode.entityRef);
                entitiesTouchingBeam.removeIf(livingEntity -> livingEntity instanceof FairkeeperSerpentEntity);
                for (class_1309 livingEntity3 : entitiesTouchingBeam) {
                    VertexNode entityInBeamVertexNode;
                    VertexTransmissionEffect vertexTransmissionEffect;
                    int slownessDurationTicks = 60;
                    int slownessAmplifier = this.getConnectionCount();
                    int vertexTransDurationTicks = 60;
                    int vertexTransAmplifier = 0;
                    livingEntity3.method_6092(new class_1293(class_1294.field_5909, slownessDurationTicks, slownessAmplifier));
                    boolean entityHasEffect = livingEntity3.method_6059(DNLMobEffects.VERTEX_TRANSMISSION.get());
                    if (!entityHasEffect) {
                        livingEntity3.method_6092(new class_1293(DNLMobEffects.VERTEX_TRANSMISSION.get(), vertexTransDurationTicks, vertexTransAmplifier));
                    } else if (entity.field_6012 % 10 == 0) {
                        livingEntity3.method_6092(new class_1293(DNLMobEffects.VERTEX_TRANSMISSION.get(), vertexTransDurationTicks, vertexTransAmplifier));
                        vertexTransmissionEffect = (VertexTransmissionEffect)livingEntity3.method_6112(DNLMobEffects.VERTEX_TRANSMISSION.get()).method_5579();
                        vertexTransmissionEffect.markAsReconnectionCase(livingEntity3.method_5667());
                    }
                    if ((entityInBeamVertexNode = (vertexTransmissionEffect = (VertexTransmissionEffect)livingEntity3.method_6112(DNLMobEffects.VERTEX_TRANSMISSION.get()).method_5579()).getVertexNode(livingEntity3.method_5667())) == null || entityInBeamVertexNode.getConnectionCount() != 0) continue;
                    vertexTransmissionEffect.setNoConnectionBeamDamageCase(livingEntity3.method_5667(), true);
                }
            }
            boolean nodeShouldDisconnect = connectedNode.entityRef.method_31481() || !connectedNode.entityRef.method_5805() || connectedNode.entityRef.method_5858(this.entityRef) > 100.0;
            class_1297 class_12972 = connectedNode.entityRef;
            if (class_12972 instanceof class_1309 && (livingEntity2 = (class_1309)class_12972).method_29504()) {
                nodeShouldDisconnect = true;
            }
            if (isClientSide || !nodeShouldDisconnect) continue;
            connectedNode.disconnect_all();
        }
    }

    private class_243 getEyeLevelPositionAdjusted(class_1297 entity) {
        class_243 finalPos = entity.method_33571();
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            finalPos = new class_243(finalPos.field_1352, finalPos.field_1351 + -0.5, finalPos.field_1350);
        }
        return finalPos;
    }

    private List<VertexNode> getNearbyNodes(class_1297 sourceEntity) {
        double radius_squared = 100.0;
        return sourceEntity.method_37908().method_18467(class_1297.class, sourceEntity.method_5829().method_1014(10.0)).stream().filter(potentialNodeEntity -> potentialNodeEntity != sourceEntity).filter(potentialNodeEntity -> {
            class_1309 livingEntity;
            VertexArrowProjectileEntity arrowEntity;
            return potentialNodeEntity instanceof VertexArrowProjectileEntity && (arrowEntity = (VertexArrowProjectileEntity)((Object)potentialNodeEntity)).isFullyPowered() || potentialNodeEntity instanceof class_1309 && (livingEntity = (class_1309)potentialNodeEntity).method_6059(DNLMobEffects.VERTEX_TRANSMISSION.get());
        }).filter(nodeEntity -> nodeEntity.method_5858(sourceEntity) <= radius_squared).sorted(Comparator.comparingDouble(nodeEntity -> nodeEntity.method_5858(sourceEntity))).map(nodeEntity -> {
            if (nodeEntity instanceof VertexArrowProjectileEntity) {
                VertexArrowProjectileEntity arrowEntity = (VertexArrowProjectileEntity)((Object)nodeEntity);
                return arrowEntity.getVertexNode();
            }
            class_1309 livingEntity = (class_1309)nodeEntity;
            return this.getComponentFromEffect(livingEntity);
        }).filter(Objects::nonNull).filter(node -> node.getConnectionCount() < 2).limit(2L).collect(Collectors.toList());
    }

    private VertexNode getComponentFromEffect(class_1309 entity) {
        class_1293 effectInstance;
        class_1291 class_12912;
        if (entity.method_6059(DNLMobEffects.VERTEX_TRANSMISSION.get()) && (class_12912 = (effectInstance = entity.method_6112(DNLMobEffects.VERTEX_TRANSMISSION.get())).method_5579()) instanceof VertexTransmissionEffect) {
            VertexTransmissionEffect customEffect = (VertexTransmissionEffect)class_12912;
            return customEffect.getVertexNode(entity.method_5667());
        }
        return null;
    }

    private void spawnParticleBeamVFX(class_1937 level, class_243 startPos, class_243 endPos) {
        class_243 line = endPos.method_1020(startPos);
        double distance = line.method_1033();
        int numberOfParticles = (int)Math.ceil(distance / 0.1);
        for (int i = 0; i <= numberOfParticles; ++i) {
            int randomNumber = ThreadLocalRandom.current().nextInt(3);
            if (randomNumber != 0) continue;
            double t = (double)i / (double)numberOfParticles;
            class_243 particlePos = startPos.method_1019(line.method_1021(t));
            if (!(level instanceof class_3218)) continue;
            class_3218 _level = (class_3218)level;
            float scaleMultiplier = (float)Math.random() * 3.0f;
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.VERTEX_SPARK_PARTICLE.get(), 0.05f * scaleMultiplier);
            _level.method_14199((class_2394)particleData, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void spawnInitialParticleBeamVFX(class_1937 level, class_243 startPos, class_243 endPos) {
        class_243 line = endPos.method_1020(startPos);
        double distance = line.method_1033();
        int numberOfParticles = (int)Math.ceil(distance / 0.8);
        for (int i = 0; i <= numberOfParticles; ++i) {
            double t = (double)i / (double)numberOfParticles;
            class_243 particlePos = startPos.method_1019(line.method_1021(t));
            if (!(level instanceof class_3218)) continue;
            class_3218 _level = (class_3218)level;
            float particleScale = 0.2f + (float)Math.random() * 0.2f;
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
            _level.method_14199((class_2394)particleData, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private List<class_1309> getLivingEntitiesTouchingBeam(class_1937 level, class_243 beamStart, class_243 beamEnd, double radius) {
        ArrayList<class_1309> entitiesInCapsule = new ArrayList<class_1309>();
        List allEntities = level.method_18467(class_1309.class, new class_238(Math.min(beamStart.field_1352, beamEnd.field_1352) - radius, Math.min(beamStart.field_1351, beamEnd.field_1351) - radius, Math.min(beamStart.field_1350, beamEnd.field_1350) - radius, Math.max(beamStart.field_1352, beamEnd.field_1352) + radius, Math.max(beamStart.field_1351, beamEnd.field_1351) + radius, Math.max(beamStart.field_1350, beamEnd.field_1350) + radius));
        for (class_1309 entity : allEntities) {
            if (!this.isBoundingBoxIntersectingWithCapsule(entity.method_5829(), beamStart, beamEnd, radius)) continue;
            entitiesInCapsule.add(entity);
        }
        return entitiesInCapsule;
    }

    private boolean isBoundingBoxIntersectingWithCapsule(class_238 boundingBox, class_243 beamStart, class_243 beamEnd, double radius) {
        class_243 closestPointOnBeam = this.getClosestPointOnBeam(boundingBox, beamStart, beamEnd);
        return closestPointOnBeam.method_1025(boundingBox.method_1005()) <= radius * radius || boundingBox.method_1006(closestPointOnBeam);
    }

    private class_243 getClosestPointOnBeam(class_238 boundingBox, class_243 start, class_243 end) {
        class_243 beamDirection = end.method_1020(start).method_1029();
        class_243 boxCenter = boundingBox.method_1005();
        double t = beamDirection.method_1026(boxCenter.method_1020(start));
        t = Math.max(0.0, Math.min(t, start.method_1022(end)));
        return start.method_1019(beamDirection.method_1021(t));
    }
}

