/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.entity;

import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.util.DNLMath;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;

public class VertexPillarBlockEntity
extends class_2586 {
    private final List<class_2338> linkedPositions = new ArrayList<class_2338>();
    private int age;
    private static final float DAMAGE = 6.0f;
    private static final double BEAM_HITBOX_RADIUS = 0.5;
    private static final int SLOWNESS_DURATION = 20;
    private static final int SLOWNESS_AMPLIFIER = 4;
    private static final double BEAM_PARTICLE_SPACING = 0.4;
    private static final float BEAM_PARTICLE_SCALE = 0.05f;
    private static final float MAX_RANDOM_PARTICLE_SCALE_MULTIPLIER = 3.0f;
    private static final double BEAM_INITIAL_PARTICLE_SPACING = 0.8;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MIN = 0.2f;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MAX = 0.4f;

    public VertexPillarBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(DNLBlockEntityTypes.VERTEX_PILLAR.get(), blockPos, blockState);
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        class_2499 posList = new class_2499();
        for (class_2338 pos : this.linkedPositions) {
            class_2487 posTag = new class_2487();
            posTag.method_10569("X", pos.method_10263());
            posTag.method_10569("Y", pos.method_10264());
            posTag.method_10569("Z", pos.method_10260());
            posList.add((Object)posTag);
        }
        compoundTag.method_10566("LinkedPositions", (class_2520)posList);
        compoundTag.method_10569("Age", this.age);
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.linkedPositions.clear();
        class_2499 posList = compoundTag.method_10554("LinkedPositions", 10);
        for (class_2520 tag : posList) {
            class_2487 posTag = (class_2487)tag;
            class_2338 loadedPos = new class_2338(posTag.method_10550("X"), posTag.method_10550("Y"), posTag.method_10550("Z"));
            this.linkedPositions.add(loadedPos);
        }
        this.age = compoundTag.method_10550("Age");
    }

    public List<class_2338> getLinkedPositions() {
        return this.linkedPositions;
    }

    public boolean addLink(class_2338 pos) {
        if (!this.linkedPositions.contains(pos)) {
            this.linkedPositions.add(pos);
            this.method_5431();
            return true;
        }
        return false;
    }

    public void removeLink(class_2338 pos) {
        this.linkedPositions.remove(pos);
        this.method_5431();
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, VertexPillarBlockEntity blockEntity) {
        if (!level.field_9236) {
            for (class_2338 linkedPos : blockEntity.getLinkedPositions()) {
                class_2586 targetBE = level.method_8321(linkedPos);
                if (!(targetBE instanceof VertexPillarBlockEntity)) continue;
                VertexPillarBlockEntity pillarBlockEntity = (VertexPillarBlockEntity)targetBE;
                if (pillarBlockEntity.age <= blockEntity.age) continue;
                if (blockEntity.age > 0) {
                    VertexPillarBlockEntity.spawnRedstoneLaser((class_3218)level, pos, linkedPos);
                    continue;
                }
                VertexPillarBlockEntity.spawnInitialParticleBeamVFX(level, pos.method_46558().method_1031(0.0, 1.0, 0.0), linkedPos.method_46558().method_1031(0.0, 1.0, 0.0));
                level.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), DNLSounds.VERTEX_NODE_CONNECT.get(), class_3419.field_15254, 0.5f, 1.2f / (DNLMath.randomRange(0.0f, 1.0f) * 0.2f + 0.9f));
            }
            ++blockEntity.age;
        }
    }

    private static void spawnRedstoneLaser(class_3218 level, class_2338 start, class_2338 end) {
        class_243 startVec = class_243.method_24953((class_2382)start).method_1031(0.0, 1.0, 0.0);
        class_243 endVec = class_243.method_24953((class_2382)end).method_1031(0.0, 1.0, 0.0);
        List<class_1309> entities = VertexPillarBlockEntity.getLivingEntitiesTouchingBeam((class_1937)level, startVec, endVec, 0.5);
        for (class_1309 entity : entities) {
            if (entity instanceof FairkeeperSerpentEntity) continue;
            entity.method_5643(entity.method_37908().method_48963().method_48831(), 6.0f);
            entity.method_6092(new class_1293(class_1294.field_5909, 20, 4));
        }
        VertexPillarBlockEntity.spawnParticleBeamVFX((class_1937)level, startVec, endVec);
    }

    private static List<class_1309> getLivingEntitiesTouchingBeam(class_1937 level, class_243 beamStart, class_243 beamEnd, double radius) {
        ArrayList<class_1309> entitiesInCapsule = new ArrayList<class_1309>();
        List allEntities = level.method_18467(class_1309.class, new class_238(Math.min(beamStart.field_1352, beamEnd.field_1352) - radius, Math.min(beamStart.field_1351, beamEnd.field_1351) - radius, Math.min(beamStart.field_1350, beamEnd.field_1350) - radius, Math.max(beamStart.field_1352, beamEnd.field_1352) + radius, Math.max(beamStart.field_1351, beamEnd.field_1351) + radius, Math.max(beamStart.field_1350, beamEnd.field_1350) + radius));
        for (class_1309 entity : allEntities) {
            if (!VertexPillarBlockEntity.isBoundingBoxIntersectingWithCapsule(entity.method_5829(), beamStart, beamEnd, radius)) continue;
            entitiesInCapsule.add(entity);
        }
        return entitiesInCapsule;
    }

    private static class_243 getClosestPointOnBeam(class_238 boundingBox, class_243 start, class_243 end) {
        class_243 beamDirection = end.method_1020(start).method_1029();
        class_243 boxCenter = boundingBox.method_1005();
        double t = beamDirection.method_1026(boxCenter.method_1020(start));
        t = Math.max(0.0, Math.min(t, start.method_1022(end)));
        return start.method_1019(beamDirection.method_1021(t));
    }

    private static boolean isBoundingBoxIntersectingWithCapsule(class_238 boundingBox, class_243 beamStart, class_243 beamEnd, double radius) {
        class_243 closestPointOnBeam = VertexPillarBlockEntity.getClosestPointOnBeam(boundingBox, beamStart, beamEnd);
        return closestPointOnBeam.method_1025(boundingBox.method_1005()) <= radius * radius || boundingBox.method_1006(closestPointOnBeam);
    }

    private static void spawnParticleBeamVFX(class_1937 level, class_243 startPos, class_243 endPos) {
        class_243 line = endPos.method_1020(startPos);
        double distance = line.method_1033();
        int numberOfParticles = (int)Math.ceil(distance / 0.4);
        for (int i = 0; i <= numberOfParticles; ++i) {
            int randomNumber = ThreadLocalRandom.current().nextInt(3);
            if (randomNumber != 0) continue;
            double t = (double)i / (double)numberOfParticles;
            class_243 particlePos = startPos.method_1019(line.method_1021(t));
            if (!(level instanceof class_3218)) continue;
            class_3218 _level = (class_3218)level;
            float scaleMultiplier = (float)Math.random() * 3.0f;
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.VERTEX_SPARK_PARTICLE.get(), 0.05f * scaleMultiplier);
            _level.method_14199((class_2394)particleData, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void spawnInitialParticleBeamVFX(class_1937 level, class_243 startPos, class_243 endPos) {
        class_243 line = endPos.method_1020(startPos);
        double distance = line.method_1033();
        int numberOfParticles = (int)Math.ceil(distance / 0.8);
        for (int i = 0; i <= numberOfParticles; ++i) {
            double t = (double)i / (double)numberOfParticles;
            class_243 particlePos = startPos.method_1019(line.method_1021(t));
            if (!(level instanceof class_3218)) continue;
            class_3218 _level = (class_3218)level;
            float particleScale = 0.2f + (float)Math.random() * 0.2f;
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
            _level.method_14199((class_2394)particleData, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

