/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.entity;

import dev.hexnowloading.dungeonnowloading.block.FairkeeperChestBlock;
import dev.hexnowloading.dungeonnowloading.block.entity.BallistaGolemStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.entity.FairkeeperSpawnerBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.entity.ScuttleStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.property.ChestStates;
import dev.hexnowloading.dungeonnowloading.particle.type.AxisParticleType;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_4076;

public class FairkeeperChestBlockEntity
extends class_2621
implements class_3908 {
    public static final String LOOT_TABLE_TAG = "LootTable";
    public static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";
    private class_2371<class_1799> items = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    protected class_2960 lootTable;
    protected long lootTableSeed;
    private class_2960 combatLootTable;
    private long combatLootTableSeed;
    private List<class_2338> blockEntityLocationList;
    private class_2338 oldBlockPos;
    private class_2338 lastSpawner;
    private int startUpTick;
    private int actualRegion1X;
    private int actualRegion1Y;
    private int actualRegion1Z;
    private int actualRegion2X;
    private int actualRegion2Y;
    private int actualRegion2Z;
    private int facing;
    private class_2338 maxRegion;
    private class_2338 minRegion;
    private int playerCount;
    private boolean disabled = false;
    private static final double PLAYER_RANGE = 48.0;
    private static final int START_UP_TICK = 60;
    private static final int OPEN_CLOSE_ANIMATION_DURATION = 10;
    private int openCloseAnimationProgress = 0;
    private int prevOpenCloseAnimationProgress = 0;

    public FairkeeperChestBlockEntity(class_2338 pos, class_2680 state) {
        super(DNLBlockEntityTypes.FAIRKEEPER_CHEST.get(), pos, state);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (!this.method_11286(nbt)) {
            class_1262.method_5426((class_2487)nbt, this.items);
        } else if (this.combatLootTable != null) {
            nbt.method_10582("CombatLootTable", this.combatLootTable.toString());
            if (this.combatLootTableSeed != 0L) {
                nbt.method_10544("CombatLootTableSeed", this.combatLootTableSeed);
            }
        }
        if (this.blockEntityLocationList != null) {
            class_2499 listTag = new class_2499();
            this.blockEntityLocationList.forEach(blockPos -> listTag.add((Object)this.newIntList(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260())));
            nbt.method_10566("SpawnerLocations", (class_2520)listTag);
        }
        if (this.lastSpawner != null) {
            nbt.method_10566("LastSpawner", (class_2520)this.newIntList(this.lastSpawner.method_10263(), this.lastSpawner.method_10264(), this.lastSpawner.method_10260()));
        }
        nbt.method_10569("Facing", this.facing);
        nbt.method_10566("OldBlockPos", (class_2520)this.newIntList(this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260()));
        nbt.method_10569("StartUpTick", this.startUpTick);
        nbt.method_10569("PlayerCount", this.playerCount);
        nbt.method_10556("Disabled", this.disabled);
        if (this.maxRegion != null) {
            nbt.method_10566("MaxRegion", (class_2520)this.newIntList(this.maxRegion.method_10263(), this.maxRegion.method_10264(), this.maxRegion.method_10260()));
        }
        if (this.minRegion != null) {
            nbt.method_10566("MinRegion", (class_2520)this.newIntList(this.minRegion.method_10263(), this.minRegion.method_10264(), this.minRegion.method_10260()));
        }
    }

    private class_2499 newIntList(int ... ints) {
        class_2499 listTag = new class_2499();
        for (int i : ints) {
            listTag.add((Object)class_2497.method_23247((int)i));
        }
        return listTag;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_11283(nbt)) {
            class_1262.method_5429((class_2487)nbt, this.items);
        } else if (nbt.method_10573("CombatLootTable", 8)) {
            this.combatLootTable = new class_2960(nbt.method_10558("CombatLootTable"));
            this.combatLootTableSeed = nbt.method_10537("CombatLootTableSeed");
        }
        if (nbt.method_10573("SpawnerLocations", 9)) {
            class_2499 listTag = nbt.method_10554("SpawnerLocations", 9);
            if (this.blockEntityLocationList == null) {
                this.blockEntityLocationList = new ArrayList<class_2338>();
            }
            for (int a = 0; a < listTag.size(); ++a) {
                this.blockEntityLocationList.add(new class_2338(listTag.method_10600(0), listTag.method_10600(1), listTag.method_10600(2)));
            }
        }
        if (nbt.method_10573("LastSpawner", 9)) {
            this.lastSpawner = new class_2338(nbt.method_10554("LastSpawner", 3).method_10600(0), nbt.method_10554("LastSpawner", 3).method_10600(1), nbt.method_10554("LastSpawner", 3).method_10600(2));
        }
        this.facing = nbt.method_10550("Facing");
        this.startUpTick = nbt.method_10550("StartUpTick");
        this.playerCount = nbt.method_10550("PlayerCount");
        this.disabled = nbt.method_10577("Disabled");
        this.oldBlockPos = new class_2338(nbt.method_10554("OldBlockPos", 3).method_10600(0), nbt.method_10554("OldBlockPos", 3).method_10600(1), nbt.method_10554("OldBlockPos", 3).method_10600(2));
        if (nbt.method_10573("MaxRegion", 9)) {
            this.maxRegion = new class_2338(nbt.method_10554("MaxRegion", 3).method_10600(0), nbt.method_10554("MaxRegion", 3).method_10600(1), nbt.method_10554("MaxRegion", 3).method_10600(2));
        }
        if (nbt.method_10573("MinRegion", 9)) {
            this.minRegion = new class_2338(nbt.method_10554("MinRegion", 3).method_10600(0), nbt.method_10554("MinRegion", 3).method_10600(1), nbt.method_10554("MinRegion", 3).method_10600(2));
        }
    }

    public boolean hasSpawnerLocations() {
        if (this.blockEntityLocationList == null) {
            return false;
        }
        return !this.blockEntityLocationList.isEmpty();
    }

    public class_2487 setCombatLootTable(FairkeeperChestBlockEntity blockEntity) {
        class_2487 nbt = blockEntity.method_38242().method_10553();
        if (nbt.method_10573("CombatLootTable", 8)) {
            nbt.method_10582(LOOT_TABLE_TAG, blockEntity.combatLootTable.toString());
            nbt.method_10544(LOOT_TABLE_SEED_TAG, blockEntity.combatLootTableSeed);
            nbt.method_10551("CombatLootTable");
            nbt.method_10551("CombatLootTableSeed");
        }
        return nbt;
    }

    public class_238 getBoundaryAABB() {
        return new class_238((double)this.actualRegion1X, (double)this.actualRegion1Y, (double)this.actualRegion1Z, (double)this.actualRegion2X, (double)this.actualRegion2Y, (double)this.actualRegion2Z);
    }

    public int getActualRegion1X() {
        return this.actualRegion1X;
    }

    public boolean hasLastSpawner(class_1937 level, FairkeeperChestBlockEntity blockEntity) {
        if (blockEntity.lastSpawner != null) {
            return level.method_8320(blockEntity.lastSpawner).method_27852(DNLBlocks.FAIRKEEEPER_SPAWNER.get());
        }
        return false;
    }

    private void removeLootTable() {
        if (this.lootTable != null) {
            this.lootTable = null;
        }
    }

    public void setDisabled(boolean b) {
        this.disabled = b;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.dungeonnowloading.fairkeeper_chest");
    }

    protected class_1703 method_5465(int i, class_1661 inventory) {
        return class_1707.method_19245((int)i, (class_1661)inventory, (class_1263)this);
    }

    public int method_5439() {
        return 27;
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> itemStacks) {
        this.items = itemStacks;
    }

    public void method_5435(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            FairkeeperChestBlock.setFairkeeperChest(this.method_10997(), this.method_11016(), ChestStates.OPENING);
            FairkeeperChestBlockEntity.playSound(this.method_10997(), this.method_11016(), class_3417.field_14982);
            FairkeeperChestBlockEntity.destroySpawners(this.method_10997(), this);
        }
    }

    public void method_5432(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            FairkeeperChestBlock.setFairkeeperChest(this.method_10997(), this.method_11016(), ChestStates.CLOSING);
            FairkeeperChestBlockEntity.playSound(this.method_10997(), this.method_11016(), class_3417.field_14823);
        }
    }

    public static void playSound(class_1937 level, class_2338 blockPos, class_3414 soundEvent) {
        level.method_8396((class_1657)null, blockPos, soundEvent, class_3419.field_15245, 0.5f, level.field_9229.method_43057() * 0.1f + 0.9f);
    }

    public static void setMaxMinRegion(class_1937 level, class_2338 blockPos, FairkeeperChestBlockEntity blockEntity) {
        int xp = 0;
        int xn = 0;
        int yp = 0;
        int yn = 0;
        int zp = 0;
        int zn = 0;
        int i = 0;
        while ((double)i < 48.0) {
            if (level.method_8320(blockPos.method_10069(0, i, 0)).method_27852(class_2246.field_10002) && yp == 0) {
                yp = i;
            }
            if (level.method_8320(blockPos.method_10069(0, 0, i)).method_27852(class_2246.field_10002) && zp == 0) {
                zp = i;
            }
            if (level.method_8320(blockPos.method_10069(i, 0, 0)).method_27852(class_2246.field_10002) && xp == 0) {
                xp = i;
            }
            if (level.method_8320(blockPos.method_10069(0, -i, 0)).method_27852(class_2246.field_10002) && yn == 0) {
                yn = -i;
            }
            if (level.method_8320(blockPos.method_10069(0, 0, -i)).method_27852(class_2246.field_10002) && zn == 0) {
                zn = -i;
            }
            if (level.method_8320(blockPos.method_10069(-i, 0, 0)).method_27852(class_2246.field_10002) && xn == 0) {
                xn = -i;
            }
            ++i;
        }
        blockEntity.maxRegion = new class_2338(xp, yp, zp);
        blockEntity.minRegion = new class_2338(xn, yn, zn);
        int tempActualRegion1X = blockPos.method_10263() + blockEntity.maxRegion.method_10263();
        int tempActualRegion1Y = blockPos.method_10264() + blockEntity.maxRegion.method_10264();
        int tempActualRegion1Z = blockPos.method_10260() + blockEntity.maxRegion.method_10260();
        int tempActualRegion2X = blockPos.method_10263() + blockEntity.minRegion.method_10263();
        int tempActualRegion2Y = blockPos.method_10264() + blockEntity.minRegion.method_10264();
        int tempActualRegion2Z = blockPos.method_10260() + blockEntity.minRegion.method_10260();
        blockEntity.actualRegion1X = Math.max(tempActualRegion1X, tempActualRegion2X) + 1;
        blockEntity.actualRegion1Y = Math.max(tempActualRegion1Y, tempActualRegion2Y) + 1;
        blockEntity.actualRegion1Z = Math.max(tempActualRegion1Z, tempActualRegion2Z) + 1;
        blockEntity.actualRegion2X = Math.min(tempActualRegion1X, tempActualRegion2X);
        blockEntity.actualRegion2Y = Math.min(tempActualRegion1Y, tempActualRegion2Y);
        blockEntity.actualRegion2Z = Math.min(tempActualRegion1Z, tempActualRegion2Z);
    }

    private static void rotationalSetRegion(class_1937 level, class_2338 pos, class_2680 state, FairkeeperChestBlockEntity blockEntity) {
        class_2338 tempRegion1;
        class_2338 actualMax = new class_2338(Math.max(blockEntity.maxRegion.method_10263(), blockEntity.minRegion.method_10263()) + 1, Math.max(blockEntity.maxRegion.method_10264(), blockEntity.minRegion.method_10264()) + 1, Math.max(blockEntity.maxRegion.method_10260(), blockEntity.minRegion.method_10260()) + 1);
        class_2338 actualMin = new class_2338(Math.min(blockEntity.maxRegion.method_10263(), blockEntity.minRegion.method_10263()), Math.min(blockEntity.maxRegion.method_10264(), blockEntity.minRegion.method_10264()), Math.min(blockEntity.maxRegion.method_10260(), blockEntity.minRegion.method_10260()));
        int facingDifference = FairkeeperChestBlock.getFacingInt(level, pos) - blockEntity.facing;
        class_2338 tempRegion2 = switch (facingDifference) {
            default -> {
                tempRegion1 = actualMax;
                yield actualMin;
            }
            case -3, 1 -> {
                tempRegion1 = actualMax.method_10070(class_2470.field_11463).method_10078();
                yield actualMin.method_10070(class_2470.field_11463).method_10078();
            }
            case -1, 3 -> {
                tempRegion1 = actualMax.method_10070(class_2470.field_11465).method_10072();
                yield actualMin.method_10070(class_2470.field_11465).method_10072();
            }
            case -2, 2 -> {
                tempRegion1 = actualMax.method_10070(class_2470.field_11464).method_10078().method_10072();
                yield actualMin.method_10070(class_2470.field_11464).method_10078().method_10072();
            }
        };
        int tempActualRegion1X = pos.method_10263() + tempRegion1.method_10263();
        int tempActualRegion1Y = pos.method_10264() + tempRegion1.method_10264();
        int tempActualRegion1Z = pos.method_10260() + tempRegion1.method_10260();
        int tempActualRegion2X = pos.method_10263() + tempRegion2.method_10263();
        int tempActualRegion2Y = pos.method_10264() + tempRegion2.method_10264();
        int tempActualRegion2Z = pos.method_10260() + tempRegion2.method_10260();
        blockEntity.actualRegion1X = Math.max(tempActualRegion1X, tempActualRegion2X);
        blockEntity.actualRegion1Y = Math.max(tempActualRegion1Y, tempActualRegion2Y);
        blockEntity.actualRegion1Z = Math.max(tempActualRegion1Z, tempActualRegion2Z);
        blockEntity.actualRegion2X = Math.min(tempActualRegion1X, tempActualRegion2X);
        blockEntity.actualRegion2Y = Math.min(tempActualRegion1Y, tempActualRegion2Y);
        blockEntity.actualRegion2Z = Math.min(tempActualRegion1Z, tempActualRegion2Z);
    }

    private static void updateActualRegion(class_1937 level, class_2338 pos, class_2680 state, FairkeeperChestBlockEntity blockEntity) {
        if (blockEntity.maxRegion == null) {
            blockEntity.maxRegion = new class_2338(0, 0, 0);
        }
        if (blockEntity.minRegion == null) {
            blockEntity.minRegion = new class_2338(0, 0, 0);
        }
        if (blockEntity.oldBlockPos == null || blockEntity.maxRegion.method_10265((class_2382)blockEntity.minRegion) == 0) {
            FairkeeperChestBlockEntity.setMaxMinRegion(level, pos, blockEntity);
            blockEntity.oldBlockPos = pos;
            blockEntity.facing = FairkeeperChestBlock.getFacingInt(level, pos);
            return;
        }
        if (pos != blockEntity.oldBlockPos) {
            FairkeeperChestBlockEntity.rotationalSetRegion(level, pos, state, blockEntity);
            blockEntity.oldBlockPos = pos;
        }
    }

    private static void triggerSpawners(class_1937 level, class_2338 fairkeeperChestPos, FairkeeperChestBlockEntity blockEntity) {
        blockEntity.startUpTick = 60;
        class_2487 compoundTag = blockEntity.setCombatLootTable(blockEntity);
        FairkeeperChestBlock.setFairkeeperAlert(level, fairkeeperChestPos, Boolean.TRUE);
        class_2586 newBlockEntity = level.method_8321(fairkeeperChestPos);
        newBlockEntity.method_11014(compoundTag);
        class_238 aabb = new class_238((double)blockEntity.actualRegion1X, (double)blockEntity.actualRegion1Y, (double)blockEntity.actualRegion1Z, (double)blockEntity.actualRegion2X, (double)blockEntity.actualRegion2Y, (double)blockEntity.actualRegion2Z);
        List nearbyPlayers = level.method_18467(class_1657.class, aabb);
        blockEntity.playerCount = nearbyPlayers.size();
        HashMap map = new HashMap();
        int chunkMinX = class_4076.method_18675((int)blockEntity.actualRegion2X);
        int chunkMinZ = class_4076.method_18675((int)blockEntity.actualRegion2Z);
        int chunkMaxX = class_4076.method_18675((int)blockEntity.actualRegion1X);
        int chunkMaxZ = class_4076.method_18675((int)blockEntity.actualRegion1Z);
        int x = 0;
        while (chunkMinX + x <= chunkMaxX) {
            int z = 0;
            while (chunkMinZ + z <= chunkMaxZ) {
                map.putAll(level.method_8497(chunkMinX + x, chunkMinZ + z).method_12214());
                ++z;
            }
            ++x;
        }
        Map<class_2338, class_2586> filtered = map.entrySet().stream().filter(e -> {
            ScuttleStatueBlockEntity scuttleStatueBlockEntity;
            Object patt20300$temp;
            FairkeeperSpawnerBlockEntity fairkeeperSpawnerBlockEntity;
            Object patt20123$temp = e.getValue();
            return patt20123$temp instanceof FairkeeperSpawnerBlockEntity && (Boolean)(fairkeeperSpawnerBlockEntity = (FairkeeperSpawnerBlockEntity)((Object)((Object)patt20123$temp))).method_11010().method_11654((class_2769)DNLProperties.FAIRKEEPER_ALERT) == false || (patt20300$temp = e.getValue()) instanceof ScuttleStatueBlockEntity && (scuttleStatueBlockEntity = (ScuttleStatueBlockEntity)((Object)((Object)patt20300$temp))).method_11010().method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607 || e.getValue() instanceof BallistaGolemStatueBlockEntity;
        }).filter(e -> ((class_2338)e.getKey()).method_10263() < blockEntity.actualRegion1X && ((class_2338)e.getKey()).method_10263() >= blockEntity.actualRegion2X && ((class_2338)e.getKey()).method_10264() < blockEntity.actualRegion1Y && ((class_2338)e.getKey()).method_10264() >= blockEntity.actualRegion2Y && ((class_2338)e.getKey()).method_10260() < blockEntity.actualRegion1Z && ((class_2338)e.getKey()).method_10260() >= blockEntity.actualRegion2Z).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        blockEntity.blockEntityLocationList = new ArrayList<class_2338>(filtered.keySet());
    }

    private static void destroySpawners(class_1937 level, FairkeeperChestBlockEntity blockEntity) {
        HashMap map = new HashMap();
        int chunkMinX = class_4076.method_18675((int)blockEntity.actualRegion2X);
        int chunkMinZ = class_4076.method_18675((int)blockEntity.actualRegion2Z);
        int chunkMaxX = class_4076.method_18675((int)blockEntity.actualRegion1X);
        int chunkMaxZ = class_4076.method_18675((int)blockEntity.actualRegion1Z);
        int x = 0;
        while (chunkMinX + x <= chunkMaxX) {
            int z = 0;
            while (chunkMinZ + z <= chunkMaxZ) {
                map.putAll(level.method_8497(chunkMinX + x, chunkMinZ + z).method_12214());
                ++z;
            }
            ++x;
        }
        Map<class_2338, class_2586> filtered = map.entrySet().stream().filter(e -> e.getValue() instanceof FairkeeperSpawnerBlockEntity).filter(e -> ((class_2338)e.getKey()).method_10263() < blockEntity.actualRegion1X && ((class_2338)e.getKey()).method_10263() >= blockEntity.actualRegion2X && ((class_2338)e.getKey()).method_10264() < blockEntity.actualRegion1Y && ((class_2338)e.getKey()).method_10264() >= blockEntity.actualRegion2Y && ((class_2338)e.getKey()).method_10260() < blockEntity.actualRegion1Z && ((class_2338)e.getKey()).method_10260() >= blockEntity.actualRegion2Z).filter(e -> (Boolean)((class_2586)e.getValue()).method_11010().method_11654((class_2769)DNLProperties.FAIRKEEPER_ALERT) == false).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        filtered.forEach((blockPosEntry, blockEntityEntry) -> ((FairkeeperSpawnerBlockEntity)((Object)blockEntityEntry)).setDisabled(true));
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, FairkeeperChestBlockEntity blockEntity) {
        blockEntity.prevOpenCloseAnimationProgress = blockEntity.openCloseAnimationProgress;
        if (state.method_11654(DNLProperties.CHEST_STATES) == ChestStates.OPENING) {
            if (blockEntity.openCloseAnimationProgress == 10) {
                FairkeeperChestBlock.setFairkeeperChest(level, pos, ChestStates.OPENED);
            } else {
                ++blockEntity.openCloseAnimationProgress;
            }
        } else if (state.method_11654(DNLProperties.CHEST_STATES) == ChestStates.CLOSING) {
            if (blockEntity.openCloseAnimationProgress == 0) {
                FairkeeperChestBlock.setFairkeeperChest(level, pos, ChestStates.CLOSED);
            } else {
                --blockEntity.openCloseAnimationProgress;
            }
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, FairkeeperChestBlockEntity blockEntity) {
        if (!blockEntity.disabled) {
            if (blockEntity.startUpTick > 0) {
                --blockEntity.startUpTick;
            } else {
                blockEntity.startUpTick = 20;
                if (level.method_18458((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 48.0)) {
                    FairkeeperChestBlockEntity.updateActualRegion(level, pos, state, blockEntity);
                    class_238 aabb = new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 1), (double)pos.method_10260()).method_1014(48.0);
                    List nearbyPlayers = level.method_18467(class_1657.class, aabb);
                    nearbyPlayers.forEach(player -> Services.DATA.addFairkeeperChestPositionList((class_1657)player, blockEntity.method_11016()));
                }
                if (((Boolean)state.method_11654((class_2769)DNLProperties.FAIRKEEPER_ALERT)).booleanValue()) {
                    if (blockEntity.blockEntityLocationList != null && blockEntity.blockEntityLocationList.size() == 1) {
                        blockEntity.lastSpawner = blockEntity.blockEntityLocationList.get(0);
                    }
                    FairkeeperChestBlockEntity.alertTick(level, pos, state, blockEntity);
                }
            }
            float xy = 1.0f - (float)(blockEntity.actualRegion1X - blockEntity.actualRegion2X) * (float)(blockEntity.actualRegion1Y - blockEntity.actualRegion2Y) / 1024.0f;
            float xz = 1.0f - (float)(blockEntity.actualRegion1X - blockEntity.actualRegion2X) * (float)(blockEntity.actualRegion1Z - blockEntity.actualRegion2Z) / 1024.0f;
            float yz = 1.0f - (float)(blockEntity.actualRegion1Y - blockEntity.actualRegion2Y) * (float)(blockEntity.actualRegion1Z - blockEntity.actualRegion2Z) / 1024.0f;
            double x = (float)blockEntity.actualRegion2X + (float)(blockEntity.actualRegion1X - blockEntity.actualRegion2X) * level.field_9229.method_43057();
            double y = (float)blockEntity.actualRegion2Y + (float)(blockEntity.actualRegion1Y - blockEntity.actualRegion2Y) * level.field_9229.method_43057();
            double z = (float)blockEntity.actualRegion2Z + (float)(blockEntity.actualRegion1Z - blockEntity.actualRegion2Z) * level.field_9229.method_43057();
            float r = level.field_9229.method_43057();
            if (r + 0.2f > yz) {
                ((class_3218)level).method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 270.0f), (double)((float)blockEntity.actualRegion1X + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
                ((class_3218)level).method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 90.0f), (double)((float)blockEntity.actualRegion2X + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (r + 0.2f > xz) {
                ((class_3218)level).method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 90.0f), x, (double)((float)blockEntity.actualRegion1Y + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
                ((class_3218)level).method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 270.0f), x, (double)((float)blockEntity.actualRegion2Y + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (r + 0.2f > xy) {
                ((class_3218)level).method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 180.0f), x, y, (double)((float)blockEntity.actualRegion1Z + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.1f), 1, 0.0, 0.0, 0.0, 0.0);
                ((class_3218)level).method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 0.0f), x, y, (double)((float)blockEntity.actualRegion2Z + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.1f), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void alertTick(class_1937 level, class_2338 pos, class_2680 state, FairkeeperChestBlockEntity blockEntity) {
        if (blockEntity.blockEntityLocationList == null) {
            blockEntity.blockEntityLocationList = new ArrayList<class_2338>();
            return;
        }
        if (blockEntity.blockEntityLocationList.isEmpty()) {
            return;
        }
        class_2338 spawnerBlockPos = blockEntity.blockEntityLocationList.get(0);
        class_2586 alertBlockEntity = level.method_8321(spawnerBlockPos);
        if (alertBlockEntity instanceof FairkeeperSpawnerBlockEntity) {
            FairkeeperSpawnerBlockEntity fairkeeperSpawnerBlockEntity = (FairkeeperSpawnerBlockEntity)alertBlockEntity;
            fairkeeperSpawnerBlockEntity.alert(blockEntity.playerCount == 0 ? 1 : blockEntity.playerCount, spawnerBlockPos, fairkeeperSpawnerBlockEntity);
        }
        if (alertBlockEntity instanceof ScuttleStatueBlockEntity) {
            ScuttleStatueBlockEntity scuttleStatueBlockEntity = (ScuttleStatueBlockEntity)alertBlockEntity;
            scuttleStatueBlockEntity.alert(spawnerBlockPos, scuttleStatueBlockEntity);
        }
        if (alertBlockEntity instanceof BallistaGolemStatueBlockEntity) {
            BallistaGolemStatueBlockEntity ballistaGolemStatueBlockEntity = (BallistaGolemStatueBlockEntity)alertBlockEntity;
            ballistaGolemStatueBlockEntity.alert(spawnerBlockPos, ballistaGolemStatueBlockEntity);
        }
        FairkeeperChestBlockEntity.redstoneBeam(level, pos, spawnerBlockPos);
        blockEntity.blockEntityLocationList.remove(0);
    }

    private static void redstoneBeam(class_1937 level, class_2338 originPos, class_2338 targetPos) {
        double d = targetPos.method_10263() - originPos.method_10263();
        double e = targetPos.method_10264() - originPos.method_10264();
        double f = targetPos.method_10260() - originPos.method_10260();
        double s = Math.sqrt(d * d + e * e + f * f);
        d /= s;
        e /= s;
        f /= s;
        double r = level.field_9229.method_43058();
        while (r < s) {
            ((class_3218)level).method_14199((class_2394)class_2390.field_11188, (double)originPos.method_10263() + 0.5 + d * (r += 0.2), (double)originPos.method_10264() + 0.5 + e * r, (double)originPos.method_10260() + 0.5 + f * r, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static boolean scanFairkeeperChestPositions(class_1937 level, class_2338 fairkeeperChestPos, class_2338 brokenBlockPos) {
        if ((double)FairkeeperChestBlockEntity.fairkeeperChestToBrokenBlockDistance(fairkeeperChestPos, brokenBlockPos) > 48.0) {
            return false;
        }
        class_2680 fairkeeperChestState = level.method_8320(fairkeeperChestPos);
        if (!fairkeeperChestState.method_27852(DNLBlocks.FAIRKEEPER_CHEST.get())) {
            return false;
        }
        if (((Boolean)fairkeeperChestState.method_11654((class_2769)FairkeeperChestBlock.FAIRKEEPER_ALERT)).booleanValue()) {
            return false;
        }
        class_2586 class_25862 = level.method_8321(fairkeeperChestPos);
        if (class_25862 instanceof FairkeeperChestBlockEntity) {
            FairkeeperChestBlockEntity fairkeeperChestBlockEntity = (FairkeeperChestBlockEntity)class_25862;
            if (fairkeeperChestBlockEntity.disabled) {
                return false;
            }
            if (fairkeeperChestBlockEntity.actualRegion1X > brokenBlockPos.method_10263() && fairkeeperChestBlockEntity.actualRegion1Y > brokenBlockPos.method_10264() && fairkeeperChestBlockEntity.actualRegion1Z > brokenBlockPos.method_10260() && fairkeeperChestBlockEntity.actualRegion2X <= brokenBlockPos.method_10263() && fairkeeperChestBlockEntity.actualRegion2Y <= brokenBlockPos.method_10264() && fairkeeperChestBlockEntity.actualRegion2Z <= brokenBlockPos.method_10260()) {
                fairkeeperChestBlockEntity.removeLootTable();
                FairkeeperChestBlockEntity.redstoneBeam(level, fairkeeperChestPos, brokenBlockPos);
                FairkeeperChestBlockEntity.outlineCauseBlock(level, brokenBlockPos);
                FairkeeperChestBlockEntity.playSound(level, brokenBlockPos, class_3417.field_14588);
                FairkeeperChestBlockEntity.triggerSpawners(level, fairkeeperChestPos, fairkeeperChestBlockEntity);
                return false;
            }
        }
        return true;
    }

    private static void outlineCauseBlock(class_1937 level, class_2338 blockPos) {
        double x = (double)blockPos.method_10263() + 0.5;
        double y = (double)blockPos.method_10264() + 0.5;
        double z = (double)blockPos.method_10260() + 0.5;
        ((class_3218)level).method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 270.0f), (double)((float)blockPos.method_10263() + 1.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
        ((class_3218)level).method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 90.0f), (double)((float)blockPos.method_10263() - 0.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
        ((class_3218)level).method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 90.0f), x, (double)((float)blockPos.method_10264() + 1.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
        ((class_3218)level).method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 270.0f), x, (double)((float)blockPos.method_10264() - 0.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
        ((class_3218)level).method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 180.0f), x, y, (double)((float)blockPos.method_10260() + 1.1f), 1, 0.0, 0.0, 0.0, 0.0);
        ((class_3218)level).method_14199((class_2394)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 0.0f), x, y, (double)((float)blockPos.method_10260() - 0.1f), 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static float fairkeeperChestToBrokenBlockDistance(class_2338 fairkeeperChestPos, class_2338 brokenBlockPos) {
        float f = fairkeeperChestPos.method_10263() - brokenBlockPos.method_10263();
        float g = fairkeeperChestPos.method_10264() - brokenBlockPos.method_10264();
        float h = fairkeeperChestPos.method_10260() - brokenBlockPos.method_10260();
        return class_3532.method_15355((float)(f * f + g * g + h * h));
    }

    public float getOpenProgress(float partialTicks) {
        return ((float)this.prevOpenCloseAnimationProgress + (float)(this.openCloseAnimationProgress - this.prevOpenCloseAnimationProgress) * partialTicks) / 10.0f;
    }

    public boolean isDisabled(FairkeeperChestBlockEntity blockEntity) {
        return blockEntity.disabled;
    }
}

