/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.bank.CardSlot;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.coins.SlotInputMergingCoinBag;
import dev.ithundxr.createnumismatics.content.coins.SlotOutputMergingCoinBag;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;

public class BankMenu
extends MenuBase<BankAccount> {
    public static final int COIN_SLOTS;
    public static final int COIN_INPUT_SLOT_INDEX;
    public static final int CARD_SLOT_INDEX;
    public static final int PLAYER_INV_START_INDEX;
    public static final int PLAYER_HOTBAR_END_INDEX;
    public static final int PLAYER_INV_END_INDEX;
    protected class_3913 dataAccess;
    private CardSwitchContainer cardSwitchContainer;

    public BankMenu(class_3917<?> type, int id, class_1661 inv, class_2540 extraData) {
        super(type, id, inv, extraData);
    }

    public BankMenu(class_3917<?> type, int id, class_1661 inv, BankAccount contentHolder, class_3913 dataAccess) {
        super(type, id, inv, (Object)contentHolder);
        this.dataAccess = dataAccess;
        this.method_17360(dataAccess);
    }

    protected BankAccount createOnClient(class_2540 extraData) {
        BankAccount account = BankAccount.clientSide(extraData);
        this.dataAccess = account.dataAccess;
        this.method_17360(this.dataAccess);
        return account;
    }

    protected void initAndReadInventory(BankAccount contentHolder) {
    }

    protected void addSlots() {
        if (this.cardSwitchContainer == null) {
            this.cardSwitchContainer = new CardSwitchContainer(arg_0 -> ((BankMenu)this).method_7609(arg_0), this::switchTo);
        }
        int x = 13;
        int y = 71;
        for (Coin coin : Coin.values()) {
            this.method_7621(new SlotOutputMergingCoinBag(((BankAccount)this.contentHolder).linkedCoinBag, coin, x, y));
            x += 18;
        }
        this.method_7621(new SlotInputMergingCoinBag(((BankAccount)this.contentHolder).linkedCoinBag, null, 159, y));
        this.method_7621(new CardSlot.BoundCardSlot(this.cardSwitchContainer, 0, 8, 109));
        this.addPlayerSlots(40, 152);
    }

    private boolean switchTo(UUID otherAccount) {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            BankAccount account = Numismatics.BANK.getAccount(otherAccount);
            if (account != null) {
                if (account.isAuthorized((class_1657)serverPlayer)) {
                    Utils.openScreen(serverPlayer, account, account::sendToMenu);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected void saveData(BankAccount contentHolder) {
    }

    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        if (playerIn instanceof class_3222) {
            this.method_7607(this.player, this.cardSwitchContainer);
        }
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int index) {
        class_1735 clickedSlot = (class_1735)this.field_7761.get(index);
        if (!clickedSlot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 slotStack = CoinItem.clearDisplayedCount(clickedSlot.method_7677());
        class_1799 returnStack = slotStack.method_7972();
        if (index <= CARD_SLOT_INDEX) {
            int count = slotStack.method_7947();
            if (!this.method_7616(slotStack, PLAYER_INV_START_INDEX, PLAYER_INV_END_INDEX, false)) {
                return class_1799.field_8037;
            }
            returnStack = class_1799.field_8037;
            clickedSlot.method_7671(count);
        } else {
            if (slotStack.method_7909() instanceof CoinItem && !this.method_7616(slotStack, COIN_INPUT_SLOT_INDEX, COIN_INPUT_SLOT_INDEX + 1, false)) {
                return class_1799.field_8037;
            }
            if (NumismaticsTags.AllItemTags.CARDS.matches(slotStack) && !this.method_7616(slotStack, CARD_SLOT_INDEX, CARD_SLOT_INDEX + 1, false)) {
                return class_1799.field_8037;
            }
            if (index >= PLAYER_INV_START_INDEX && index < PLAYER_HOTBAR_END_INDEX && !this.method_7616(slotStack, PLAYER_HOTBAR_END_INDEX, PLAYER_INV_END_INDEX, false)) {
                return class_1799.field_8037;
            }
            if (index >= PLAYER_HOTBAR_END_INDEX && index < PLAYER_INV_END_INDEX && !this.method_7616(slotStack, PLAYER_INV_START_INDEX, PLAYER_HOTBAR_END_INDEX, false)) {
                return class_1799.field_8037;
            }
        }
        if (slotStack.method_7960()) {
            clickedSlot.method_7673(class_1799.field_8037);
        } else {
            clickedSlot.method_7668();
        }
        return returnStack;
    }

    static {
        COIN_INPUT_SLOT_INDEX = COIN_SLOTS = Coin.values().length;
        CARD_SLOT_INDEX = COIN_INPUT_SLOT_INDEX + 1;
        PLAYER_INV_START_INDEX = CARD_SLOT_INDEX + 1;
        PLAYER_HOTBAR_END_INDEX = PLAYER_INV_START_INDEX + 9;
        PLAYER_INV_END_INDEX = PLAYER_INV_START_INDEX + 36;
    }

    private class CardSwitchContainer
    implements class_1263 {
        private final Consumer<CardSwitchContainer> slotsChangedCallback;
        private final Function<UUID, Boolean> uuidChangedCallback;
        @NotNull
        protected final List<class_1799> stacks = new ArrayList<class_1799>();

        public CardSwitchContainer(Consumer<CardSwitchContainer> slotsChangedCallback, Function<UUID, Boolean> uuidChangedCallback) {
            this.slotsChangedCallback = slotsChangedCallback;
            this.uuidChangedCallback = uuidChangedCallback;
            this.stacks.add(class_1799.field_8037);
        }

        public int method_5439() {
            return 1;
        }

        protected class_1799 getStack() {
            return this.stacks.get(0);
        }

        public boolean method_5442() {
            return this.getStack().method_7960();
        }

        @NotNull
        public class_1799 method_5438(int slot) {
            return this.getStack();
        }

        @NotNull
        public class_1799 method_5434(int slot, int amount) {
            class_1799 stack = class_1262.method_5430(this.stacks, (int)0, (int)amount);
            if (!stack.method_7960()) {
                this.slotsChangedCallback.accept(this);
            }
            return stack;
        }

        @NotNull
        public class_1799 method_5441(int slot) {
            return class_1262.method_5428(this.stacks, (int)0);
        }

        public void method_5447(int slot, @NotNull class_1799 stack) {
            this.stacks.set(0, stack);
            if (CardItem.isBound(stack) && NumismaticsTags.AllItemTags.CARDS.matches(stack) && !this.uuidChangedCallback.apply(CardItem.get(stack)).booleanValue()) {
                this.stacks.set(0, CardItem.clear(stack));
                BankMenu.this.method_7607(BankMenu.this.player, this);
            }
            this.slotsChangedCallback.accept(this);
        }

        public void method_5431() {
        }

        public boolean method_5443(@NotNull class_1657 player) {
            return true;
        }

        public void method_5448() {
            this.stacks.set(0, class_1799.field_8037);
        }
    }
}

