/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.base.data.recipe;

import dev.ithundxr.createnumismatics.base.data.recipe.NumismaticsRecipeProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.class_1767;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DyedRecipeList
implements Iterable<NumismaticsRecipeProvider.GeneratedRecipe> {
    private static final int COLOR_AMOUNT = class_1767.values().length;
    protected final NumismaticsRecipeProvider.GeneratedRecipe[] values = new NumismaticsRecipeProvider.GeneratedRecipe[this.getColorCount()];

    public DyedRecipeList(Function<@NotNull class_1767, NumismaticsRecipeProvider.GeneratedRecipe> filler) {
        for (class_1767 color : class_1767.values()) {
            this.values[color.ordinal()] = filler.apply(color);
        }
    }

    protected int getColorCount() {
        return COLOR_AMOUNT;
    }

    public NumismaticsRecipeProvider.GeneratedRecipe get(@NotNull class_1767 color) {
        return this.values[color.ordinal()];
    }

    public NumismaticsRecipeProvider.GeneratedRecipe[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public Iterator<NumismaticsRecipeProvider.GeneratedRecipe> iterator() {
        return new Iterator<NumismaticsRecipeProvider.GeneratedRecipe>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DyedRecipeList.this.values.length;
            }

            @Override
            public NumismaticsRecipeProvider.GeneratedRecipe next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return DyedRecipeList.this.values[this.index++];
            }
        };
    }

    public static class NullableDyedRecipeList
    extends DyedRecipeList {
        public NullableDyedRecipeList(Function<@Nullable class_1767, NumismaticsRecipeProvider.GeneratedRecipe> filler) {
            super(filler);
            this.values[this.values.length - 1] = filler.apply(null);
        }

        @Override
        protected int getColorCount() {
            return COLOR_AMOUNT + 1;
        }

        @Override
        public NumismaticsRecipeProvider.GeneratedRecipe get(@Nullable class_1767 color) {
            if (color == null) {
                return this.values[this.values.length - 1];
            }
            return super.get(color);
        }
    }
}

