/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.base.data.lang;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import dev.ithundxr.createnumismatics.registry.NumismaticsAdvancements;
import java.util.Map;
import java.util.function.BiConsumer;

public class NumismaticsLangGen {
    public static void generate(RegistrateLangProvider provider) {
        BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
        NumismaticsLangGen.provideDefaultLang("interface", langConsumer);
        NumismaticsLangGen.provideDefaultLang("tooltips", langConsumer);
        NumismaticsAdvancements.provideLang(langConsumer);
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/numismatics/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }
}

