/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.item.group.sort;

import com.conquestrefabricated.core.item.group.sort.Sorter;
import com.conquestrefabricated.core.util.Provider;
import java.io.BufferedReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public class ItemList
implements Sorter<class_1799>,
Comparator<class_1799> {
    private final Map<String, Entry> index;

    private ItemList(Map<String, Entry> index) {
        this.index = index;
    }

    @Override
    public int compare(class_1799 o1, class_1799 o2) {
        int i1 = ItemList.getIndex(o1, this.index);
        int i2 = ItemList.getIndex(o2, this.index);
        return Integer.compare(i1, i2);
    }

    @Override
    public void apply(class_2371<class_1799> items) {
        this.fill(items);
        items.sort((Comparator)this);
    }

    private void fill(class_2371<class_1799> items) {
        for (Map.Entry<String, Entry> e : this.index.entrySet()) {
            if (ItemList.contains(items, e.getKey())) continue;
            int size = items.size();
            class_1792 item = e.getValue().stack.get();
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40200).register(entries -> {
                if (item != class_1802.field_8162) {
                    entries.method_45421((class_1935)item);
                }
            });
            if (items.size() != size) continue;
            items.add((Object)new class_1799((class_1935)item));
        }
    }

    private static int getIndex(class_1799 stack, Map<String, Entry> index) {
        String name = String.valueOf(class_7923.field_41178.method_10221((Object)stack.method_7909()));
        Entry entry = index.get(name);
        if (entry == null) {
            return index.size();
        }
        return entry.index;
    }

    private static boolean contains(List<class_1799> items, String find) {
        for (class_1799 stack : items) {
            if (!String.valueOf(class_7923.field_41178.method_10221((Object)stack.method_7909())).equals(find)) continue;
            return true;
        }
        return false;
    }

    public static ItemList read(BufferedReader reader) {
        AtomicInteger order = new AtomicInteger(0);
        HashMap<String, Entry> index = new HashMap<String, Entry>(50);
        reader.lines().forEach(item -> {
            if (item.isEmpty()) {
                return;
            }
            index.put((String)item, new Entry(order.get(), Provider.item(item)));
            order.addAndGet(1);
        });
        return new ItemList(index);
    }

    private static class Entry {
        private final int index;
        private final Provider<class_1792> stack;

        private Entry(int index, Provider<class_1792> provider) {
            this.index = index;
            this.stack = provider;
        }
    }
}

