/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.item.group.manager;

import com.conquestrefabricated.core.item.group.ConquestItemGroup;
import com.conquestrefabricated.core.item.group.manager.DelegateGroup;
import com.conquestrefabricated.core.item.group.manager.GroupType;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1761;
import net.minecraft.class_2378;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ItemGroupManager {
    private static final ItemGroupManager instance = new ItemGroupManager();
    public static final List<class_1761> fixed = Lists.newArrayList((Object[])new class_1761[]{class_7706.method_47344(), (class_1761)class_7923.field_44687.method_29107(class_7706.field_40206), (class_1761)class_7923.field_44687.method_29107(class_7706.field_40199)});
    private final Map<Class<?>, Set<class_1761>> conquestGroups = new HashMap();
    private final Map<GroupType, Set<class_1761>> groups = new EnumMap<GroupType, Set<class_1761>>(GroupType.class);

    public static void init() {
        instance.storeVanillaGroups();
        instance.storeModGroups();
    }

    private ItemGroupManager() {
        for (GroupType type : GroupType.values()) {
            this.groups.put(type, new HashSet());
        }
    }

    public void register(ConquestItemGroup group) {
        this.conquestGroups.computeIfAbsent(((Object)((Object)group)).getClass(), k -> new HashSet()).add(group);
        this.groups.put(GroupType.CONQUEST, this.conquestGroups.get(((Object)((Object)group)).getClass()));
    }

    public void setConquestType(Class<? extends ConquestItemGroup> type) {
        Set groupList = this.conquestGroups.getOrDefault(type, Collections.emptySet());
        this.groups.put(GroupType.CONQUEST, groupList);
    }

    public void setVisibleItemGroups(GroupType ... types) {
    }

    private void storeVanillaGroups() {
        Set<class_1761> groups = this.groups.get((Object)GroupType.VANILLA);
        for (class_1761 group : class_7706.method_47341()) {
            if (fixed.contains(group) || group instanceof ConquestItemGroup || group instanceof DelegateGroup) continue;
            groups.add(group);
        }
    }

    private void storeModGroups() {
        Set<class_1761> vanilla = this.groups.get((Object)GroupType.VANILLA);
        Set<class_1761> other = this.groups.get((Object)GroupType.OTHER);
        for (class_1761 group : class_7706.method_47341()) {
            if (vanilla.contains(group) || group instanceof ConquestItemGroup || group instanceof DelegateGroup) continue;
            other.add(group);
        }
    }

    public static ItemGroupManager getInstance() {
        return instance;
    }

    static {
        fixed.sort(Comparator.comparing(arg_0 -> ((class_2378)class_7923.field_44687).method_10206(arg_0)));
    }
}

