/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.item.group;

import com.conquestrefabricated.core.asset.lang.Translations;
import com.conquestrefabricated.core.init.Context;
import com.conquestrefabricated.core.item.family.FamilyGroup;
import com.conquestrefabricated.core.item.group.sort.ItemList;
import com.conquestrefabricated.core.item.group.sort.Sorter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;

public abstract class ConquestItemGroup
extends class_1761 {
    private static final String pathFormat = "/assets/%s/groups/%s.txt";
    private final int index;
    private final class_2561 translationKey;
    public final Sorter<class_1799> sorter;
    public List<class_1799> cached = Collections.emptyList();

    public ConquestItemGroup(int index, String label, class_1761.class_7915 row, int i, class_1761.class_7916 type, class_2561 text, Supplier<class_1799> supplier, class_1761.class_7914 entryCollector) {
        super(row, i, type, text, supplier, entryCollector);
        String namespace = Context.getInstance().getNamespace();
        this.index = index;
        this.translationKey = class_2561.method_43471((String)Translations.getKey("itemGroup", namespace, label));
        this.sorter = this.getItemSorter(namespace, label);
        Translations.getInstance().add(this.translationKey.getString(), Translations.translate(label));
    }

    public class_2561 method_7737() {
        return this.translationKey;
    }

    public void invalidate() {
        this.cached = Collections.emptyList();
    }

    public int getOrderIndex() {
        return this.index;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Sorter<class_1799> getItemSorter(String namespace, String label) {
        String path = String.format(pathFormat, namespace, label);
        try (InputStream in = FamilyGroup.class.getResourceAsStream(path);){
            ItemList itemList;
            if (in == null) {
                Sorter<class_1799> sorter = Sorter.none();
                return sorter;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                itemList = ItemList.read(reader);
            }
            return itemList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Sorter.none();
        }
    }

    public abstract void populate(class_2371<class_1799> var1);
}

