/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.item.family;

import com.conquestrefabricated.core.item.family.Family;
import com.conquestrefabricated.core.item.family.block.BlockFamily;
import com.conquestrefabricated.core.item.family.item.ItemFamily;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class FamilyRegistry<T extends class_1935> {
    public static final FamilyRegistry<class_2248> BLOCKS = new FamilyRegistry<class_2248>(BlockFamily.EMPTY);
    public static final FamilyRegistry<class_1792> ITEMS = new FamilyRegistry<class_1792>(ItemFamily.EMPTY);
    private final Family<T> empty;
    private final Map<class_2960, Family<T>> families = new HashMap<class_2960, Family<T>>();

    public FamilyRegistry(Family<T> empty) {
        this.empty = empty;
    }

    public void register(Family<T> family) {
        for (class_1935 member : family.getMembers()) {
            this.register(member, family);
        }
    }

    public void register(T member, Family<T> family) {
        if (family.isAbsent()) {
            return;
        }
        this.families.put(class_7923.field_41178.method_10221((Object)member.method_8389()), family);
    }

    public void registerToFamily(class_2960 parent, T child) {
        Family<T> family = this.getFamily(parent);
        if (family.isPresent()) {
            family.add(child);
        }
    }

    public Family<T> getFamily(T member) {
        return this.getFamily(class_7923.field_41178.method_10221((Object)member.method_8389()));
    }

    public Family<T> getFamily(class_2960 name) {
        return this.families.getOrDefault(name, this.empty);
    }

    public Stream<Family<T>> values() {
        return this.families.values().stream().distinct();
    }

    public static void bake() {
        BLOCKS.values().forEach(Family::trim);
        ITEMS.values().forEach(Family::trim);
    }
}

