/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.item.family;

import com.conquestrefabricated.core.item.family.TypeFilter;
import com.conquestrefabricated.core.util.OptimizedList;
import com.conquestrefabricated.core.util.OptionalValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public abstract class Family<T>
implements OptionalValue,
Comparator<T> {
    private final List<T> members;
    private final class_1761 group;
    private final Comparator<T> order;
    private T root = null;

    public Family(class_1761 group, List<T> members) {
        this(group, (t1, t2) -> 0, members);
    }

    public Family(class_1761 group, Comparator<T> order, List<T> members) {
        this.group = group;
        this.order = order;
        this.members = members;
    }

    protected abstract T emptyValue();

    protected abstract void addItem(class_1761 var1, class_2371<class_1799> var2, T var3);

    public void trim() {
        if (this.members instanceof ArrayList) {
            ((ArrayList)this.members).trimToSize();
            return;
        }
        if (this.members instanceof OptimizedList) {
            ((OptimizedList)this.members).trim();
        }
    }

    public class_1761 getGroup() {
        return this.group;
    }

    public T getRoot() {
        if (this.members.isEmpty()) {
            return this.emptyValue();
        }
        return this.members.get(0);
    }

    public Optional<T> getMember(int index) {
        if (index < this.members.size()) {
            return Optional.ofNullable(this.members.get(index));
        }
        return Optional.empty();
    }

    public Optional<T> getMember(Class<? extends T> type) {
        return this.members.stream().filter(t -> t.getClass() == type).findFirst();
    }

    public List<T> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public int size() {
        return this.members.size();
    }

    public int indexOf(T member) {
        return this.members.indexOf(member);
    }

    public Family<T> setRoot(T root) {
        this.root = root;
        if (!this.members.contains(root)) {
            this.members.add(root);
        }
        this.members.sort(this);
        return this;
    }

    public Family<T> add(T member) {
        if (!this.members.contains(member)) {
            this.members.add(member);
            this.members.sort(this);
        }
        return this;
    }

    public Family<T> add(T ... members) {
        for (T t : members) {
            this.add(t);
        }
        return this;
    }

    public void addAllItems(class_1761 group, class_2371<class_1799> list) {
        this.addAllItems(group, list, TypeFilter.ANY);
    }

    public void addAllItems(class_1761 group, class_2371<class_1799> list, TypeFilter filter) {
        if (group == class_7923.field_44687.method_29107(class_7706.field_40200) || group == this.group) {
            for (T t : this.members) {
                if (!filter.test(t)) continue;
                this.addItem(group, list, t);
            }
        }
    }

    public void addRootItem(class_1761 group, class_2371<class_1799> list) {
        if (group == class_7923.field_44687.method_29107(class_7706.field_40200) || group == this.group) {
            this.addItem(group, list, this.getRoot());
        }
    }

    @Override
    public final int compare(T t1, T t2) {
        if (this.root != null) {
            if (t1 == this.root && t2 != this.root) {
                return -1;
            }
            if (t2 == this.root && t1 != this.root) {
                return 1;
            }
        }
        if (this.order != null) {
            return this.order.compare(t1, t2);
        }
        return 0;
    }

    public static interface Filler {
        public void fill(Family var1, class_1761 var2, class_2371<class_1799> var3);
    }
}

