/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.config;

import com.conquestrefabricated.core.config.ConfigManager;
import com.conquestrefabricated.core.config.section.ConfigSectionSpec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigBuildEvent {
    private final ConfigManager manager;
    private final Map<ModConfig.Type, ForgeConfigSpec.Builder> builders = new HashMap<ModConfig.Type, ForgeConfigSpec.Builder>();

    public ConfigBuildEvent(ConfigManager manager) {
        this.manager = manager;
    }

    public ConfigSectionSpec client(String name, String ... comment) {
        return this.section(ModConfig.Type.CLIENT, name, comment);
    }

    public ConfigSectionSpec common(String name, String ... comment) {
        return this.section(ModConfig.Type.COMMON, name, comment);
    }

    public ConfigSectionSpec server(String name, String ... comment) {
        return this.section(ModConfig.Type.SERVER, name, comment);
    }

    public void forEach(BiConsumer<ModConfig.Type, ForgeConfigSpec.Builder> consumer) {
        this.builders.forEach(consumer);
    }

    private ConfigSectionSpec section(ModConfig.Type type, String section, String ... comment) {
        ForgeConfigSpec.Builder root = this.builders.computeIfAbsent(type, t -> new ForgeConfigSpec.Builder().comment(comment));
        return new ConfigSectionSpec(this.manager, section, type, root.push(section));
    }
}

