/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.block.factory;

import com.conquestrefabricated.core.util.OptimizedList;
import com.conquestrefabricated.core.util.cache.Cache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2189;
import net.minecraft.class_2248;

public class TypeList
implements Iterable<Class<? extends class_2248>>,
Comparator<class_2248> {
    public static final TypeList EMPTY = new TypeList(Collections.emptyList());
    private static final Cache<TypeKey, TypeList> cache = new TypeListCache();
    private final List<Class<? extends class_2248>> types;

    private TypeList(List<Class<? extends class_2248>> types) {
        this.types = types;
    }

    public boolean isEmpty() {
        return this.types.isEmpty();
    }

    public Class<? extends class_2248> first() {
        if (this.types.size() > 0) {
            return this.types.get(0);
        }
        return class_2189.class;
    }

    public static TypeList of(Collection<Class<? extends class_2248>> types) {
        return new TypeList(new ArrayList<Class<? extends class_2248>>(types));
    }

    @SafeVarargs
    public static TypeList of(Class<? extends class_2248> ... types) {
        if (types.length == 0) {
            throw new RuntimeException("No Types provided!");
        }
        return cache.get(new TypeKey(types));
    }

    public TypeList add(Class<? extends class_2248> type) {
        if (type == null) {
            throw new IllegalArgumentException("Cannot add null type to TypeList");
        }
        ArrayList<Class<? extends class_2248>> newTypes = new ArrayList<Class<? extends class_2248>>(this.types);
        newTypes.add(type);
        return new TypeList(newTypes);
    }

    public TypeList addAll(Collection<Class<? extends class_2248>> types) {
        if (types == null || types.isEmpty()) {
            return this;
        }
        ArrayList<Class<? extends class_2248>> newTypes = new ArrayList<Class<? extends class_2248>>(this.types);
        newTypes.addAll(types);
        return new TypeList(newTypes);
    }

    @SafeVarargs
    public final TypeList addAll(Class<? extends class_2248> ... types) {
        if (types == null || types.length == 0) {
            return this;
        }
        return this.addAll(Arrays.asList(types));
    }

    public TypeList remove(Class<? extends class_2248> type) {
        if (type == null || !this.types.contains(type)) {
            return this;
        }
        ArrayList<Class<? extends class_2248>> newTypes = new ArrayList<Class<? extends class_2248>>(this.types);
        newTypes.remove(type);
        if (newTypes.isEmpty()) {
            return EMPTY;
        }
        return new TypeList(newTypes);
    }

    public TypeList removeAll(Collection<Class<? extends class_2248>> typesToRemove) {
        if (typesToRemove == null || typesToRemove.isEmpty()) {
            return this;
        }
        ArrayList<Class<? extends class_2248>> newTypes = new ArrayList<Class<? extends class_2248>>(this.types);
        newTypes.removeAll(typesToRemove);
        if (newTypes.isEmpty()) {
            return EMPTY;
        }
        return new TypeList(newTypes);
    }

    @SafeVarargs
    public final TypeList removeAll(Class<? extends class_2248> ... types) {
        if (types == null || types.length == 0) {
            return this;
        }
        return this.removeAll(Arrays.asList(types));
    }

    public TypeList replace(Class<? extends class_2248> oldType, Class<? extends class_2248> newType) {
        if (oldType == null || newType == null || !this.types.contains(oldType)) {
            return this;
        }
        ArrayList<Class<? extends class_2248>> newTypes = new ArrayList<Class<? extends class_2248>>(this.types);
        int index = newTypes.indexOf(oldType);
        newTypes.set(index, newType);
        return new TypeList(newTypes);
    }

    @Override
    public Iterator<Class<? extends class_2248>> iterator() {
        return this.types.iterator();
    }

    @Override
    public int compare(class_2248 b1, class_2248 b2) {
        return this.getIndex(b1) - this.getIndex(b2);
    }

    private int getIndex(Object o) {
        int max = -1;
        for (int i = 0; i < this.types.size(); ++i) {
            Class<? extends class_2248> type = this.types.get(i);
            if (!type.isInstance(o)) continue;
            max = Math.max(max, i);
        }
        return max == -1 ? this.types.size() : max;
    }

    private static class TypeKey {
        private final Class<? extends class_2248>[] types;

        private TypeKey(Class<? extends class_2248>[] types) {
            this.types = types;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeKey typeKey = (TypeKey)o;
            return Arrays.equals(this.types, typeKey.types);
        }

        public int hashCode() {
            return Arrays.hashCode(this.types);
        }
    }

    private static class TypeListCache
    extends Cache<TypeKey, TypeList> {
        private TypeListCache() {
        }

        @Override
        public TypeList compute(TypeKey typeKey) {
            OptimizedList<Class<? extends class_2248>> list = OptimizedList.of(typeKey.types);
            list.trim();
            return new TypeList(list);
        }
    }
}

