/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.block.factory;

import com.conquestrefabricated.core.block.builder.Props;
import com.conquestrefabricated.core.block.factory.BlockType;
import com.conquestrefabricated.core.block.factory.InitializationException;
import com.conquestrefabricated.core.block.factory.constructor.BaseConstructor;
import com.conquestrefabricated.core.block.factory.constructor.BlockConstructor;
import com.conquestrefabricated.core.block.factory.constructor.DoorConstructor;
import com.conquestrefabricated.core.block.factory.constructor.DyeConstructor;
import com.conquestrefabricated.core.block.factory.constructor.PropsConstructor;
import com.conquestrefabricated.core.block.factory.constructor.StateConstructor;
import com.conquestrefabricated.core.block.factory.constructor.WoodTypeConstructor;
import com.conquestrefabricated.core.util.cache.Cache;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_8177;

public class BlockTypeCache
extends Cache<Class<? extends class_2248>, BlockType> {
    private static final BlockTypeCache instance = new BlockTypeCache();
    private final List<Entry> entries = new LinkedList<Entry>();

    private BlockTypeCache() {
        this.register(PropsConstructor::new, Props.class);
        this.register(BaseConstructor::new, class_4970.class_2251.class);
        this.register(DyeConstructor::new, class_1767.class, class_4970.class_2251.class);
        this.register(BlockConstructor::new, class_2248.class, class_4970.class_2251.class);
        this.register(StateConstructor::new, class_2680.class, class_4970.class_2251.class);
        this.register(DoorConstructor::new, class_4970.class_2251.class, class_8177.class);
        this.register(WoodTypeConstructor::new, class_4970.class_2251.class, class_4719.class);
    }

    @Override
    public BlockType compute(Class<? extends class_2248> type) {
        for (Entry factory : this.entries) {
            try {
                Constructor<? extends class_2248> constructor = type.getConstructor(factory.argTypes);
                constructor.setAccessible(true);
                return factory.factory.create(constructor);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        throw new InitializationException("constructor not found for type " + String.valueOf(type));
    }

    public void register(BlockType.Factory factory, Class<?> ... argTypes) {
        this.entries.add(new Entry(factory, argTypes));
    }

    public static BlockTypeCache getInstance() {
        return instance;
    }

    private static class Entry {
        private final Class<?>[] argTypes;
        private final BlockType.Factory factory;

        private Entry(BlockType.Factory factory, Class<?>[] argTypes) {
            this.argTypes = argTypes;
            this.factory = factory;
        }
    }
}

