/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.block.data;

import com.conquestrefabricated.core.asset.annotation.Assets;
import com.conquestrefabricated.core.asset.annotation.Ingredient;
import com.conquestrefabricated.core.asset.annotation.Model;
import com.conquestrefabricated.core.asset.annotation.Recipe;
import com.conquestrefabricated.core.asset.annotation.Render;
import com.conquestrefabricated.core.asset.annotation.State;
import com.conquestrefabricated.core.asset.override.EmptyOverride;
import com.conquestrefabricated.core.asset.override.MapOverride;
import com.conquestrefabricated.core.asset.override.SingleOverride;
import com.conquestrefabricated.core.asset.pack.Locations;
import com.conquestrefabricated.core.asset.pack.VirtualResourcepack;
import com.conquestrefabricated.core.asset.template.JsonOverride;
import com.conquestrefabricated.core.asset.template.JsonTemplate;
import com.conquestrefabricated.core.asset.template.TemplateCache;
import com.conquestrefabricated.core.asset.template.TemplateResource;
import com.conquestrefabricated.core.block.builder.BlockName;
import com.conquestrefabricated.core.block.builder.Props;
import com.conquestrefabricated.core.block.builder.Textures;
import com.conquestrefabricated.core.client.render.RenderLayerHelper;
import com.conquestrefabricated.core.util.RenderLayer;
import com.conquestrefabricated.core.util.log.Log;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.class_1091;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlockTemplate {
    private final State state;
    private final Model itemModel;
    private final Model[] blockModels;
    private final Recipe[] recipes;
    private final Render render;
    private final boolean plural;

    BlockTemplate(Class<?> type) {
        Assets assets = type.getAnnotation(Assets.class);
        this.state = assets != null ? assets.state() : null;
        this.itemModel = assets != null ? assets.item() : null;
        this.blockModels = assets != null ? assets.block() : null;
        this.recipes = assets != null ? assets.recipe() : null;
        this.render = BlockTemplate.getRender(type, assets);
        this.plural = this.state != null && this.state.plural();
    }

    public RenderLayer getRenderLayer() {
        if (this.render == null) {
            return RenderLayer.UNDEFINED;
        }
        return this.render.value();
    }

    public class_2960 getRegistryName(BlockName name) {
        if (this.state == null) {
            return new class_2960(name.getNamespace(), name.format("%s", this.plural));
        }
        return new class_2960(name.getNamespace(), name.format(this.state.name(), this.plural));
    }

    public void addClientResources(VirtualResourcepack.Builder builder, BlockName name, Textures textures, class_2960 regName) {
        this.addState(builder, name, regName);
        this.addItem(builder, name, regName);
        this.addModel(builder, name, textures, regName);
    }

    public void registerRenders(class_2248 block, Props props) {
        if (props.getRenderLayer() != RenderLayer.UNDEFINED) {
            RenderLayerHelper.register(block, props.getRenderLayer());
            return;
        }
        if (this.render != null) {
            RenderLayer layer = this.render.value();
            RenderLayerHelper.register(block, layer);
        }
    }

    public void addServerResources(VirtualResourcepack.Builder builder, BlockName name, class_2960 regName) {
        this.addRecipe(builder, name, regName);
    }

    private void addState(VirtualResourcepack.Builder builder, BlockName name, class_2960 regName) {
        if (this.state == null) {
            Log.debug("No state template for {}", regName);
            return;
        }
        Log.debug("Generating state for {}", regName);
        String templateName = this.state.template();
        String virtualName = name.namespaceFormat(this.state.name(), this.state.plural());
        String templatePath = Locations.statePath(new class_2960(templateName));
        String virtualPath = Locations.statePath(new class_2960(virtualName));
        JsonTemplate template = (JsonTemplate)TemplateCache.getInstance().get(templatePath);
        JsonOverride overrides = this.getOverrides(name, this.blockModels);
        builder.add(TemplateResource.asset(name.getNamespace(), virtualPath, overrides, template));
    }

    private void addModel(VirtualResourcepack.Builder builder, BlockName name, Textures textures, class_2960 regName) {
        if (this.blockModels == null) {
            Log.debug("No model template for {}", regName);
            return;
        }
        Log.debug("Generating model(s) for {}", regName);
        for (Model model : this.blockModels) {
            String templateName = model.template();
            String virtualName = name.namespaceFormat(model.name(), model.plural());
            String templatePath = Locations.modelPath(new class_1091(regName, templateName));
            String virtualPath = Locations.modelPath(new class_1091(regName, virtualName));
            JsonTemplate template = (JsonTemplate)TemplateCache.getInstance().get(templatePath);
            builder.add(TemplateResource.asset(name.getNamespace(), virtualPath, textures, template));
        }
    }

    private void addItem(VirtualResourcepack.Builder builder, BlockName name, class_2960 regName) {
        if (this.itemModel == null) {
            Log.debug("No item model template for {}", regName);
            return;
        }
        Log.debug("Generating item model for {}", regName);
        String templateName = this.itemModel.template();
        String itemModelName = name.namespaceFormat(this.itemModel.name(), this.plural);
        String parentModelName = name.namespaceFormat(this.itemModel.parent(), this.plural);
        String templatePath = Locations.modelPath(new class_1091(regName, templateName));
        String virtualPath = Locations.modelPath(new class_1091(regName, itemModelName));
        SingleOverride overrides = new SingleOverride("parent", (JsonElement)new JsonPrimitive(parentModelName));
        JsonTemplate template = (JsonTemplate)TemplateCache.getInstance().get(templatePath);
        builder.add(TemplateResource.asset(name.getNamespace(), virtualPath, overrides, template));
    }

    private void addRecipe(VirtualResourcepack.Builder builder, BlockName name, class_2960 regName) {
        if (this.recipes == null || this.recipes.length != 1) {
            Log.debug("No recipe template for {}", regName);
            return;
        }
        Recipe recipe = this.recipes[0];
        String templateName = recipe.template();
        String recipeName = name.namespaceFormat(recipe.name(), this.plural);
        String output = recipe.output().isEmpty() ? recipe.template() : recipe.output();
        String item = new class_2960(output).toString();
        Ingredient result = BlockTemplate.createIngredient(recipe.name(), item, this.plural);
        Ingredient[] ingredients = this.push(recipe.ingredients(), result);
        String templatePath = Locations.recipePath(new class_2960(templateName));
        String virtualPath = Locations.recipePath(new class_2960(recipeName));
        JsonOverride overrides = this.getOverrides(name, ingredients);
        if (overrides == EmptyOverride.EMPTY) {
            Log.error("Unable to generate recipe for {} (invalid ingredients)", regName);
            return;
        }
        Log.debug("Generating recipe for {}", regName);
        JsonTemplate template = (JsonTemplate)TemplateCache.getInstance().get(templatePath);
        builder.add(TemplateResource.data(name.getNamespace(), virtualPath, overrides, template));
    }

    private JsonOverride getOverrides(BlockName name, Model[] replacements) {
        if (replacements.length == 0) {
            return EmptyOverride.EMPTY;
        }
        if (replacements.length == 1) {
            String find = replacements[0].template();
            String replace = name.namespaceFormat(replacements[0].name(), this.plural);
            return new SingleOverride("model", (JsonElement)new JsonPrimitive(find), (JsonElement)new JsonPrimitive(replace));
        }
        HashMap<JsonElement, JsonElement> overrides = new HashMap<JsonElement, JsonElement>(replacements.length);
        for (Model model : replacements) {
            String find = model.template();
            String replace = name.namespaceFormat(model.name(), model.plural());
            overrides.put((JsonElement)new JsonPrimitive(find), (JsonElement)new JsonPrimitive(replace));
        }
        return new MapOverride("model", overrides);
    }

    private JsonOverride getOverrides(BlockName name, Ingredient[] ingredients) {
        if (ingredients.length == 0) {
            return EmptyOverride.EMPTY;
        }
        if (ingredients.length == 1) {
            String find = ingredients[0].template();
            String replace = this.getIngredient(name, ingredients[0]);
            if (replace.isEmpty()) {
                return EmptyOverride.EMPTY;
            }
            return new SingleOverride("item", (JsonElement)new JsonPrimitive(find), (JsonElement)new JsonPrimitive(replace));
        }
        HashMap<JsonElement, JsonElement> overrides = new HashMap<JsonElement, JsonElement>(ingredients.length);
        for (Ingredient ingredient : ingredients) {
            String find = new class_2960(ingredient.template()).toString();
            String replace = this.getIngredient(name, ingredient);
            if (replace.isEmpty()) {
                return EmptyOverride.EMPTY;
            }
            overrides.put((JsonElement)new JsonPrimitive(find), (JsonElement)new JsonPrimitive(replace));
        }
        return new MapOverride("item", overrides);
    }

    private String getIngredient(BlockName name, Ingredient ingredient) {
        String itemName = name.format(ingredient.name(), ingredient.plural());
        if (class_7923.field_41178.method_10250(new class_2960(name.getNamespace(), itemName))) {
            Log.debug(" Found ingredient {}:{}", name.getNamespace(), itemName);
            return name.getNamespace() + ":" + itemName;
        }
        if (class_7923.field_41178.method_10250(new class_2960(itemName))) {
            Log.debug(" Found vanilla ingredient minecraft:{}", itemName);
            return "minecraft:" + itemName;
        }
        Log.error(" Unknown ingredient {}", itemName);
        return "";
    }

    private <T> T[] push(T[] t, T value) {
        T[] array = Arrays.copyOf(t, t.length + 1);
        array[array.length - 1] = value;
        return array;
    }

    private static Render getRender(Class<?> type, @Nullable Assets assets) {
        while (type != Object.class) {
            Render render = type.getAnnotation(Render.class);
            if (render != null) {
                return render;
            }
            if (assets != null && assets.render().value() != RenderLayer.UNDEFINED) {
                return assets.render();
            }
            type = type.getSuperclass();
            assets = type.getAnnotation(Assets.class);
        }
        return null;
    }

    private static Ingredient createIngredient(final String name, final String template, final boolean plrual) {
        return new Ingredient(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Ingredient.class;
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public String template() {
                return template;
            }

            @Override
            public boolean plural() {
                return plrual;
            }
        };
    }
}

