/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.block.data;

import com.conquestrefabricated.core.asset.annotation.ItemDescription;
import com.conquestrefabricated.core.asset.pack.VirtualResourcepack;
import com.conquestrefabricated.core.block.builder.BlockName;
import com.conquestrefabricated.core.block.builder.Props;
import com.conquestrefabricated.core.block.data.BlockTemplate;
import com.conquestrefabricated.core.block.factory.InitializationException;
import java.util.List;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlockData {
    private final class_2248 block;
    private final Props props;
    private final BlockName blockName;
    private final BlockTemplate template;
    private final class_2960 registryName;
    private class_1792 item = null;

    public BlockData(class_2248 block, BlockTemplate template, BlockName blockName, Props props) {
        this.template = template;
        this.registryName = template.getRegistryName(blockName);
        this.blockName = blockName;
        this.block = block;
        this.props = props;
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)this.registryName, (Object)this.block);
    }

    public class_2248 getBlock() {
        return this.block;
    }

    public class_1792 getItem() throws InitializationException {
        if (this.item == null) {
            class_1792.class_1793 properties = new class_1792.class_1793();
            try {
                this.item = new class_1747(this.getBlock(), properties){

                    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
                        ItemDescription tooltipAnnotation = this.method_7711().getClass().getAnnotation(ItemDescription.class);
                        if (tooltipAnnotation != null) {
                            tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.conquest.block." + tooltipAnnotation.description())));
                        }
                    }
                };
                return this.item;
            }
            catch (Throwable t) {
                throw new InitializationException(t);
            }
        }
        return this.item;
    }

    public Props getProps() {
        return this.props;
    }

    public BlockName getBlockName() {
        return this.blockName;
    }

    public class_2960 getRegistryName() {
        return this.registryName;
    }

    public void addClientResources(VirtualResourcepack.Builder builder) {
        if (!this.props.isManual()) {
            this.template.addClientResources(builder, this.blockName, this.props.textures(), this.registryName);
        }
    }

    public void addServerResources(VirtualResourcepack.Builder builder) {
        if (!this.props.isManual()) {
            this.template.addServerResources(builder, this.blockName, this.registryName);
        }
    }

    public void addRenders() {
        this.template.registerRenders(this.block, this.props);
    }
}

