/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.block.builder;

import com.conquestrefabricated.core.block.factory.InitializationException;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_7706;

public abstract class BlockProps<T extends BlockProps<T>> {
    private final class_2248 block;
    private final class_3620 color;
    private class_1767 dyeColor = null;
    private class_2498 sound = null;
    private class_1761 group = class_7706.method_47344();
    private ToIntFunction<class_2680> light = null;
    private Float resistance = null;
    private Float hardness = null;
    private Float slipperiness = null;
    private Boolean randomTick = null;
    private Boolean variableOpacity = null;
    private Boolean dynamicBounds = null;
    private Boolean blocksMovement = null;
    private Boolean solid = null;
    private class_4970.class_2250 offset = class_4970.class_2250.field_10656;

    protected BlockProps(class_2248 block) {
        this.block = block;
        this.color = null;
    }

    protected BlockProps(BlockProps<T> props) {
        this.block = props.block;
        this.color = props.color;
        this.dyeColor = props.dyeColor;
        this.sound = props.sound;
        this.group = props.group;
        this.light = props.light;
        this.resistance = props.resistance;
        this.hardness = props.hardness;
        this.slipperiness = props.slipperiness;
        this.randomTick = props.randomTick;
        this.variableOpacity = props.variableOpacity;
        this.blocksMovement = props.blocksMovement;
        this.dynamicBounds = props.dynamicBounds;
        this.solid = props.solid;
        this.offset = props.offset;
    }

    public abstract T getProps();

    public T dye(class_1767 color) {
        this.dyeColor = color;
        return this.getProps();
    }

    public T sound(class_2498 sound) {
        this.sound = sound;
        return this.getProps();
    }

    public T light(ToIntFunction<class_2680> light) {
        this.light = light;
        return (T)this;
    }

    public T strength(double hardness, double resistance) {
        this.hardness = Float.valueOf((float)hardness);
        this.resistance = Float.valueOf((float)resistance);
        return this.getProps();
    }

    public T slipperiness(double slipperiness) {
        this.slipperiness = Float.valueOf((float)slipperiness);
        return this.getProps();
    }

    public T randomTick(boolean randomTick) {
        this.randomTick = randomTick;
        return this.getProps();
    }

    public T dynamicBounds(boolean dynamicBounds) {
        this.dynamicBounds = dynamicBounds;
        return this.getProps();
    }

    public T opacity(boolean variableOpacity) {
        this.variableOpacity = variableOpacity;
        return this.getProps();
    }

    public T blocking(boolean blocksMovement) {
        this.blocksMovement = blocksMovement;
        return this.getProps();
    }

    public T solid(boolean solid) {
        this.solid = solid;
        return this.getProps();
    }

    public T group(class_1761 group) {
        this.group = group;
        return this.getProps();
    }

    public T offset(class_4970.class_2250 offsetType) {
        this.offset = offsetType;
        return this.getProps();
    }

    public class_1761 group() {
        return this.group;
    }

    public class_1767 dye() {
        return this.dyeColor == null ? class_1767.field_7963 : this.dyeColor;
    }

    public class_3620 color() {
        return this.color == null ? class_3620.field_16009 : this.color;
    }

    public class_4970.class_2251 toSettings() throws InitializationException {
        class_4970.class_2251 builder = this.createBuilder();
        BlockProps.applyNonNull(this.sound, arg_0 -> ((class_4970.class_2251)builder).method_9626(arg_0));
        BlockProps.applyNonNull(this.light, arg_0 -> ((class_4970.class_2251)builder).method_9631(arg_0));
        BlockProps.applyNonNull(this.slipperiness, arg_0 -> ((class_4970.class_2251)builder).method_9628(arg_0));
        BlockProps.applyNonNull(this.solid, false, () -> ((class_4970.class_2251)builder).method_22488());
        BlockProps.applyNonNull(this.randomTick, true, () -> ((class_4970.class_2251)builder).method_9640());
        BlockProps.applyNonNull(this.dynamicBounds, true, () -> ((class_4970.class_2251)builder).method_9624());
        BlockProps.applyNonNull(this.variableOpacity, true, () -> ((class_4970.class_2251)builder).method_9624());
        BlockProps.applyNonNull(this.blocksMovement, false, () -> ((class_4970.class_2251)builder).method_9634());
        BlockProps.applyNonNull(this.offset, arg_0 -> ((class_4970.class_2251)builder).method_49229(arg_0));
        if (this.hardness != null && this.resistance != null) {
            builder.method_9629(this.hardness.floatValue(), this.resistance.floatValue());
        }
        return builder;
    }

    private class_4970.class_2251 createBuilder() throws InitializationException {
        class_4970.class_2251 props;
        if (this.block != null) {
            props = class_4970.class_2251.method_9630((class_4970)this.block);
        } else if (this.color != null) {
            props = class_4970.class_2251.method_9637().method_31710(this.color);
        } else {
            throw new InitializationException("Block.Builder requires a Material");
        }
        return props;
    }

    private static <T> void applyNonNull(Boolean value, boolean condition, Runnable runnable) {
        if (value != null && value == condition) {
            runnable.run();
        }
    }

    private static <T> void applyNonNull(T value, Consumer<T> consumer) {
        if (value != null) {
            consumer.accept(value);
        }
    }

    protected abstract <T> void applyNonNull(Integer var1, Consumer<T> var2);
}

