/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.asset.lang;

import com.conquestrefabricated.core.asset.VirtualResource;
import com.conquestrefabricated.core.asset.lang.Translations;
import com.conquestrefabricated.core.util.ByteStream;
import com.google.gson.JsonElement;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class VirtualLang
implements VirtualResource {
    private final String path;
    private final String namespace;

    public VirtualLang(String namespace) {
        this.namespace = namespace;
        this.path = "assets/" + namespace + "/lang/en_us.json";
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public class_3264 getType() {
        return class_3264.field_14188;
    }

    @Override
    public JsonElement getJson(class_3300 resourceManager) throws IOException {
        JsonTreeWriter writer = new JsonTreeWriter();
        this.write((JsonWriter)writer);
        return writer.get();
    }

    @Override
    public InputStream getInputStream(class_3300 resourceManager) throws IOException {
        ByteStream.Output output = new ByteStream.Output();
        JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(output));
        this.write(writer);
        writer.flush();
        return output.toInputStream();
    }

    private void write(JsonWriter writer) throws IOException {
        writer.setIndent("  ");
        writer.beginObject();
        HashSet<String> visited = new HashSet<String>();
        Translations.getInstance().forEach((key, value) -> this.writeSafe((String)key, (String)value, writer, (Set<String>)visited));
        this.writeTranslations(class_7923.field_41175, "block", writer, visited);
        this.writeTranslations(class_7923.field_41178, "item", writer, visited);
        this.writeTranslations(class_7923.field_41177, "entity", writer, visited);
        writer.endObject();
    }

    private void writeSafe(String key, String value, JsonWriter writer, Set<String> visited) {
        if (visited.add(key)) {
            try {
                writer.name(key).value(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeTranslations(class_7922<?> registry, String type, JsonWriter writer, Set<String> visited) throws IOException {
        for (class_2960 entry : registry.method_10235()) {
            String key;
            class_2960 name = entry;
            if (name == null || !name.method_12836().equals(this.getNamespace()) || !visited.add(key = Translations.getKey(type, name))) continue;
            String value = Translations.translate(name.method_12832());
            writer.name(key);
            writer.value(value);
        }
    }
}

