/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.content.entities.painting.render;

import com.conquestrefabricated.content.entities.painting.EntityPainting;
import com.conquestrefabricated.content.entities.painting.art.ArtType;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_761;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PaintingRenderer
extends class_897<EntityPainting> {
    public PaintingRenderer(class_5617.class_5618 renderManager) {
        super(renderManager);
    }

    public void render(EntityPainting painting, float yaw, float ticks, class_4587 matrix, class_4597 buffer, int light) {
        matrix.method_22903();
        matrix.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), 180.0f - yaw));
        matrix.method_22905(0.0625f, 0.0625f, 0.0625f);
        ArtType art = painting.getArt();
        class_2960 texture = this.getTexture(painting);
        class_1921 renderType = class_1921.method_23576((class_2960)texture);
        class_4588 builder = buffer.getBuffer(renderType);
        this.render(matrix, builder, painting, art.sizeX, art.sizeY, art.offsetX, art.offsetY);
        matrix.method_22909();
        super.method_3936((class_1297)painting, yaw, ticks, matrix, buffer, light);
    }

    public class_2960 getTexture(EntityPainting entity) {
        return entity.getPaintingType().getRegistryName();
    }

    private void render(class_4587 matrix, class_4588 builder, EntityPainting entity, int width, int height, int textureU, int textureV) {
        class_4587.class_4665 entry = matrix.method_23760();
        Matrix4f position = entry.method_23761();
        Matrix3f normals = entry.method_23762();
        float xCenter = (float)(-width) / 2.0f;
        float yCenter = (float)(-height) / 2.0f;
        for (int x = 0; x < width / 16; ++x) {
            for (int y = 0; y < height / 16; ++y) {
                float minX = xCenter + (float)(x * 16);
                float minY = yCenter + (float)(y * 16);
                float maxX = xCenter + (float)((x + 1) * 16);
                float maxY = yCenter + (float)((y + 1) * 16);
                int lightX = class_3532.method_15357((double)entity.method_23317());
                int lightY = class_3532.method_15357((double)(entity.method_23318() + (double)((maxY + minY) / 2.0f / 16.0f)));
                int lightZ = class_3532.method_15357((double)entity.method_23321());
                int light = class_761.method_23794((class_1920)entity.method_37908(), (class_2338)new class_2338(lightX, lightY, lightZ));
                float txMin = (float)(textureU + width - x * 16) / 256.0f;
                float txMax = (float)(textureU + width - (x + 1) * 16) / 256.0f;
                float tyMin = (float)(textureV + height - y * 16) / 256.0f;
                float tyMax = (float)(textureV + height - (y + 1) * 16) / 256.0f;
                this.vertex(position, normals, builder, maxX, minY, txMax, tyMin, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, minX, minY, txMin, tyMin, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, minX, maxY, txMin, tyMax, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, maxX, maxY, txMax, tyMax, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, maxX, maxY, txMax, tyMax, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, minX, maxY, txMin, tyMax, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, minX, minY, txMin, tyMin, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, maxX, minY, txMax, tyMin, 0.2f, 0, 0, -1, light);
            }
        }
    }

    private void vertex(Matrix4f position, Matrix3f normals, class_4588 builder, float x, float y, float u, float v, float z, int nx, int ny, int nz, int light) {
        builder.method_22918(position, x, y, z).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light).method_23763(normals, (float)nx, (float)ny, (float)nz).method_1344();
    }
}

