/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.content.entities.painting;

import com.conquestrefabricated.api.painting.Painting;
import com.conquestrefabricated.api.util.Translateable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.class_2960;

public class ModPainting
implements Translateable,
Painting {
    private static final class_2960 ITEM = new class_2960("conquest", "painting");
    private static final ModPainting UNKNOWN = new ModPainting("unknown");
    private static final Map<String, ModPainting> types = new ConcurrentHashMap<String, ModPainting>();
    private final String name;
    private final class_2960 texture;

    private ModPainting(String name) {
        this.name = name;
        this.texture = new class_2960("conquest", "textures/entity/painting/" + name + ".png");
    }

    public boolean isPresent() {
        return this != UNKNOWN;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public class_2960 getItemName() {
        return ITEM;
    }

    @Override
    public class_2960 getRegistryName() {
        return this.texture;
    }

    @Override
    public String getTranslationKey() {
        return this.getTranslationKey("conquest");
    }

    @Override
    public String getTranslationKey(String parent) {
        return parent + "." + this.getName();
    }

    public static ModPainting fromId(String id) {
        if (id == null) {
            return UNKNOWN;
        }
        return types.getOrDefault(id, UNKNOWN);
    }

    public static ModPainting fromName(String name) {
        ModPainting type = ModPainting.fromId(name);
        if (type != UNKNOWN) {
            return type;
        }
        System.out.println(name);
        for (ModPainting t : types.values()) {
            if (name.equalsIgnoreCase(t.getName())) {
                return t;
            }
            if (!name.equalsIgnoreCase(t.getDisplayName())) continue;
            return t;
        }
        return UNKNOWN;
    }

    public static ModPainting register(String id) {
        ModPainting painting = new ModPainting(id);
        types.put(id, painting);
        return painting;
    }

    public static Stream<String> getIds() {
        return types.values().stream().map(ModPainting::getName);
    }
}

